/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.ant;

import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.enterprise.deployment.ant.ILoadMethod;
import com.ibm.team.enterprise.deployment.ant.LoadMethodFactory;
import com.ibm.team.enterprise.deployment.ant.Messages;
import java.io.File;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Mkdir;
import org.eclipse.osgi.util.NLS;

public class LoadPackageTask
extends Task {
    private File packageSourceLocation;
    private File packageTargetLocation;
    private String loadMethodType;

    public void execute() throws BuildException {
        Mkdir mkdirOp = new Mkdir();
        mkdirOp.setDir(this.packageTargetLocation);
        mkdirOp.execute();
        ILoadMethod loadMethod = LoadMethodFactory.getInstance().getLoadMethod(this.loadMethodType);
        if (loadMethod == null) {
            throw new BuildException(String.valueOf(Messages.LoadPackageTask_NO_LOAD_METHOD_SUPPORT) + this.loadMethodType);
        }
        loadMethod.setPackageSourceLocation(this.packageSourceLocation);
        loadMethod.setPackageTargetLocation(this.packageTargetLocation);
        loadMethod.setProject(this.getProject());
        List<String> propertyNames = loadMethod.getRequiredPropertyNames();
        if (propertyNames != null) {
            for (String name : propertyNames) {
                String value = this.getProject().getProperty(name);
                if (value != null) {
                    throw new BuildException(NLS.bind((String)Messages.LoadPackageTask_MISSING_LOAD_PROPERTY, (Object)name, (Object)loadMethod.getType()));
                }
                loadMethod.setProperty(BuildItemFactory.createBuildProperty((String)name, (String)value));
            }
        }
        loadMethod.load();
    }

    public void setPackageSourceLocation(File packageSourceLocation) {
        this.packageSourceLocation = packageSourceLocation;
    }

    public void setPackageTargetLocation(File packageTargetLocation) {
        this.packageTargetLocation = packageTargetLocation;
    }

    public void setLoadMethodType(String loadMethodType) {
        this.loadMethodType = loadMethodType;
    }
}

