/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.common.jfs.impl;

import com.ibm.team.enterprise.automation.common.helper.DataTypeConverter;
import com.ibm.team.enterprise.automation.common.jfs.AbstractJFSParser;
import com.ibm.team.enterprise.automation.common.jfs.IJFSParser;
import com.ibm.team.enterprise.automation.common.jfs.IJFSResource;
import com.ibm.team.enterprise.deployment.common.jfs.DeploymentJFSConstants;
import com.ibm.team.enterprise.deployment.common.jfs.IDeployInfo;
import com.ibm.team.enterprise.deployment.common.jfs.IDeployment;
import com.ibm.team.enterprise.deployment.common.jfs.ILoadInfo;
import com.ibm.team.enterprise.deployment.common.jfs.impl.DeployInfo;
import com.ibm.team.enterprise.deployment.common.jfs.impl.Deployment;
import com.ibm.team.enterprise.deployment.common.jfs.impl.LoadInfo;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DeploymentJFSParser
extends AbstractJFSParser
implements IJFSParser,
DeploymentJFSConstants {
    public IJFSResource toJFSResource(String rdfXml) throws TeamRepositoryException {
        try {
            Document doc = DeploymentJFSParser.newDocument((InputStream)new ByteArrayInputStream(rdfXml.getBytes("UTF-8")));
            NodeList rdfDescriptionElements = doc.getElementsByTagName("rdf:Description");
            if (rdfDescriptionElements.getLength() > 0) {
                Element rdfDescriptionElement = (Element)rdfDescriptionElements.item(0);
                return this.parseDeployment(rdfDescriptionElement);
            }
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        return null;
    }

    public String toRDFXML(IJFSResource jfsResource) throws TeamRepositoryException {
        try {
            IDeployment deployment = (IDeployment)jfsResource;
            Document doc = DeploymentJFSParser.newDocument();
            Element rdfElement = doc.createElement("rdf:RDF");
            doc.appendChild(rdfElement);
            rdfElement.setAttribute("xmlns:rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
            rdfElement.setAttribute("xmlns:deployment", "http://www.ibm.com/team/enterprise/deployment/");
            rdfElement.setAttribute("xmlns:deploy", "http://www.ibm.com/team/enterprise/deployment/deploy/");
            rdfElement.setAttribute("xmlns:load", "http://www.ibm.com/team/enterprise/deployment/load/");
            rdfElement.setAttribute("xmlns:manifest", "http://www.ibm.com/team/enterprise/deployment/manifest/");
            Element rdfDescriptionElement = doc.createElement("rdf:Description");
            rdfDescriptionElement.setAttribute("rdf:about", deployment.getSlug());
            rdfElement.appendChild(rdfDescriptionElement);
            DeploymentJFSParser.createPropertyNode((Document)doc, (Element)rdfDescriptionElement, (String)"deployment:packageDefinitionUUID", (String)deployment.getPackageDefinitionUUID().getUuidValue());
            DeploymentJFSParser.createPropertyNode((Document)doc, (Element)rdfDescriptionElement, (String)"deployment:deploymentDefinitionUUID", (String)deployment.getDeploymentDefinitionUUID().getUuidValue());
            DeploymentJFSParser.createPropertyNode((Document)doc, (Element)rdfDescriptionElement, (String)"deployment:buildAgentUUID", (String)deployment.getBuildAgentUUID().getUuidValue());
            DeploymentJFSParser.createPropertyNode((Document)doc, (Element)rdfDescriptionElement, (String)"deployment:rollbackLocation", (String)deployment.getRollbackLocation());
            UUID rollbackDeployInfoUUID = deployment.getRollbackDeployInfoUUID();
            String rollbackDeployInfo = "";
            if (rollbackDeployInfoUUID != null) {
                rollbackDeployInfo = rollbackDeployInfoUUID.getUuidValue();
            }
            DeploymentJFSParser.createPropertyNode((Document)doc, (Element)rdfDescriptionElement, (String)"deployment:rollbackDeployResultUUID", (String)rollbackDeployInfo);
            for (ILoadInfo loadInfo : deployment.getLoadInfo()) {
                this.createLoadInfoElement(doc, rdfDescriptionElement, loadInfo);
            }
            for (IDeployInfo deployInfo : deployment.getDeployInfos()) {
                this.createDeployInfoElement(doc, rdfDescriptionElement, deployInfo);
            }
            return DeploymentJFSParser.transform((Document)doc);
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    private IDeployment parseDeployment(Element rdfDescriptionElement) {
        String packageDefinitionUUID = DeploymentJFSParser.getElementValue((Element)rdfDescriptionElement, (String)"deployment:packageDefinitionUUID");
        String deploymentDefinitionUUID = DeploymentJFSParser.getElementValue((Element)rdfDescriptionElement, (String)"deployment:deploymentDefinitionUUID");
        String buildAgentUUID = DeploymentJFSParser.getElementValue((Element)rdfDescriptionElement, (String)"deployment:buildAgentUUID");
        String rollbackLocation = DeploymentJFSParser.getElementValue((Element)rdfDescriptionElement, (String)"deployment:rollbackLocation");
        String rollbackDeployResultUUID = DeploymentJFSParser.getElementValue((Element)rdfDescriptionElement, (String)"deployment:rollbackDeployResultUUID");
        Deployment deployment = new Deployment(UUID.valueOf((String)packageDefinitionUUID), UUID.valueOf((String)deploymentDefinitionUUID), UUID.valueOf((String)buildAgentUUID));
        deployment.setRollbackLocation(rollbackLocation);
        if (rollbackDeployResultUUID != null && !rollbackDeployResultUUID.equals("")) {
            deployment.setRollbackDeployInfoUUID(UUID.valueOf((String)rollbackDeployResultUUID));
        }
        this.parseLoadInfos(rdfDescriptionElement.getElementsByTagName("deployment:load"), deployment, UUID.valueOf((String)packageDefinitionUUID));
        this.parseDeployInfos(rdfDescriptionElement.getElementsByTagName("deployment:deploy"), deployment, UUID.valueOf((String)packageDefinitionUUID));
        return deployment;
    }

    private void parseLoadInfos(NodeList loadElements, IDeployment deployment, UUID packageDefinitionUUID) {
        int i = 0;
        while (i < loadElements.getLength()) {
            Element loadElement = (Element)loadElements.item(i);
            deployment.addLoadInfo(this.parseLoadInfo(loadElement, packageDefinitionUUID));
            ++i;
        }
    }

    private ILoadInfo parseLoadInfo(Element loadElement, UUID packageDefinitionUUID) {
        String packageResultUUID = DeploymentJFSParser.getElementValue((Element)loadElement, (String)"load:packageResultUUID");
        String buildResultUUID = DeploymentJFSParser.getElementValue((Element)loadElement, (String)"load:deploymentResultUUID");
        String summaryWorkItemId = DeploymentJFSParser.getElementValue((Element)loadElement, (String)"load:summaryWorkItemId");
        String summaryWorkItemUUID = DeploymentJFSParser.getElementValue((Element)loadElement, (String)"load:summaryWorkItemUUID");
        String packageLocation = DeploymentJFSParser.getElementValue((Element)loadElement, (String)"load:packageLocation");
        LoadInfo loadInfo = new LoadInfo(UUID.valueOf((String)buildResultUUID), UUID.valueOf((String)packageResultUUID), packageDefinitionUUID);
        loadInfo.setSummaryWorkItemId(DataTypeConverter.toWorkItemId((String)summaryWorkItemId));
        loadInfo.setSummaryWorkItemUUID(DataTypeConverter.toUUID((String)summaryWorkItemUUID));
        loadInfo.setPackageLocation(packageLocation);
        return loadInfo;
    }

    private void parseDeployInfos(NodeList deployElements, IDeployment deployment, UUID packageDefinitionUUID) {
        int i = 0;
        while (i < deployElements.getLength()) {
            Element deployElement = (Element)deployElements.item(i);
            deployment.addDeployInfo(this.parseDeployInfo(deployElement, packageDefinitionUUID));
            ++i;
        }
    }

    private IDeployInfo parseDeployInfo(Element deployElement, UUID packageDefinitionUUID) {
        String packageResultUUID = DeploymentJFSParser.getElementValue((Element)deployElement, (String)"deploy:packageResultUUID");
        String buildResultUUID = DeploymentJFSParser.getElementValue((Element)deployElement, (String)"deploy:deploymentResultUUID");
        String summaryWorkItemId = DeploymentJFSParser.getElementValue((Element)deployElement, (String)"deploy:summaryWorkItemId");
        String summaryWorkItemUUID = DeploymentJFSParser.getElementValue((Element)deployElement, (String)"deploy:summaryWorkItemUUID");
        DeployInfo deployInfo = new DeployInfo(UUID.valueOf((String)buildResultUUID), UUID.valueOf((String)packageResultUUID), packageDefinitionUUID);
        deployInfo.setSummaryWorkItemId(DataTypeConverter.toWorkItemId((String)summaryWorkItemId));
        deployInfo.setSummaryWorkItemUUID(DataTypeConverter.toUUID((String)summaryWorkItemUUID));
        this.parseContainers(deployElement, deployInfo);
        return deployInfo;
    }

    private void parseContainers(Element deployElement, IDeployInfo deployInfo) {
        NodeList containerNodes = deployElement.getElementsByTagName("manifest:container");
        int i = 0;
        while (i < containerNodes.getLength()) {
            Element containerElement = (Element)containerNodes.item(i);
            deployInfo.addContainer(this.parseContainer(containerElement));
            ++i;
        }
    }

    private Element createLoadInfoElement(Document doc, Element parentElement, ILoadInfo loadInfo) {
        Element loadInfoElement = DeploymentJFSParser.createRDFResourceElement((Document)doc, (Element)parentElement, (String)"deployment:load");
        DeploymentJFSParser.createPropertyNode((Document)doc, (Element)loadInfoElement, (String)"load:packageResultUUID", (String)loadInfo.getPackageResultUUID().getUuidValue());
        DeploymentJFSParser.createPropertyNode((Document)doc, (Element)loadInfoElement, (String)"load:deploymentResultUUID", (String)loadInfo.getBuildResultUUID().getUuidValue());
        int summaryWorkItemId = loadInfo.getSummaryWorkItemId();
        if (summaryWorkItemId > 0) {
            DeploymentJFSParser.createPropertyNode((Document)doc, (Element)loadInfoElement, (String)"load:summaryWorkItemId", (String)String.valueOf(summaryWorkItemId));
            DeploymentJFSParser.createPropertyNode((Document)doc, (Element)loadInfoElement, (String)"load:summaryWorkItemUUID", (String)loadInfo.getSummaryWorkItemUUID().getUuidValue());
        }
        DeploymentJFSParser.createPropertyNode((Document)doc, (Element)loadInfoElement, (String)"load:packageLocation", (String)loadInfo.getPackageLocation());
        return loadInfoElement;
    }

    private Element createDeployInfoElement(Document doc, Element parentElement, IDeployInfo deployInfo) {
        Element deployInfoElement = DeploymentJFSParser.createRDFResourceElement((Document)doc, (Element)parentElement, (String)"deployment:deploy");
        DeploymentJFSParser.createPropertyNode((Document)doc, (Element)deployInfoElement, (String)"deploy:packageResultUUID", (String)deployInfo.getPackageResultUUID().getUuidValue());
        DeploymentJFSParser.createPropertyNode((Document)doc, (Element)deployInfoElement, (String)"deploy:deploymentResultUUID", (String)deployInfo.getBuildResultUUID().getUuidValue());
        int summaryWorkItemId = deployInfo.getSummaryWorkItemId();
        if (summaryWorkItemId > 0) {
            DeploymentJFSParser.createPropertyNode((Document)doc, (Element)deployInfoElement, (String)"deploy:summaryWorkItemId", (String)String.valueOf(summaryWorkItemId));
            DeploymentJFSParser.createPropertyNode((Document)doc, (Element)deployInfoElement, (String)"deploy:summaryWorkItemUUID", (String)deployInfo.getSummaryWorkItemUUID().getUuidValue());
        }
        Element manifestElement = DeploymentJFSParser.createXMLLiteralElement((Document)doc, (Element)deployInfoElement, (String)"deploy:manifest");
        DeploymentJFSParser.createContainerElements((Document)doc, deployInfo.getContainers(), (Element)manifestElement);
        return deployInfoElement;
    }
}

