/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.common.jfs.impl;

import com.ibm.team.enterprise.deployment.common.jfs.IDeployInfo;
import com.ibm.team.enterprise.deployment.common.jfs.IDeployment;
import com.ibm.team.enterprise.deployment.common.jfs.ILoadInfo;
import com.ibm.team.enterprise.deployment.common.jfs.impl.DeploymentJFSParser;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.List;

public class Deployment
implements IDeployment {
    private UUID packageDefinitionUUID;
    private UUID deploymentDefinitionUUID;
    private UUID buildAgentUUID;
    private String rollbackLocation;
    private UUID rollbackDeployResultUUID;
    private List<ILoadInfo> loadInfos;
    private List<IDeployInfo> deployInfos;

    public Deployment(UUID packageDefinitionUUID, UUID deploymentDefinitionUUID, UUID buildAgentUUID) {
        this.packageDefinitionUUID = packageDefinitionUUID;
        this.deploymentDefinitionUUID = deploymentDefinitionUUID;
        this.buildAgentUUID = buildAgentUUID;
        this.loadInfos = new ArrayList<ILoadInfo>();
        this.deployInfos = new ArrayList<IDeployInfo>();
    }

    @Override
    public UUID getPackageDefinitionUUID() {
        return this.packageDefinitionUUID;
    }

    @Override
    public void setPackageDefinitionUUID(UUID packageDefinitionUUID) {
        this.packageDefinitionUUID = packageDefinitionUUID;
    }

    @Override
    public UUID getDeploymentDefinitionUUID() {
        return this.deploymentDefinitionUUID;
    }

    @Override
    public void setDeploymentDefinitionUUID(UUID deploymentDefinitionUUID) {
        this.deploymentDefinitionUUID = deploymentDefinitionUUID;
    }

    @Override
    public UUID getBuildAgentUUID() {
        return this.buildAgentUUID;
    }

    @Override
    public void setBuildAgentUUID(UUID buildAgentUUID) {
        this.buildAgentUUID = buildAgentUUID;
    }

    @Override
    public List<ILoadInfo> getLoadInfo() {
        return this.loadInfos;
    }

    @Override
    public void addLoadInfo(ILoadInfo loadInfo) {
        this.loadInfos.add(loadInfo);
    }

    @Override
    public ILoadInfo getLoadInfo(UUID buildResultUUID) {
        for (ILoadInfo loadInfo : this.loadInfos) {
            if (!loadInfo.getBuildResultUUID().equals((Object)buildResultUUID)) continue;
            return loadInfo;
        }
        return null;
    }

    @Override
    public ILoadInfo getLoadInfoByPackageResultUUID(UUID packageResultUUID) {
        for (ILoadInfo loadInfo : this.loadInfos) {
            if (!loadInfo.getPackageResultUUID().equals((Object)packageResultUUID)) continue;
            return loadInfo;
        }
        return null;
    }

    @Override
    public ILoadInfo getLoadInfo(String packageLocation) {
        if (packageLocation != null) {
            for (ILoadInfo loadInfo : this.loadInfos) {
                if (!packageLocation.equals(loadInfo.getPackageLocation())) continue;
                return loadInfo;
            }
        }
        return null;
    }

    @Override
    public void deleteLoadInfo(String packageLocation) {
        if (packageLocation != null) {
            int i = 0;
            boolean found = false;
            while (!found && i < this.loadInfos.size()) {
                if (packageLocation.equals(this.loadInfos.get(i).getPackageLocation())) {
                    found = true;
                    continue;
                }
                ++i;
            }
            if (found) {
                this.loadInfos.remove(i);
            }
        }
    }

    @Override
    public void deleteLoadInfo(UUID buildResultUUID) {
        int i = 0;
        boolean found = false;
        while (!found && i < this.loadInfos.size()) {
            if (this.loadInfos.get(i).getBuildResultUUID().equals((Object)buildResultUUID)) {
                found = true;
                continue;
            }
            ++i;
        }
        if (found) {
            this.loadInfos.remove(i);
        }
    }

    @Override
    public void addDeployInfo(IDeployInfo deployInfo) {
        this.deployInfos.add(deployInfo);
    }

    @Override
    public List<IDeployInfo> getDeployInfos() {
        return this.deployInfos;
    }

    @Override
    public IDeployInfo getDeployInfo(UUID buildResultUUID) {
        for (IDeployInfo deployInfo : this.deployInfos) {
            if (!deployInfo.getBuildResultUUID().equals((Object)buildResultUUID)) continue;
            return deployInfo;
        }
        return null;
    }

    @Override
    public String getRollbackLocation() {
        return this.rollbackLocation;
    }

    @Override
    public void setRollbackLocation(String rollbackDir) {
        this.rollbackLocation = rollbackDir;
    }

    @Override
    public void deleteDeployInfo(UUID buildResultUUID) {
        int i = 0;
        boolean found = false;
        while (!found && i < this.deployInfos.size()) {
            if (this.deployInfos.get(i).getBuildResultUUID().equals((Object)buildResultUUID)) {
                found = true;
                continue;
            }
            ++i;
        }
        if (found) {
            this.deployInfos.remove(i);
        }
    }

    @Override
    public void deleteDeployInfo(String packageResultUUID) {
        int i = 0;
        boolean found = false;
        while (!found && i < this.deployInfos.size()) {
            if (this.deployInfos.get(i).getPackageResultUUID().getUuidValue().equals(packageResultUUID)) {
                found = true;
                continue;
            }
            ++i;
        }
        if (found) {
            this.deployInfos.remove(i);
        }
    }

    public static final String generateSlug(String packageDefinitionUUID, String deploymentDefinitionUUID, String buildAgentUUID) {
        StringBuffer buffer = new StringBuffer("_packageDefinitionUUID=");
        buffer.append(packageDefinitionUUID).append("_deploymentDefinitionUUID=");
        buffer.append(deploymentDefinitionUUID).append("_buildAgentUUID=").append(buildAgentUUID);
        return buffer.toString();
    }

    public String getSlug() {
        return Deployment.generateSlug(this.packageDefinitionUUID.getUuidValue(), this.deploymentDefinitionUUID.getUuidValue(), this.buildAgentUUID.getUuidValue());
    }

    public String getStoragePresentation() throws TeamRepositoryException {
        return new DeploymentJFSParser().toRDFXML(this);
    }

    @Override
    public void setRollbackDeployInfoUUID(UUID deployResultUUID) {
        this.rollbackDeployResultUUID = deployResultUUID;
    }

    @Override
    public UUID getRollbackDeployInfoUUID() {
        return this.rollbackDeployResultUUID;
    }
}

