/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.common.ui;

import com.ibm.team.enterprise.common.ui.IEnterpriseExtensionsNode;
import com.ibm.team.enterprise.internal.common.ui.EnterpriseExtensionsArchiveFilterListener;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class EnterpriseExtensionsDomainRegistry {
    private static EnterpriseExtensionsDomainRegistry instance;
    private Map<UUID, Map<String, List<IEnterpriseExtensionsNode>>> uuidChildrenNodeMap;
    private Map<UUID, IProjectAreaHandle> uuidProjectAreaMap;
    private final EnterpriseExtensionsArchiveFilterListener archivefilterListener = new EnterpriseExtensionsArchiveFilterListener();

    private EnterpriseExtensionsDomainRegistry() {
        this.initialize();
    }

    public static EnterpriseExtensionsDomainRegistry getInstance() {
        if (instance == null) {
            instance = new EnterpriseExtensionsDomainRegistry();
        }
        return instance;
    }

    private void initialize() {
        this.uuidChildrenNodeMap = new HashMap<UUID, Map<String, List<IEnterpriseExtensionsNode>>>();
        this.uuidProjectAreaMap = new HashMap<UUID, IProjectAreaHandle>();
    }

    private void initializeProjectAreaChildrenNodesList(IProjectAreaHandle projectAreaHandle, DomainSubtreeRoot domainSubtreeRoot) {
        UUID uuid = projectAreaHandle.getItemId();
        boolean hasUUID = this.uuidChildrenNodeMap.containsKey(uuid);
        if (!hasUUID) {
            HashMap<String, List<IEnterpriseExtensionsNode>> tempMap = new HashMap<String, List<IEnterpriseExtensionsNode>>();
            this.initializeMap(tempMap, projectAreaHandle, domainSubtreeRoot);
            this.uuidChildrenNodeMap.put(uuid, tempMap);
            this.uuidProjectAreaMap.put(uuid, projectAreaHandle);
        }
    }

    private void initializeMap(Map<String, List<IEnterpriseExtensionsNode>> parentIdChildrenNodeMap, IProjectAreaHandle projectAreaHandle, DomainSubtreeRoot domainSubtreeRoot) {
        this.initializeMap(parentIdChildrenNodeMap, projectAreaHandle, true, domainSubtreeRoot);
    }

    private void initializeMap(Map<String, List<IEnterpriseExtensionsNode>> parentIdChildrenNodeMap, IProjectAreaHandle projectAreaHandle, boolean checkVisibility, DomainSubtreeRoot domainSubtreeRoot) {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] conf = reg.getConfigurationElementsFor("com.ibm.team.enterprise.common.ui.enterpriseExtensionsNode");
        int i = 0;
        while (i < conf.length) {
            IConfigurationElement currentConf = conf[i];
            try {
                Object obj = currentConf.createExecutableExtension("class");
                if (obj instanceof IEnterpriseExtensionsNode) {
                    IEnterpriseExtensionsNode currentNode = (IEnterpriseExtensionsNode)obj;
                    currentNode.setProjectAreaHandle(projectAreaHandle);
                    currentNode.setDomainSubtreeRoot(domainSubtreeRoot);
                    boolean isVisible = true;
                    if (checkVisibility) {
                        isVisible = currentNode.isVisible();
                    }
                    if (isVisible) {
                        currentNode.setId(currentConf.getAttribute("id"));
                        String pathId = currentConf.getAttribute("pathId");
                        currentNode.setPathId(pathId);
                        String parentPathId = this.getParentPathId(pathId);
                        boolean hasParentPathId = parentIdChildrenNodeMap.containsKey(parentPathId);
                        List<Object> childrenNodesList = null;
                        if (hasParentPathId) {
                            childrenNodesList = parentIdChildrenNodeMap.get(parentPathId);
                        } else {
                            childrenNodesList = new ArrayList();
                            parentIdChildrenNodeMap.put(parentPathId, childrenNodesList);
                        }
                        childrenNodesList.add(currentNode);
                    }
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public boolean hasChildrenNodes(IProjectAreaHandle projectAreaHandle, IEnterpriseExtensionsNode parentNode, DomainSubtreeRoot domainSubtreeRoot) {
        return this.hasChildrenNodes(projectAreaHandle, parentNode.getPathId(), domainSubtreeRoot);
    }

    public boolean hasChildrenNodes(IProjectAreaHandle projectAreaHandle, String pathId, DomainSubtreeRoot domainSubtreeRoot) {
        HashMap<String, List<IEnterpriseExtensionsNode>> tempMap = null;
        UUID uuid = projectAreaHandle.getItemId();
        boolean hasUUID = this.uuidChildrenNodeMap.containsKey(uuid);
        if (hasUUID) {
            tempMap = this.uuidChildrenNodeMap.get(uuid);
        } else {
            tempMap = new HashMap();
            this.initializeMap(tempMap, projectAreaHandle, false, domainSubtreeRoot);
        }
        if (tempMap != null) {
            if (tempMap.containsKey(pathId)) {
                List childrenNodesList = (List)tempMap.get(pathId);
                if (childrenNodesList != null) {
                    int numOfChildren = childrenNodesList.size();
                    return numOfChildren > 0;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public Iterator<IEnterpriseExtensionsNode> getChildrenNodes(IProjectAreaHandle projectAreaHandle, IEnterpriseExtensionsNode parentNode, DomainSubtreeRoot domainSubtreeRoot) {
        return this.getChildrenNodes(projectAreaHandle, parentNode.getPathId(), domainSubtreeRoot);
    }

    public Iterator<IEnterpriseExtensionsNode> getChildrenNodes(IProjectAreaHandle projectAreaHandle, String pathId, DomainSubtreeRoot domainSubtreeRoot) {
        int numOfChildren;
        List<IEnterpriseExtensionsNode> childrenNodesList;
        Map<String, List<IEnterpriseExtensionsNode>> tempMap;
        this.initializeProjectAreaChildrenNodesList(projectAreaHandle, domainSubtreeRoot);
        boolean hasUUID = this.uuidChildrenNodeMap.containsKey(projectAreaHandle.getItemId());
        if (hasUUID && (tempMap = this.uuidChildrenNodeMap.get(projectAreaHandle.getItemId())) != null && tempMap.containsKey(pathId) && (childrenNodesList = tempMap.get(pathId)) != null && (numOfChildren = childrenNodesList.size()) > 0) {
            return childrenNodesList.iterator();
        }
        ArrayList childrenNodesList2 = new ArrayList();
        return childrenNodesList2.iterator();
    }

    public IEnterpriseExtensionsNode getEnterpriseExtensionsNode(IProjectAreaHandle projArea, String pathId) {
        Iterator<IEnterpriseExtensionsNode> iterator = this.getChildrenNodes(projArea, this.getParentPathId(pathId), null);
        Object parentNode = null;
        while (parentNode == null && iterator.hasNext()) {
            IEnterpriseExtensionsNode nextNode = iterator.next();
            if (!nextNode.getPathId().equals(pathId)) continue;
            return nextNode;
        }
        return null;
    }

    public IEnterpriseExtensionsNode getEnterpriseExtensionsNode(IProjectAreaHandle projArea, IEnterpriseExtensionsNode nodeType) {
        Iterator<IEnterpriseExtensionsNode> iterator = this.getChildrenNodes(projArea, "EnterpriseExtensions", null);
        Object parentNode = null;
        while (parentNode == null && iterator.hasNext()) {
            IEnterpriseExtensionsNode nextNode = iterator.next();
            if (nextNode.getClass() != nodeType.getClass()) continue;
            return nextNode;
        }
        return null;
    }

    private String getParentPathId(String pathId) {
        int separatorIndex = pathId.lastIndexOf(47);
        String parentPathId = null;
        parentPathId = separatorIndex == -1 ? "EnterpriseExtensions" : pathId.substring(0, separatorIndex);
        return parentPathId;
    }

    public void clearChildrenNodes(IProjectAreaHandle projectAreaHandle) {
        this.uuidChildrenNodeMap.remove(projectAreaHandle.getItemId());
    }

    public Iterator<IProjectAreaHandle> getAllProjectAreaUUIDs() {
        return this.uuidProjectAreaMap.values().iterator();
    }

    public EnterpriseExtensionsArchiveFilterListener getArchivefilterListener() {
        return this.archivefilterListener;
    }
}

