/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.common.ui;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.internal.ui.listeners.AbstractBuildDefinitionChangeListener;
import com.ibm.team.enterprise.common.ui.IEnterpriseExtensionsNode;
import com.ibm.team.enterprise.common.ui.domain.AbstractEnterpriseExtensionsNode;
import com.ibm.team.enterprise.common.ui.nls.Messages;
import com.ibm.team.enterprise.common.ui.util.BuildSubsetTreeItemTooltipSupport;
import com.ibm.team.enterprise.internal.common.client.EnterpriseConfigurationCache;
import com.ibm.team.enterprise.internal.common.ui.EnterpriseExtensionsDomain;
import com.ibm.team.enterprise.internal.common.ui.EnterpriseExtensionsDomainRegistry;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.rcp.ui.teamnavigator.Domain;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistry;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryChangeEvent;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryListener;
import com.ibm.team.repository.client.ILicenseClient;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

public class EnterpriseExtensionsDomainContentProvider
implements ITreeContentProvider,
ITreePathContentProvider,
IDeferredWorkbenchAdapter,
IConnectedProjectAreaRegistryListener {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final TreePath[] EMPTY_TREEPATH_ARRAY = new TreePath[0];
    private AbstractTreeViewer treeViewer;
    private final EnterpriseExtensionsDomain domain;
    private DeferredTreeContentManager fDeferredTreeManager;
    private boolean fetchInProgress;
    private boolean inputChanged;
    private boolean isDisposed;
    protected final HashMap<IProjectAreaHandle, AbstractBuildDefinitionChangeListener> fDeploymentChangeListener = new HashMap();
    protected final HashMap<IProjectAreaHandle, AbstractBuildDefinitionChangeListener> fPackagingChangeListener = new HashMap();
    protected final HashMap<IProjectAreaHandle, AbstractBuildDefinitionChangeListener> fPromotionChangeListener = new HashMap();

    public EnterpriseExtensionsDomainContentProvider(EnterpriseExtensionsDomain domain) {
        this.domain = domain;
        this.isDisposed = false;
        this.domain.getConnectedProjectAreaRegistry().addListener((IConnectedProjectAreaRegistryListener)this);
    }

    public EnterpriseExtensionsDomain getEnterpriseExtensionsDomain() {
        return this.domain;
    }

    public void addDeploymentListener(IProjectAreaHandle projectAreaHandle, AbstractBuildDefinitionChangeListener listener) {
        this.fDeploymentChangeListener.put(projectAreaHandle, listener);
    }

    public AbstractBuildDefinitionChangeListener removeDeploymentListener(IProjectAreaHandle projectAreaHandle) {
        return this.fDeploymentChangeListener.remove(projectAreaHandle);
    }

    public void addPackagingListener(IProjectAreaHandle projectAreaHandle, AbstractBuildDefinitionChangeListener listener) {
        this.fPackagingChangeListener.put(projectAreaHandle, listener);
    }

    public AbstractBuildDefinitionChangeListener removePackagingListener(IProjectAreaHandle projectAreaHandle) {
        return this.fPackagingChangeListener.remove(projectAreaHandle);
    }

    public void addPromotionListener(IProjectAreaHandle projectAreaHandle, AbstractBuildDefinitionChangeListener listener) {
        this.fPromotionChangeListener.put(projectAreaHandle, listener);
    }

    public AbstractBuildDefinitionChangeListener removePromotionListener(IProjectAreaHandle projectAreaHandle) {
        return this.fPromotionChangeListener.remove(projectAreaHandle);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        this.isDisposed = true;
        this.fDeferredTreeManager = null;
        this.disposeListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeListeners() {
        ArrayList<IProjectAreaHandle> projectAreaHandles;
        this.domain.getConnectedProjectAreaRegistry().removeListener((IConnectedProjectAreaRegistryListener)this);
        EnterpriseExtensionsDomainContentProvider enterpriseExtensionsDomainContentProvider = this;
        synchronized (enterpriseExtensionsDomainContentProvider) {
            projectAreaHandles = new ArrayList<IProjectAreaHandle>(this.fDeploymentChangeListener.keySet());
        }
        for (IProjectAreaHandle iProjectAreaHandle : projectAreaHandles) {
            this.removeDeploymentListeners(iProjectAreaHandle);
        }
        EnterpriseExtensionsDomainContentProvider enterpriseExtensionsDomainContentProvider2 = this;
        synchronized (enterpriseExtensionsDomainContentProvider2) {
            projectAreaHandles = new ArrayList<IProjectAreaHandle>(this.fPackagingChangeListener.keySet());
        }
        for (IProjectAreaHandle iProjectAreaHandle : projectAreaHandles) {
            this.removePackagingListeners(iProjectAreaHandle);
        }
        EnterpriseExtensionsDomainContentProvider enterpriseExtensionsDomainContentProvider3 = this;
        synchronized (enterpriseExtensionsDomainContentProvider3) {
            projectAreaHandles = new ArrayList<IProjectAreaHandle>(this.fPromotionChangeListener.keySet());
        }
        for (IProjectAreaHandle iProjectAreaHandle : projectAreaHandles) {
            this.removePromotionListeners(iProjectAreaHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDeploymentListeners(IProjectAreaHandle projectAreaHandle) {
        AbstractBuildDefinitionChangeListener listener;
        EnterpriseExtensionsDomainContentProvider enterpriseExtensionsDomainContentProvider = this;
        synchronized (enterpriseExtensionsDomainContentProvider) {
            listener = this.removeDeploymentListener(projectAreaHandle);
        }
        if (listener != null) {
            this.removeDefinitionItemListener(projectAreaHandle, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePackagingListeners(IProjectAreaHandle projectAreaHandle) {
        AbstractBuildDefinitionChangeListener listener;
        EnterpriseExtensionsDomainContentProvider enterpriseExtensionsDomainContentProvider = this;
        synchronized (enterpriseExtensionsDomainContentProvider) {
            listener = this.removePackagingListener(projectAreaHandle);
        }
        if (listener != null) {
            this.removeDefinitionItemListener(projectAreaHandle, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePromotionListeners(IProjectAreaHandle projectAreaHandle) {
        AbstractBuildDefinitionChangeListener listener;
        EnterpriseExtensionsDomainContentProvider enterpriseExtensionsDomainContentProvider = this;
        synchronized (enterpriseExtensionsDomainContentProvider) {
            listener = this.removePromotionListener(projectAreaHandle);
        }
        if (listener != null) {
            this.removeDefinitionItemListener(projectAreaHandle, listener);
        }
    }

    private void removeDefinitionItemListener(IProjectAreaHandle projectAreaHandle, AbstractBuildDefinitionChangeListener listener) {
        ITeamRepository repository = (ITeamRepository)projectAreaHandle.getOrigin();
        repository.itemManager().removeItemChangeListener(IBuildDefinition.ITEM_TYPE, (ISharedItemChangeListener)listener);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.treeViewer = (AbstractTreeViewer)viewer;
        if (this.fDeferredTreeManager == null) {
            this.fDeferredTreeManager = new DeferredTreeContentManager((AbstractTreeViewer)viewer, this.domain.getWorkbenchPart().getSite()){

                protected IDeferredWorkbenchAdapter getAdapter(Object element) {
                    try {
                        EnterpriseExtensionsDomainContentProvider.this.setInputChanged(true);
                        if (EnterpriseExtensionsDomainContentProvider.this.hasChildren(element)) {
                            EnterpriseExtensionsDomainContentProvider enterpriseExtensionsDomainContentProvider = EnterpriseExtensionsDomainContentProvider.this;
                            return enterpriseExtensionsDomainContentProvider;
                        }
                        IDeferredWorkbenchAdapter iDeferredWorkbenchAdapter = super.getAdapter(element);
                        return iDeferredWorkbenchAdapter;
                    }
                    finally {
                        EnterpriseExtensionsDomainContentProvider.this.setInputChanged(false);
                    }
                }
            };
        }
        new BuildSubsetTreeItemTooltipSupport((TreeViewer)this.treeViewer);
    }

    private boolean isInputChanged() {
        return this.inputChanged;
    }

    private void setInputChanged(boolean inputChanged) {
        this.inputChanged = inputChanged;
    }

    public boolean hasChildren(TreePath path) {
        Object object = path.getLastSegment();
        boolean result = false;
        if (object instanceof DomainSubtreeRoot) {
            DomainSubtreeRoot domainSubtreeRoot = (DomainSubtreeRoot)object;
            Domain domain = domainSubtreeRoot.getDomain();
            if (domain instanceof EnterpriseExtensionsDomain) {
                Job fetchConfiguration = null;
                IProjectArea projectArea = this.getProjectArea(domainSubtreeRoot);
                if (this.domain.getProjectArea() == null) {
                    this.domain.setProjectArea(projectArea);
                    fetchConfiguration = this.domain.fetchConfiguration(projectArea);
                }
                if (fetchConfiguration == null && !this.isInputChanged()) {
                    EnterpriseConfigurationCache.getInstance().remove((IProjectAreaHandle)projectArea);
                    fetchConfiguration = this.domain.fetchConfiguration(projectArea);
                }
                result = EnterpriseExtensionsDomainRegistry.getInstance().hasChildrenNodes(this.getProjectAreaHandle(domainSubtreeRoot), "EnterpriseExtensions", domainSubtreeRoot);
                if (fetchConfiguration != null) {
                    this.domain.checkConfiguration(fetchConfiguration);
                }
            }
        } else if (object instanceof IEnterpriseExtensionsNode) {
            IEnterpriseExtensionsNode node = (IEnterpriseExtensionsNode)object;
            boolean hasChildren = EnterpriseExtensionsDomainRegistry.getInstance().hasChildrenNodes(this.getProjectAreaHandle(node.getDomainSubtreeRoot()), node, node.getDomainSubtreeRoot());
            if (!hasChildren) {
                hasChildren = node.hasChildren();
            }
            result = hasChildren;
        }
        return result;
    }

    public Object[] getChildren(TreePath parentPath) {
        Object parentElement = parentPath.getLastSegment();
        if (parentElement instanceof DomainSubtreeRoot) {
            return this.fDeferredTreeManager.getChildren((Object)parentPath);
        }
        if (parentElement instanceof IEnterpriseExtensionsNode) {
            return this.fDeferredTreeManager.getChildren((Object)parentPath);
        }
        return EMPTY_ARRAY;
    }

    public Object getParent(Object element) {
        return null;
    }

    public TreePath[] getParents(Object element) {
        return EMPTY_TREEPATH_ARRAY;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof TreePath) {
            return this.hasChildren((TreePath)element);
        }
        return false;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof TreePath) {
            return this.getChildren((TreePath)parentElement);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        TreePath parentPath = (TreePath)object;
        Object parent = parentPath.getLastSegment();
        EnterpriseExtensionsDomainContentProvider enterpriseExtensionsDomainContentProvider = this;
        synchronized (enterpriseExtensionsDomainContentProvider) {
            if (this.fetchInProgress) {
                return;
            }
            this.fetchInProgress = true;
        }
        try {
            if (parent instanceof DomainSubtreeRoot) {
                this.getChildrenOfEnterpriseExtensionsDomain((DomainSubtreeRoot)parent, collector, monitor);
            } else if (parent instanceof IEnterpriseExtensionsNode) {
                this.getChildrenofEnterpriseExtensionsNode((IEnterpriseExtensionsNode)parent, collector, monitor);
            }
        }
        finally {
            this.fetchInProgress = false;
            collector.done();
            monitor.done();
        }
    }

    private void getChildrenOfEnterpriseExtensionsDomain(DomainSubtreeRoot parent, IElementCollector collector, IProgressMonitor monitor) {
        monitor.beginTask("", -1);
        Domain domain = parent.getDomain();
        IProjectAreaHandle projectAreaHandle = this.getProjectAreaHandle(parent);
        if (domain instanceof EnterpriseExtensionsDomain) {
            Iterator<IEnterpriseExtensionsNode> iterator = EnterpriseExtensionsDomainRegistry.getInstance().getChildrenNodes(projectAreaHandle, "EnterpriseExtensions", parent);
            while (iterator.hasNext()) {
                IEnterpriseExtensionsNode node = iterator.next();
                node.setDomainSubtreeRoot(parent);
                node.setViewer((Viewer)this.getTreeViewer());
                collector.add((Object)node, monitor);
            }
        }
    }

    private void getChildrenofEnterpriseExtensionsNode(IEnterpriseExtensionsNode parent, IElementCollector collector, IProgressMonitor monitor) {
        monitor.beginTask("", -1);
        IProjectAreaHandle projectAreaHandle = parent.getProjectAreaHandle();
        Iterator<IEnterpriseExtensionsNode> iterator = EnterpriseExtensionsDomainRegistry.getInstance().getChildrenNodes(projectAreaHandle, parent, parent.getDomainSubtreeRoot());
        while (iterator.hasNext()) {
            IEnterpriseExtensionsNode node = iterator.next();
            node.setParent(parent);
            node.setDomainSubtreeRoot(parent.getDomainSubtreeRoot());
            node.setViewer((Viewer)this.getTreeViewer());
            monitor.worked(1);
            collector.add((Object)node, monitor);
        }
        parent.fetchDeferredChildren(collector, monitor);
    }

    private IProjectAreaHandle getProjectAreaHandle(DomainSubtreeRoot parent) {
        return this.getProjectArea(parent);
    }

    private IProjectArea getProjectArea(DomainSubtreeRoot parent) {
        Object category = parent.getCategoryElement();
        if (category instanceof ITeamArea) {
            category = ((ITeamArea)category).getProjectArea();
        }
        return (IProjectArea)category;
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }

    public boolean isContainer() {
        return false;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object object) {
        if (object instanceof TreePath) {
            TreePath path = (TreePath)object;
            Object obj = path.getLastSegment();
            if (obj instanceof DomainSubtreeRoot) {
                return Messages.EnterpriseExtensionsDomainContentProvider_Enterprise_Extensions_Fetching_Children_Job_Name_Suffix;
            }
            if (obj instanceof IEnterpriseExtensionsNode) {
                return ((IEnterpriseExtensionsNode)obj).getLabelOfChildren();
            }
        }
        return object.toString();
    }

    public void updateTreeViewer(AbstractEnterpriseExtensionsNode node) {
        this.getTreeViewer().refresh((Object)node);
    }

    public AbstractTreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void connectedProjectAreaRegistryChanged(final IConnectedProjectAreaRegistryChangeEvent changeEvent) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                EnterpriseExtensionsDomainContentProvider.this.handleProjectAreaRegistryChanged(changeEvent);
            }
        });
    }

    private void flushLicenseCache(IProjectAreaHandle projectAreaHandle) {
        if (projectAreaHandle != null) {
            ITeamRepository repository = (ITeamRepository)projectAreaHandle.getOrigin();
            ILicenseClient licenseClient = (ILicenseClient)repository.getClientLibrary(ILicenseClient.class);
            licenseClient.flushCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleProjectAreaRegistryChanged(IConnectedProjectAreaRegistryChangeEvent changeEvent) {
        if (!this.isDisposed) {
            if (changeEvent.getType() == 2) {
                IProjectAreaHandle projectAreaHandle = changeEvent.getProjectAreaHandle();
                this.removeDeploymentListeners(projectAreaHandle);
                this.removePackagingListeners(projectAreaHandle);
                this.removePromotionListeners(projectAreaHandle);
                EnterpriseExtensionsDomainRegistry.getInstance().clearChildrenNodes(projectAreaHandle);
                this.flushLicenseCache(projectAreaHandle);
            } else if (changeEvent.getType() == 0) {
                ArrayList<IProjectAreaHandle> projectAreaHandles;
                IConnectedProjectAreaRegistry registry = this.domain.getConnectedProjectAreaRegistry();
                EnterpriseExtensionsDomainContentProvider enterpriseExtensionsDomainContentProvider = this;
                synchronized (enterpriseExtensionsDomainContentProvider) {
                    projectAreaHandles = new ArrayList<IProjectAreaHandle>(this.fDeploymentChangeListener.keySet());
                }
                for (IProjectAreaHandle iProjectAreaHandle : projectAreaHandles) {
                    if (registry.isConnectedProjectArea(iProjectAreaHandle)) continue;
                    this.removeDeploymentListeners(iProjectAreaHandle);
                }
                EnterpriseExtensionsDomainContentProvider enterpriseExtensionsDomainContentProvider2 = this;
                synchronized (enterpriseExtensionsDomainContentProvider2) {
                    projectAreaHandles = new ArrayList<IProjectAreaHandle>(this.fPackagingChangeListener.keySet());
                }
                for (IProjectAreaHandle iProjectAreaHandle : projectAreaHandles) {
                    if (registry.isConnectedProjectArea(iProjectAreaHandle)) continue;
                    this.removePackagingListeners(iProjectAreaHandle);
                }
                EnterpriseExtensionsDomainContentProvider enterpriseExtensionsDomainContentProvider3 = this;
                synchronized (enterpriseExtensionsDomainContentProvider3) {
                    projectAreaHandles = new ArrayList<IProjectAreaHandle>(this.fPromotionChangeListener.keySet());
                }
                for (IProjectAreaHandle iProjectAreaHandle : projectAreaHandles) {
                    if (registry.isConnectedProjectArea(iProjectAreaHandle)) continue;
                    this.removePromotionListeners(iProjectAreaHandle);
                }
                Iterator<IProjectAreaHandle> iterator = EnterpriseExtensionsDomainRegistry.getInstance().getAllProjectAreaUUIDs();
                while (iterator.hasNext()) {
                    IProjectAreaHandle projectAreaHandle3 = iterator.next();
                    EnterpriseExtensionsDomainRegistry.getInstance().clearChildrenNodes(projectAreaHandle3);
                }
            }
        }
    }
}

