/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.common.ui;

import com.ibm.team.enterprise.common.ui.Activator;
import com.ibm.team.enterprise.common.ui.IEnterpriseExtensionsNode;
import com.ibm.team.enterprise.common.ui.IMenuAction;
import com.ibm.team.enterprise.common.ui.IMenuSelectionAction;
import com.ibm.team.enterprise.common.ui.editors.EnterpriseConfigurationEditorInput;
import com.ibm.team.enterprise.common.ui.nls.Messages;
import com.ibm.team.enterprise.internal.common.ui.ActionsContributionsRegistry;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;

public class EnterpriseExtensionsDomainActionHelper {
    protected IMenuManager fMenuManager;
    protected IStructuredSelection fSelection;
    protected IWorkbenchPartSite fPartSite;

    public EnterpriseExtensionsDomainActionHelper(IMenuManager manager, IStructuredSelection selection, IWorkbenchPartSite site) {
        this.fMenuManager = manager;
        this.fSelection = selection;
        this.fPartSite = site;
    }

    public void contributeActions() {
        if (this.fSelection.isEmpty()) {
            return;
        }
        Object element = this.fSelection.getFirstElement();
        if (this.fSelection.size() == 1) {
            if (element instanceof IEnterpriseExtensionsNode) {
                IEnterpriseExtensionsNode selectedNode = (IEnterpriseExtensionsNode)element;
                ActionsContributionsRegistry registry = ActionsContributionsRegistry.singleton;
                String id = selectedNode.getId();
                if (id == null) {
                    return;
                }
                List<IConfigurationElement> contributions = registry.getContributionsFor(id);
                for (IConfigurationElement configurationElement : contributions) {
                    IMenuAction action = registry.getAction(configurationElement);
                    action.setPartSite(this.fPartSite);
                    if (action instanceof IMenuSelectionAction) {
                        ((IMenuSelectionAction)action).selectionChanged(selectedNode);
                    }
                    if (configurationElement.getAttribute("group").compareTo("NEW") == 0) {
                        this.fMenuManager.appendToGroup("jazz.new.group", (IAction)action);
                        continue;
                    }
                    if (configurationElement.getAttribute("group").compareTo("OPEN") == 0) {
                        this.fMenuManager.appendToGroup("jazz.open.group", (IAction)action);
                        continue;
                    }
                    if (configurationElement.getAttribute("group").compareTo("REFACTORING") == 0) {
                        this.fMenuManager.appendToGroup("jazz.refactoring.group", (IAction)action);
                        continue;
                    }
                    if (configurationElement.getAttribute("group").compareTo("PROPERTIES") == 0) {
                        this.fMenuManager.appendToGroup("jazz.properties.group", (IAction)action);
                        continue;
                    }
                    if (configurationElement.getAttribute("group").compareTo("ADDITIONS") == 0) {
                        this.fMenuManager.appendToGroup("additions", (IAction)action);
                        continue;
                    }
                    if (configurationElement.getAttribute("group").compareTo("NAVIGATE") == 0) {
                        this.fMenuManager.appendToGroup("jazz.navigate.group", (IAction)action);
                        continue;
                    }
                    if (configurationElement.getAttribute("group").compareTo("COMPARE") != 0) continue;
                    this.fMenuManager.appendToGroup("jazz.compare.group", (IAction)action);
                }
            } else if (element instanceof DomainSubtreeRoot) {
                Object category = ((DomainSubtreeRoot)element).getCategoryElement();
                if (category instanceof ITeamArea) {
                    category = ((ITeamArea)category).getProjectArea();
                }
                IProjectArea projectArea = (IProjectArea)category;
                this.fMenuManager.appendToGroup("jazz.open.group", (IAction)this.getEditEnterpriseConfigurationAction(projectArea));
            }
        }
    }

    private Action getEditEnterpriseConfigurationAction(final IProjectArea projectArea) {
        return new Action(Messages.EnterpriseConfigurationDomain_EDIT_ACTION_LABEL){
            EnterpriseConfigurationEditorInput input;
            {
                super($anonymous0);
                this.input = null;
            }

            public void run() {
                ITeamRepository teamRepository = (ITeamRepository)projectArea.getOrigin();
                IWorkbenchPage page = EnterpriseExtensionsDomainActionHelper.this.fPartSite.getPage();
                if (page != null) {
                    try {
                        this.input = new EnterpriseConfigurationEditorInput(teamRepository, projectArea);
                        page.openEditor((IEditorInput)this.input, this.input.getEditorId());
                    }
                    catch (Exception e) {
                        Activator.log(e);
                    }
                }
            }
        };
    }
}

