/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.common.ui;

import com.ibm.team.enterprise.common.ui.Activator;
import com.ibm.team.enterprise.common.ui.IEnterpriseExtensionsNode;
import com.ibm.team.enterprise.common.ui.nls.Messages;
import com.ibm.team.enterprise.internal.common.client.EnterpriseConfigurationCache;
import com.ibm.team.enterprise.internal.common.ui.DelegatingEnterpriseExtensionsSorter;
import com.ibm.team.enterprise.internal.common.ui.EnterpriseExtensionsDomainActionHelper;
import com.ibm.team.enterprise.internal.common.ui.EnterpriseExtensionsDomainContentProvider;
import com.ibm.team.enterprise.internal.common.ui.EnterpriseExtensionsDomainLabelProvider;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.rcp.ui.teamnavigator.Category;
import com.ibm.team.process.rcp.ui.teamnavigator.Domain;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.process.rcp.ui.teamnavigator.ProjectAreaCategory;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ui.IWorkbenchPartSite;

public class EnterpriseExtensionsDomain
extends Domain {
    public static final String NODE_PATH_ID = "EnterpriseExtensions";
    protected EnterpriseExtensionsDomainContentProvider fContentProvider;
    private EnterpriseExtensionsDomainLabelProvider fLabelProvider;
    private IProjectArea projectArea;

    public ITreePathContentProvider getContentProvider() {
        if (this.fContentProvider == null) {
            this.fContentProvider = new EnterpriseExtensionsDomainContentProvider(this);
        }
        return this.fContentProvider;
    }

    public boolean contains(Object element) {
        return element instanceof IEnterpriseExtensionsNode;
    }

    public ITreePathLabelProvider getLabelProvider() {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = new EnterpriseExtensionsDomainLabelProvider();
        }
        return this.fLabelProvider;
    }

    public Object getRoot() {
        return this;
    }

    public boolean supportsCategory(Category category) {
        return category instanceof ProjectAreaCategory;
    }

    public void contributeContextMenuActions(IMenuManager manager, IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return;
        }
        Job fetchConfiguration = null;
        Object obj = selection.getFirstElement();
        if (obj instanceof DomainSubtreeRoot) {
            Object category = ((DomainSubtreeRoot)obj).getCategoryElement();
            if (category instanceof ITeamArea) {
                category = ((ITeamArea)category).getProjectArea();
            }
            IProjectArea projectArea = (IProjectArea)category;
            ITeamRepository teamRepository = (ITeamRepository)projectArea.getOrigin();
            if (!EnterpriseConfigurationCache.getInstance().has((IProjectAreaHandle)projectArea)) {
                fetchConfiguration = this.fetchConfiguration(teamRepository, projectArea);
            }
        }
        if (obj instanceof IEnterpriseExtensionsNode) {
            IEnterpriseExtensionsNode node = (IEnterpriseExtensionsNode)obj;
            node.contributeContextMenuActions(manager, selection);
        }
        if (obj instanceof IEnterpriseExtensionsNode || obj instanceof DomainSubtreeRoot) {
            EnterpriseExtensionsDomainActionHelper actionHelper = new EnterpriseExtensionsDomainActionHelper(manager, selection, this.getWorkbenchPart().getSite());
            if (fetchConfiguration != null) {
                try {
                    fetchConfiguration.join();
                }
                catch (InterruptedException e) {
                    Activator.log(e);
                }
            }
            actionHelper.contributeActions();
        }
        super.contributeContextMenuActions(manager, selection);
    }

    public void dispose() {
        if (this.fContentProvider != null) {
            this.fContentProvider.dispose();
            this.fContentProvider = null;
        }
    }

    public boolean open(IWorkbenchPartSite site, IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        Object obj = selection.getFirstElement();
        if (obj instanceof IEnterpriseExtensionsNode) {
            IEnterpriseExtensionsNode node = (IEnterpriseExtensionsNode)obj;
            return node.open(site, selection);
        }
        return false;
    }

    public boolean refresh(Object element) {
        if (element instanceof IEnterpriseExtensionsNode) {
            return ((IEnterpriseExtensionsNode)element).refresh();
        }
        return super.refresh(element);
    }

    public ViewerSorter getSorter() {
        return new DelegatingEnterpriseExtensionsSorter();
    }

    public IProjectArea getProjectArea() {
        return this.projectArea;
    }

    public void setProjectArea(IProjectArea projectArea) {
        this.projectArea = projectArea;
    }

    public Job fetchConfiguration(IProjectArea projectArea) {
        Job fetchConfiguration = null;
        if (projectArea != null) {
            EnterpriseConfigurationCache.getInstance().remove((IProjectAreaHandle)projectArea);
            ITeamRepository teamRepository = (ITeamRepository)projectArea.getOrigin();
            fetchConfiguration = this.fetchConfiguration(teamRepository, projectArea);
        }
        return fetchConfiguration;
    }

    public void checkConfiguration(Job fetchConfiguration) {
        if (fetchConfiguration != null) {
            try {
                fetchConfiguration.join();
            }
            catch (InterruptedException e) {
                Activator.log(e);
            }
        }
    }

    private Job fetchConfiguration(final ITeamRepository teamRepository, final IProjectArea projectArea) {
        Job fetchConfiguration = new Job(Messages.EnterpriseConfigurationEditorInput_JOB){

            protected IStatus run(IProgressMonitor monitor) {
                EnterpriseConfigurationCache instance = EnterpriseConfigurationCache.getInstance();
                try {
                    if (!instance.has((IProjectAreaHandle)projectArea)) {
                        instance.fetch(teamRepository, (IProjectAreaHandle)projectArea, monitor);
                    }
                }
                catch (TeamRepositoryException e) {
                    e.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        };
        fetchConfiguration.schedule();
        return fetchConfiguration;
    }
}

