/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.common.ui;

import com.ibm.team.enterprise.common.ui.Activator;
import com.ibm.team.enterprise.common.ui.IMenuAction;
import com.ibm.team.enterprise.common.ui.nls.Messages;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class ActionsContributionsRegistry {
    private boolean initialized;
    private final List<IConfigurationElement> contributions = new ArrayList<IConfigurationElement>();
    public static final ActionsContributionsRegistry singleton = new ActionsContributionsRegistry();

    private void initialize() {
        this.initialized = true;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] conf = reg.getConfigurationElementsFor("com.ibm.team.enterprise.common.ui.enterpriseExtensionsNodeAction");
        int i = 0;
        while (i < conf.length) {
            IConfigurationElement currentConf = conf[i];
            this.contributions.add(currentConf);
            ++i;
        }
    }

    public List<IConfigurationElement> getContributions() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.contributions;
    }

    public List<IConfigurationElement> getContributionsFor(String actionsFor) {
        if (!this.initialized) {
            this.initialize();
        }
        ArrayList<IConfigurationElement> matchedElements = new ArrayList<IConfigurationElement>();
        for (IConfigurationElement currentElement : this.contributions) {
            if (currentElement.getAttribute("actionFor").compareTo(actionsFor) != 0) continue;
            matchedElements.add(currentElement);
        }
        return matchedElements;
    }

    public IMenuAction getAction(IConfigurationElement contribution) {
        if (!this.initialized) {
            this.initialize();
        }
        IMenuAction result = null;
        try {
            result = (IMenuAction)contribution.createExecutableExtension("class");
        }
        catch (Exception exc) {
            Activator.log(new InvocationTargetException(exc, Messages.ActionsContributionsRegistry_INITIALIZATION_FAILURE));
        }
        return result;
    }
}

