/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.common.ui.wizards;

import com.ibm.team.enterprise.common.ui.nls.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class NewZHfsProjectFirstPage
extends WizardPage {
    Text projectNameField;
    private final Listener nameModifyListener = new Listener(){

        public void handleEvent(Event e) {
            boolean valid = NewZHfsProjectFirstPage.this.validatePage();
            NewZHfsProjectFirstPage.this.setPageComplete(valid);
        }
    };

    public NewZHfsProjectFirstPage(String pageName) {
        super(pageName);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        this.initializeDialogUnits((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, ((Object)((Object)this)).getClass().getCanonicalName());
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createProjectNameGroup(composite);
        this.setPageComplete(this.validatePage());
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    private final void createProjectNameGroup(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        Composite projectGroup = new Composite(parent, 0);
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectLabel = new Label(projectGroup, 0);
        projectLabel.setText(Messages.NewZHfsProjectFirstPage_PROJECT_NAME_LABEL);
        projectLabel.setFont(parent.getFont());
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.projectNameField = new Text(projectGroup, 2048);
        this.projectNameField.setLayoutData((Object)data);
        this.projectNameField.setFont(parent.getFont());
        this.projectNameField.setText("");
        this.projectNameField.addListener(24, this.nameModifyListener);
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }

    public String getProjectName() {
        return this.projectNameField.getText().trim();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.projectNameField.setFocus();
        }
    }

    protected boolean validatePage() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String projectName = this.getProjectName();
        if (projectName == null || projectName.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(Messages.NewZHfsProjectFirstPage_PROJECT_NAME_EMPTY);
            return false;
        }
        IStatus nameStatus = workspace.validateName(projectName, 4);
        if (!nameStatus.isOK()) {
            this.setErrorMessage(nameStatus.getMessage());
            this.setMessage(null);
            return false;
        }
        if (projectName.indexOf(32) > -1) {
            this.setErrorMessage(Messages.NewZHfsProjectFirstPage_PROJECT_NAME_INVALID);
            this.setMessage(null);
            return false;
        }
        IProject handle = this.getProjectHandle();
        if (handle.exists()) {
            this.setErrorMessage(Messages.NewZHfsProjectFirstPage_PROJECT_NAME_DUPLICATE);
            this.setMessage(null);
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }
}

