/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.common.ui.util;

import com.ibm.team.enterprise.common.ui.Activator;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.internal.filesystem.ui.adapters.AbstractAdaptableRemoteResource;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.UUID;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class Utils {
    public static ITeamRepository getTeamRepository(IShareable shareable) {
        if (shareable == null) {
            return null;
        }
        IShare share = null;
        try {
            share = shareable.getShare((IProgressMonitor)new NullProgressMonitor());
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
        if (share == null) {
            return null;
        }
        ISharingDescriptor descriptor = share.getSharingDescriptor();
        return Utils.getTeamRepository(descriptor);
    }

    public static ITeamRepository getTeamRepository(ISharingDescriptor desc) {
        return Utils.getTeamRepository(desc.getRepositoryId());
    }

    public static ITeamRepository getTeamRepository(UUID repositoryId) {
        ITeamRepository[] repositories;
        ITeamRepository[] iTeamRepositoryArray = repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repository = iTeamRepositoryArray[n2];
            if (repositoryId.equals((Object)repository.getId())) {
                return repository;
            }
            ++n2;
        }
        return null;
    }

    public static ITeamRepository getTeamRepository(String repositoryURI) {
        return TeamPlatform.getTeamRepositoryService().getTeamRepository(repositoryURI, 0);
    }

    public static ITeamRepository getTeamRepository(String repositoryURI, UUID id, int flags) {
        ITeamRepository[] repos = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int i = 0;
        while (i < repos.length) {
            if (id.equals((Object)repos[i].getId())) {
                return repos[i];
            }
            ++i;
        }
        ITeamRepository repo = TeamPlatform.getTeamRepositoryService().getTeamRepository(repositoryURI, flags);
        if (repo != null && repo.getId() == null) {
            try {
                repo.setId(id);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return repo;
    }

    public static boolean isShared(IAdaptable elem) {
        if (elem == null) {
            return false;
        }
        IShareable share = Utils.getSharable(elem);
        return Utils.getTeamRepository(share) != null;
    }

    public static IShareable getSharable(IProject project) {
        if (project == null) {
            return null;
        }
        return (IShareable)project.getAdapter(IShareable.class);
    }

    public static IShareable getSharable(IAdaptable resource) {
        if (resource == null) {
            return null;
        }
        IShareable shareable = (IShareable)resource.getAdapter(IShareable.class);
        if (shareable != null) {
            return shareable;
        }
        AbstractAdaptableRemoteResource aarr = (AbstractAdaptableRemoteResource)resource.getAdapter(AbstractAdaptableRemoteResource.class);
        if (aarr != null) {
            shareable = (IShareable)aarr.getAdapter(IShareable.class);
        }
        return shareable;
    }

    public static IShareable getSharable(IResource resource) {
        if (resource == null) {
            return null;
        }
        return (IShareable)resource.getAdapter(IShareable.class);
    }

    public static boolean isShared(IProject project) {
        IShareable shareable = Utils.getSharable(project);
        if (shareable == null) {
            return false;
        }
        IShare share = null;
        try {
            share = shareable.getShare((IProgressMonitor)new NullProgressMonitor());
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
        return share != null;
    }

    public static int getCurrentBuildReportPageSize() {
        int pageSize = Activator.getDefault().getPreferenceStore().getInt("com.ibm.team.enterprise.build.ui.buildReport.preference.pageSizeUserConfigKey");
        if (pageSize == 0) {
            Activator.getDefault().getPreferenceStore().setValue("com.ibm.team.enterprise.build.ui.buildReport.preference.pageSizeUserConfigKey", 500);
            return 500;
        }
        return pageSize;
    }

    public static String getDefaultIspfGatewayLocation() {
        String ispfGateway = Activator.getDefault().getDialogSettings().get("dialogSettingsIspfGatewayScript");
        return ispfGateway == null ? "/etc/jazz/ccm/startispf.sh" : ispfGateway;
    }

    public static void saveDefaultIspfGatewayLocation(String location) {
        if (location != null && !location.equals("/etc/jazz/ccm/startispf.sh")) {
            Activator.getDefault().getDialogSettings().put("dialogSettingsIspfGatewayScript", location);
        }
    }
}

