/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.common.ui.util;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class GridTools {
    public static void createPlaceholder(Composite composite) {
        GridTools.createPlaceholder(composite, 0, -1);
    }

    public static void createPlaceholder(Composite composite, int width) {
        GridTools.createPlaceholder(composite, width, -1);
    }

    public static void createPlaceholder(Composite composite, int width, int height) {
        Label label = new Label(composite, 0);
        label.setText("");
        GridDataFactory.fillDefaults().hint(width, height).align(1, 0x1000000).applyTo((Control)label);
    }

    public static void createSeparator(Composite composite) {
        GridTools.createSeparator(composite, 1);
    }

    public static void createSeparator(Composite composite, int horizontalSpan) {
        Label separator = new Label(composite, 258);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = horizontalSpan;
        gridData.grabExcessHorizontalSpace = true;
        separator.setLayoutData((Object)gridData);
    }

    public static void createSpacer(FormToolkit toolkit, Composite parent, int height, int horizontalSpan) {
        GridTools.createSpacer(toolkit, parent, height, horizontalSpan, false);
    }

    public static void createSpacer(FormToolkit toolkit, Composite parent, int height, int horizontalSpan, boolean setBackground) {
        Label label = toolkit.createLabel(parent, "");
        if (setBackground) {
            label.setBackground(Display.getCurrent().getSystemColor(22));
        }
        GridData gridData = new GridData(4, 4, false, false);
        gridData.horizontalSpan = horizontalSpan;
        gridData.heightHint = height;
        label.setLayoutData((Object)gridData);
    }

    public static void createSubtitle(FormToolkit toolkit, Composite parent, String text, int horizontalSpan) {
        Label label = toolkit.createLabel(parent, text, 16384);
        label.setBackground(Display.getCurrent().getSystemColor(22));
        FontData fontData = label.getFont().getFontData()[0];
        Font font = new Font((Device)Display.getCurrent(), new FontData(fontData.getName(), fontData.getHeight(), 1));
        label.setFont(font);
        GridData gridData = new GridData(4, 4, false, false);
        gridData.horizontalSpan = horizontalSpan;
        label.setLayoutData((Object)gridData);
    }
}

