/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.common.ui.preferences;

import com.ibm.team.enterprise.common.ui.Activator;
import com.ibm.team.enterprise.common.ui.IEnterprisePreferenceKey;
import com.ibm.team.enterprise.common.ui.nls.Messages;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class DependencyBuildPage
extends PreferencePage
implements IWorkbenchPreferencePage,
IEnterprisePreferenceKey {
    public static final int PAGE_SIZE_MAX_VALUE = 5000;
    public static final int PAGE_SIZE_MIN_VALUE = 1;
    private Button nonImpactSystemDefinitionWarningCheckbox;
    private Button warnPublishingBuildMapLinkCheckbox;
    private Spinner fPageSizeSpinner;

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(composite);
        this.nonImpactSystemDefinitionWarningCheckbox = new Button(composite, 32);
        this.nonImpactSystemDefinitionWarningCheckbox.setText(Messages.DependencyBuildPage_NON_IMPACT_SYSTEM_DEFINITION_WARNING);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.nonImpactSystemDefinitionWarningCheckbox);
        this.nonImpactSystemDefinitionWarningCheckbox.setSelection(this.getPreferenceStore().getBoolean("nonImpactSystemDefinitionWarningPreferenceId"));
        this.warnPublishingBuildMapLinkCheckbox = new Button(composite, 32);
        this.warnPublishingBuildMapLinkCheckbox.setText(Messages.DependencyBuildPage_PROMPT_PUBLISHING_BUILD_MAP_LABEL);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.warnPublishingBuildMapLinkCheckbox);
        this.warnPublishingBuildMapLinkCheckbox.setSelection(this.getPreferenceStore().getBoolean("promptPublishingBuildMapLinks"));
        this.createPageSizeConfiguration(composite);
        return composite;
    }

    private void createPageSizeConfiguration(Composite parent) {
        Group pageSizeGroup = new Group(parent, 0);
        pageSizeGroup.setText(Messages.BuildReportPreferencePage_CONFIG_GROUP_NAME);
        pageSizeGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout iterationLayout = new GridLayout(2, false);
        pageSizeGroup.setLayout((Layout)iterationLayout);
        Composite comp = new Composite((Composite)pageSizeGroup, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(comp);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)comp);
        Label nameLabel = new Label(comp, 0);
        nameLabel.setText(Messages.BuildReportPreferencePage_PAGE_SIZE_LABEL);
        nameLabel.setSize(100, 30);
        this.fPageSizeSpinner = new Spinner(comp, 2048);
        this.fPageSizeSpinner.setMaximum(5000);
        this.fPageSizeSpinner.setMinimum(1);
        if (this.getPreferenceStore().getInt("com.ibm.team.enterprise.build.ui.buildReport.preference.pageSizeUserConfigKey") == 0) {
            this.setToDefaults();
        } else {
            this.fPageSizeSpinner.setSelection(this.getPreferenceStore().getInt("com.ibm.team.enterprise.build.ui.buildReport.preference.pageSizeUserConfigKey"));
        }
        this.fPageSizeSpinner.setSize(100, 30);
        GridDataFactory.fillDefaults().indent(10, 0).applyTo((Control)this.fPageSizeSpinner);
    }

    private void setToDefaults() {
        this.getPreferenceStore().setValue("com.ibm.team.enterprise.build.ui.buildReport.preference.pageSizeUserConfigKey", 500);
        this.fPageSizeSpinner.setSelection(500);
    }

    protected void performDefaults() {
        this.setToDefaults();
        this.nonImpactSystemDefinitionWarningCheckbox.setSelection(this.getPreferenceStore().getDefaultBoolean("nonImpactSystemDefinitionWarningPreferenceId"));
        this.warnPublishingBuildMapLinkCheckbox.setSelection(this.getPreferenceStore().getDefaultBoolean("promptPublishingBuildMapLinks"));
        super.performDefaults();
    }

    public boolean performOk() {
        int currentValue = this.fPageSizeSpinner.getSelection();
        this.getPreferenceStore().setValue("com.ibm.team.enterprise.build.ui.buildReport.preference.pageSizeUserConfigKey", currentValue);
        this.getPreferenceStore().setValue("nonImpactSystemDefinitionWarningPreferenceId", this.nonImpactSystemDefinitionWarningCheckbox.getSelection());
        this.getPreferenceStore().setValue("promptPublishingBuildMapLinks", this.warnPublishingBuildMapLinkCheckbox.getSelection());
        return super.performOk();
    }
}

