/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.common.ui.elements;

import com.ibm.team.enterprise.common.ui.DialogItemTable;
import com.ibm.team.enterprise.common.ui.IDialogItem;
import com.ibm.team.enterprise.common.ui.elements.AbstractDialogItem;
import com.ibm.team.enterprise.common.ui.elements.DialogButtonItem;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class DialogTableItem
extends AbstractDialogItem<DialogItemTable, Table>
implements IDialogItem<DialogItemTable, Table> {
    public Table item;
    public Table table;
    public TableViewer viewer;
    public Button add;
    public Button down;
    public Button edit;
    public Button remove;
    public Button up;

    public DialogTableItem() {
        this(null);
    }

    public DialogTableItem(FormToolkit toolkit) {
        super(toolkit);
    }

    @Override
    public void addModifyListener(ModifyListener listener) {
    }

    @Override
    public void addSelectionListener(SelectionListener listener) {
    }

    @Override
    public void addVerifyListener(VerifyListener listener) {
    }

    @Override
    protected Control createItem(Composite composite) {
        Table result = null;
        FormToolkit toolkit = this.getToolkit();
        DialogItemTable tableItem = (DialogItemTable)this.getValueItem();
        Assert.isNotNull((Object)toolkit);
        Assert.isNotNull((Object)tableItem);
        tableItem.validate();
        GridLayout tableLayout = new GridLayout();
        tableLayout.numColumns = tableItem.tableLayoutColumns;
        tableLayout.horizontalSpacing = tableItem.tableLayoutSpacingH;
        tableLayout.verticalSpacing = tableItem.tableLayoutSpacingV;
        Composite tableComposite = new Composite(composite, tableItem.tableCompositeStyle);
        tableComposite.setLayout((Layout)tableLayout);
        tableComposite.setLayoutData((Object)new GridData(tableItem.tableCompositeGridStyle));
        result = toolkit.createTable(tableComposite, tableItem.tableStyle);
        result.setHeaderVisible(tableItem.tableVisibleH);
        result.setLinesVisible(tableItem.tableVisibleL);
        toolkit.setBorderStyle(tableItem.tableBorderStyle);
        this.setTable(result);
        if (tableItem.tableHeightHintConsumer != null) {
            tableItem.tableHeightHintConsumer.accept(this);
        }
        if (tableItem.tableWidthHintConsumer != null) {
            tableItem.tableWidthHintConsumer.accept(this);
        }
        this.setGridData(new GridData(4, 4, true, true));
        this.getGridData().heightHint = tableItem.tableHeightHint;
        this.getGridData().widthHint = tableItem.tableWidthHint;
        tableComposite.setLayoutData((Object)this.getGridData());
        tableComposite.setLayout((Layout)new FillLayout());
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        DialogItemTable.Column[] columnArray = tableItem.columns;
        int n = tableItem.columns.length;
        int n2 = 0;
        while (n2 < n) {
            DialogItemTable.Column column = columnArray[n2];
            TableColumn tableColumn = new TableColumn(result, column.style);
            tableColumnLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(column.weight, column.resizable));
            tableColumn.setText(column.name);
            ++n2;
        }
        tableComposite.setLayout((Layout)tableColumnLayout);
        this.viewer = new TableViewer(result);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)tableItem.viewerLabelProvider);
        this.viewer.setInput(tableItem.content);
        this.viewer.addOpenListener(tableItem.viewerOpenLister);
        this.viewer.addSelectionChangedListener(tableItem.viewerChangedListener);
        if (tableItem.isButtons()) {
            GridLayout tableButtonLayout = new GridLayout();
            tableButtonLayout.numColumns = tableItem.buttonLayoutColumns;
            tableButtonLayout.horizontalSpacing = tableItem.buttonLayoutSpacingH;
            tableButtonLayout.verticalSpacing = tableItem.buttonLayoutSpacingV;
            Composite tableButtonComposite = new Composite(composite, tableItem.buttonCompositeStyle);
            tableButtonComposite.setLayout((Layout)tableButtonLayout);
            tableButtonComposite.setLayoutData((Object)new GridData(tableItem.buttonCompositeGridStyle));
            if (tableItem.buttonAdd) {
                this.add = toolkit.createButton(tableButtonComposite, DialogButtonItem.AddLabel, 8);
                this.add.setBackground(Display.getCurrent().getSystemColor(22));
                this.add.addSelectionListener(tableItem.buttomListenerAdd);
                GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)this.add);
            }
            if (tableItem.buttonEdit) {
                this.edit = toolkit.createButton(tableButtonComposite, DialogButtonItem.EditLabel, 8);
                this.edit.setBackground(Display.getCurrent().getSystemColor(22));
                this.edit.addSelectionListener(tableItem.buttomListenerEdit);
                GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)this.edit);
            }
            if (tableItem.buttonRemove) {
                this.remove = toolkit.createButton(tableButtonComposite, DialogButtonItem.RemoveLabel, 8);
                this.remove.setBackground(Display.getCurrent().getSystemColor(22));
                this.remove.addSelectionListener(tableItem.buttomListenerRemove);
                GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)this.remove);
            }
            if (tableItem.buttonUp) {
                this.up = toolkit.createButton(tableButtonComposite, DialogButtonItem.UpLabel, 8);
                this.up.setBackground(Display.getCurrent().getSystemColor(22));
                this.up.addSelectionListener(tableItem.buttomListenerUp);
                GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)this.up);
            }
            if (tableItem.buttonDown) {
                this.down = toolkit.createButton(tableButtonComposite, DialogButtonItem.DownLabel, 8);
                this.down.setBackground(Display.getCurrent().getSystemColor(22));
                this.down.addSelectionListener(tableItem.buttomListenerDown);
                GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)this.down);
            }
        }
        return result;
    }

    @Override
    public final void reset(DialogItemTable value) {
    }

    @Override
    public final Table getItem() {
        return this.item;
    }

    @Override
    public final void setItem(Table item) {
        this.item = item;
    }

    public final Table getTable() {
        return this.table;
    }

    public final void setTable(Table table) {
        this.table = table;
    }

    public final TableViewer getViewer() {
        return this.viewer;
    }

    public final void setViewer(TableViewer viewer) {
        this.viewer = viewer;
    }

    public final Button getAdd() {
        return this.add;
    }

    public final void setAdd(Button add) {
        this.add = add;
    }

    public final Button getDown() {
        return this.down;
    }

    public final void setDown(Button down) {
        this.down = down;
    }

    public final Button getEdit() {
        return this.edit;
    }

    public final void setEdit(Button edit) {
        this.edit = edit;
    }

    public final Button getRemove() {
        return this.remove;
    }

    public final void setRemove(Button remove) {
        this.remove = remove;
    }

    public final Button getUp() {
        return this.up;
    }

    public final void setUp(Button up) {
        this.up = up;
    }
}

