/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.common.ui.elements;

import com.ibm.team.enterprise.common.ui.IDialogItem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;

public abstract class AbstractDialogItem<T, U>
implements IDialogItem<T, U> {
    public static final int defaultButtonHeight = 22;
    private static final int defaultLabelHeight = -1;
    private static final int defaultLabelWidth = 100;
    private static final int defaultValueHeight = -1;
    private static final int defaultValueWidth = 400;
    private static final int defaultLabelSpanC = 1;
    private static final int defaultLabelSpanR = 1;
    private static final int defaultValueLimit = 0;
    private static final int defaultValueSpanC = 1;
    private static final int defaultValueSpanR = 1;
    private static final int buttonCheck = 32;
    private static final int buttonPush = 8;
    private static final int combo = 8;
    private static final int labelLeft = 16388;
    private static final int labelBegin = 1;
    private static final int labelCenter = 0x1000000;
    private static final int labelEnd = 0x1000008;
    private static final int labelTop = 16;
    private static final int labelMiddle = 32;
    private static final int labelBottom = 64;
    private static final int spinner = 2048;
    private static final int valueSingleLn = 18436;
    private static final int valueMultiLns = 19010;
    private static final int valuePassword = 0x404804;
    private static final int valueReadOnly = 18444;
    private final FormToolkit toolkit;
    private String labelText;
    private String labelHelp;
    private boolean labelGrabH = false;
    private boolean labelGrabV = false;
    private int labelAlignH = 2;
    private int labelAlignV = 256;
    private int labelHintH = -1;
    private int labelHintW = -1;
    private int labelMaxH = -1;
    private int labelMaxW = -1;
    private int labelSpanC = 1;
    private int labelSpanR = 1;
    private int labelHeight = -1;
    private int labelWidth = 100;
    private int labelStyle = 16388;
    private T valueItem;
    private boolean valueGrabH = true;
    private boolean valueGrabV = false;
    private int valueAlignH = 2;
    private int valueAlignV = 256;
    private int valueHintH = -1;
    private int valueHintW = -1;
    private int valueMaxH = -1;
    private int valueMaxW = -1;
    private int valueSpanC = 1;
    private int valueSpanR = 1;
    private int valueLimit = 0;
    private int valueHeight = -1;
    private int valueWidth = 400;
    private int valueStyle = 18436;
    private String helpLbl;
    private String helpTxt;
    public Label label;
    public ControlDecoration deco;
    public GridData grid;
    public GridData gridl;
    public TableWrapData wrap;
    public TableWrapData wrapl;
    public VerifyListener vlnr;
    public ModifyListener mlnr;
    public SelectionListener slnr;
    private boolean hasValueStyle = false;
    private boolean skipLabel = false;
    private final List<Consumer<IDialogItem<T, ?>>> setters = new ArrayList();

    public AbstractDialogItem() {
        this(null);
    }

    public AbstractDialogItem(FormToolkit toolkit) {
        this.toolkit = toolkit;
    }

    @Override
    public final IDialogItem<T, ?> set(T value) {
        BiConsumer<IDialogItem, Object> consumer = IDialogItem::setValueItem;
        Consumer<IDialogItem> c = instance -> consumer.accept((IDialogItem)instance, value);
        this.setters.add(c);
        return this;
    }

    @Override
    public final IDialogItem<?, ?> set(BiConsumer<IDialogItem<?, ?>, Boolean> consumer, Boolean value) {
        Consumer<IDialogItem> c = instance -> consumer.accept((IDialogItem<?, ?>)instance, value);
        this.setters.add(c);
        return this;
    }

    @Override
    public final IDialogItem<?, ?> set(BiConsumer<IDialogItem<?, ?>, Integer> consumer, Integer value) {
        Consumer<IDialogItem> c = instance -> consumer.accept((IDialogItem<?, ?>)instance, value);
        this.setters.add(c);
        return this;
    }

    @Override
    public final IDialogItem<?, ?> set(BiConsumer<IDialogItem<?, ?>, String> consumer, String value) {
        Consumer<IDialogItem> c = instance -> consumer.accept((IDialogItem<?, ?>)instance, value);
        this.setters.add(c);
        return this;
    }

    @Override
    public final IDialogItem<?, ?> set(BiConsumer<IDialogItem<?, ?>, ModifyListener> consumer, ModifyListener value) {
        Consumer<IDialogItem> c = instance -> consumer.accept((IDialogItem<?, ?>)instance, value);
        this.setters.add(c);
        return this;
    }

    @Override
    public final IDialogItem<?, ?> set(BiConsumer<IDialogItem<?, ?>, SelectionListener> consumer, SelectionListener value) {
        Consumer<IDialogItem> c = instance -> consumer.accept((IDialogItem<?, ?>)instance, value);
        this.setters.add(c);
        return this;
    }

    @Override
    public final IDialogItem<?, ?> set(BiConsumer<IDialogItem<?, ?>, VerifyListener> consumer, VerifyListener value) {
        Consumer<IDialogItem> c = instance -> consumer.accept((IDialogItem<?, ?>)instance, value);
        this.setters.add(c);
        return this;
    }

    @Override
    public final IDialogItem build() {
        this.setters.forEach(setter -> setter.accept(this));
        this.setters.clear();
        return this;
    }

    @Override
    public final void addControlListener() {
        Assert.isNotNull((Object)this.getControl());
        this.getControl().addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent arg0) {
            }

            public void controlResized(ControlEvent arg0) {
                AbstractDialogItem.this.getControl().setSize(AbstractDialogItem.this.getControl().computeSize(AbstractDialogItem.this.getValueHintW(), AbstractDialogItem.this.getValueHintH()));
            }
        });
    }

    @Override
    public final void addHelp(String helpLbl, String helpTxt) {
        this.setHelpLbl(helpLbl);
        this.setHelpTxt(helpTxt);
        this.addHelp();
    }

    @Override
    public final void addHelp() {
        Assert.isNotNull((Object)this.getControl());
        Assert.isNotNull((Object)this.getHelpLbl());
        Assert.isNotNull((Object)this.getHelpTxt());
        this.getControl().addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
                MessageBox helpDialog = new MessageBox(AbstractDialogItem.this.getControl().getShell(), 36);
                helpDialog.setText(AbstractDialogItem.this.getHelpLbl());
                helpDialog.setMessage(AbstractDialogItem.this.getHelpTxt());
                helpDialog.open();
            }
        });
    }

    public final void addHelp(String helpLbl, String helpTxt, final DialogPage page) {
        this.setHelpLbl(helpLbl);
        this.setHelpTxt(helpTxt);
        Assert.isNotNull((Object)this.getControl());
        Assert.isNotNull((Object)this.getHelpLbl());
        Assert.isNotNull((Object)this.getHelpTxt());
        this.getControl().addHelpListener(new HelpListener(){
            private boolean helpSwitch;

            public void helpRequested(HelpEvent event) {
                if (this.helpSwitch) {
                    MessageBox helpDialog = new MessageBox(AbstractDialogItem.this.getControl().getShell(), 36);
                    helpDialog.setText(AbstractDialogItem.this.getHelpLbl());
                    helpDialog.setMessage(AbstractDialogItem.this.getHelpTxt());
                    helpDialog.open();
                } else {
                    page.performHelp();
                }
                this.helpSwitch = !this.helpSwitch;
            }
        });
    }

    @Override
    public abstract void addModifyListener(ModifyListener var1);

    @Override
    public abstract void addSelectionListener(SelectionListener var1);

    @Override
    public final void create(Composite composite, String labelText, T valueItem) {
        this.setLabelText(labelText);
        this.setValueItem(valueItem);
        this.setLabelWidth(-1);
        this.setValueWidth(-1);
        this.setValueHintW(-1);
        this.setValueMaxW(-1);
        this.create(composite);
    }

    @Override
    public final void create(Composite composite, String labelText, T valueItem, int labelWidth, int valueWidth) {
        this.setLabelText(labelText);
        this.setValueItem(valueItem);
        this.setLabelWidth(labelWidth);
        this.setValueWidth(valueWidth);
        this.setValueHintW(valueWidth);
        this.setValueMaxW(valueWidth);
        this.create(composite);
    }

    @Override
    public final void create(Composite composite, String labelText, T valueItem, int labelWidth, int valueWidth, int valueHeight) {
        this.setLabelText(labelText);
        this.setValueItem(valueItem);
        this.setLabelWidth(labelWidth);
        this.setValueWidth(valueWidth);
        this.setValueHintW(valueWidth);
        this.setValueMaxW(valueWidth);
        this.setValueHeight(valueHeight);
        this.setValueStyleMultiLns();
        this.create(composite);
    }

    @Override
    public final void create(Composite composite, String labelText, T valueItem, int labelWidth, int valueWidth, IDialogItem.Style style) {
        this.setLabelText(labelText);
        this.setValueItem(valueItem);
        this.setLabelWidth(labelWidth);
        this.setValueWidth(valueWidth);
        this.setValueHintW(valueWidth);
        this.setValueMaxW(valueWidth);
        this.setStyle(style);
        this.create(composite);
    }

    @Override
    public final void create(Composite composite, String labelText, String labelHelp, T valueItem) {
        this.setLabelText(labelText);
        this.setLabelHelp(labelHelp);
        this.setValueItem(valueItem);
        this.setLabelWidth(-1);
        this.setValueWidth(-1);
        this.setValueHintW(-1);
        this.setValueMaxW(-1);
        this.create(composite);
    }

    @Override
    public final void create(Composite composite, String labelText, String labelHelp, T valueItem, int labelWidth, int valueWidth) {
        this.setLabelText(labelText);
        this.setLabelHelp(labelHelp);
        this.setValueItem(valueItem);
        this.setLabelWidth(labelWidth);
        this.setValueWidth(valueWidth);
        this.setValueHintW(valueWidth);
        this.setValueMaxW(valueWidth);
        this.create(composite);
    }

    @Override
    public final void create(Composite composite, String labelText, String labelHelp, T valueItem, int labelWidth, int valueWidth, int valueHeight) {
        this.setLabelText(labelText);
        this.setLabelHelp(labelHelp);
        this.setValueItem(valueItem);
        this.setLabelWidth(labelWidth);
        this.setValueWidth(valueWidth);
        this.setValueHintW(valueWidth);
        this.setValueMaxW(valueWidth);
        this.setValueHeight(valueHeight);
        this.setValueStyleMultiLns();
        this.create(composite);
    }

    @Override
    public final void create(Composite composite, String labelText, String labelHelp, T valueItem, int labelWidth, int valueWidth, IDialogItem.Style style) {
        this.setLabelText(labelText);
        this.setLabelHelp(labelHelp);
        this.setValueItem(valueItem);
        this.setLabelWidth(labelWidth);
        this.setValueWidth(valueWidth);
        this.setValueHintW(valueWidth);
        this.setValueMaxW(valueWidth);
        this.setStyle(style);
        this.create(composite);
    }

    @Override
    public final void create(Composite composite, String labelText, T valueItem, String helpLbl, String helpTxt) {
        this.setLabelText(labelText);
        this.setValueItem(valueItem);
        this.setHelpLbl(helpLbl);
        this.setHelpTxt(helpTxt);
        this.setLabelWidth(-1);
        this.setValueWidth(-1);
        this.setValueHintW(-1);
        this.setValueMaxW(-1);
        this.create(composite);
    }

    @Override
    public final void create(Composite composite, String labelText, T valueItem, String helpLbl, String helpTxt, int labelWidth, int valueWidth) {
        this.setLabelText(labelText);
        this.setValueItem(valueItem);
        this.setHelpLbl(helpLbl);
        this.setHelpTxt(helpTxt);
        this.setLabelWidth(labelWidth);
        this.setValueWidth(valueWidth);
        this.setValueHintW(valueWidth);
        this.setValueMaxW(valueWidth);
        this.create(composite);
    }

    @Override
    public final void create(Composite composite, String labelText, T valueItem, String helpLbl, String helpTxt, int labelWidth, int valueWidth, int valueHeight) {
        this.setLabelText(labelText);
        this.setValueItem(valueItem);
        this.setHelpLbl(helpLbl);
        this.setHelpTxt(helpTxt);
        this.setLabelWidth(labelWidth);
        this.setValueWidth(valueWidth);
        this.setValueHintW(valueWidth);
        this.setValueMaxW(valueWidth);
        this.setValueHeight(valueHeight);
        this.setValueStyleMultiLns();
        this.create(composite);
    }

    @Override
    public final void create(Composite composite, String labelText, T valueItem, String helpLbl, String helpTxt, int labelWidth, int valueWidth, IDialogItem.Style style) {
        this.setLabelText(labelText);
        this.setValueItem(valueItem);
        this.setHelpLbl(helpLbl);
        this.setHelpTxt(helpTxt);
        this.setLabelWidth(labelWidth);
        this.setValueWidth(valueWidth);
        this.setValueHintW(valueWidth);
        this.setValueMaxW(valueWidth);
        this.setStyle(style);
        this.create(composite);
    }

    @Override
    public final void create(Composite composite, String labelText, String labelHelp, T valueItem, String helpLbl, String helpTxt) {
        this.setLabelText(labelText);
        this.setLabelHelp(labelHelp);
        this.setValueItem(valueItem);
        this.setHelpLbl(helpLbl);
        this.setHelpTxt(helpTxt);
        this.setLabelWidth(-1);
        this.setValueWidth(-1);
        this.setValueHintW(-1);
        this.setValueMaxW(-1);
        this.create(composite);
    }

    @Override
    public final void create(Composite composite, String labelText, String labelHelp, T valueItem, String helpLbl, String helpTxt, int labelWidth, int valueWidth) {
        this.setLabelText(labelText);
        this.setLabelHelp(labelHelp);
        this.setValueItem(valueItem);
        this.setHelpLbl(helpLbl);
        this.setHelpTxt(helpTxt);
        this.setLabelWidth(labelWidth);
        this.setValueWidth(valueWidth);
        this.setValueHintW(valueWidth);
        this.setValueMaxW(valueWidth);
        this.create(composite);
    }

    @Override
    public final void create(Composite composite, String labelText, String labelHelp, T valueItem, String helpLbl, String helpTxt, int labelWidth, int valueWidth, int valueHeight) {
        this.setLabelText(labelText);
        this.setLabelHelp(labelHelp);
        this.setValueItem(valueItem);
        this.setHelpLbl(helpLbl);
        this.setHelpTxt(helpTxt);
        this.setLabelWidth(labelWidth);
        this.setValueWidth(valueWidth);
        this.setValueHintW(valueWidth);
        this.setValueMaxW(valueWidth);
        this.setValueHeight(valueHeight);
        this.setValueStyleMultiLns();
        this.create(composite);
    }

    @Override
    public final void create(Composite composite, String labelText, String labelHelp, T valueItem, String helpLbl, String helpTxt, int labelWidth, int valueWidth, IDialogItem.Style style) {
        this.setLabelText(labelText);
        this.setLabelHelp(labelHelp);
        this.setValueItem(valueItem);
        this.setHelpLbl(helpLbl);
        this.setHelpTxt(helpTxt);
        this.setLabelWidth(labelWidth);
        this.setValueWidth(valueWidth);
        this.setValueHintW(valueWidth);
        this.setValueMaxW(valueWidth);
        this.setStyle(style);
        this.create(composite);
    }

    @Override
    public void create(Composite composite) {
        Assert.isNotNull((Object)composite);
        if (composite.getLayout() instanceof GridLayout) {
            if (composite.getLayoutData() instanceof FormData) {
                this.createFormItem(composite);
            } else {
                this.createGridItem(composite);
            }
        } else {
            this.createWrapItem(composite);
        }
        if (this.isHelpDefined()) {
            this.addHelp();
        }
    }

    private void createFormItem(Composite composite) {
        if (this.labelText != null) {
            this.setLabel(this.createLabel(composite));
            GridDataFactory.fillDefaults().hint(this.getLabelWidth(), this.getLabelHeight()).applyTo((Control)this.getLabel());
        }
        this.setControl(this.createItem(composite));
        this.deco = new ControlDecoration(this.getControl(), 16512, composite);
    }

    private void createGridItem(Composite composite) {
        if (!this.isSkipLabel()) {
            this.setLabel(this.createLabel(composite));
            GridDataFactory.fillDefaults().hint(this.getLabelWidth(), this.getLabelHeight()).applyTo((Control)this.getLabel());
        }
        this.setControl(this.createItem(composite));
        GridDataFactory.fillDefaults().hint(this.getValueWidth(), this.getValueHeight()).applyTo(this.getControl());
        this.deco = new ControlDecoration(this.getControl(), 16512, composite);
    }

    private void createWrapItem(Composite composite) {
        if (!this.isSkipLabel()) {
            this.setLabel(this.createLabel(composite));
            this.wrapl = new TableWrapData(this.getLabelAlignH(), this.getLabelAlignV(), this.getLabelSpanR(), this.getLabelSpanC());
            if (this.isLabelGrabH()) {
                this.wrapl.grabHorizontal = true;
            }
            if (this.isLabelGrabV()) {
                this.wrapl.grabVertical = true;
            }
            if (this.hasLabelMaxH()) {
                this.wrapl.maxHeight = this.getLabelMaxH();
            }
            if (this.hasLabelMaxW()) {
                this.wrapl.maxWidth = this.getLabelMaxW();
            }
            this.getLabel().setLayoutData((Object)this.wrapl);
        }
        this.setControl(this.createItem(composite));
        this.wrap = new TableWrapData(this.getValueAlignH(), this.getValueAlignV(), this.getValueSpanR(), this.getValueSpanC());
        if (this.isValueGrabH()) {
            this.wrap.grabHorizontal = true;
        }
        if (this.isValueGrabV()) {
            this.wrap.grabVertical = true;
        }
        if (this.hasValueMaxH()) {
            this.wrap.maxHeight = this.getValueMaxH();
        }
        if (this.hasValueMaxW()) {
            this.wrap.maxWidth = this.getValueMaxW();
        }
        this.getControl().setLayoutData((Object)this.wrap);
        this.deco = new ControlDecoration(this.getControl(), 16512, composite);
    }

    private Label createLabel(Composite composite) {
        Label result;
        if (this.getToolkit() == null) {
            result = new Label(composite, this.getLabelStyle());
            result.setText(this.getLabelText());
        } else {
            result = this.getToolkit().createLabel(composite, this.getLabelText(), this.getLabelStyle());
        }
        if (this.getLabelHelp() != null) {
            result.setToolTipText(this.getLabelHelp());
        }
        return result;
    }

    protected abstract Control createItem(Composite var1);

    private void setStyle(IDialogItem.Style style) {
        switch (style) {
            case SINGLELN: {
                this.setValueStyleDefault();
                break;
            }
            case PASSWORD: {
                this.setValueStylePassword();
                break;
            }
            case READONLY: {
                this.setValueStyleReadOnly();
                break;
            }
            case CHECK: {
                this.setValueStyleButtonDefault();
                break;
            }
            case PUSH: {
                this.setValueStyleButtonPush();
            }
        }
    }

    @Override
    public abstract void reset(T var1);

    @Override
    public final Label getLabel() {
        return this.label;
    }

    @Override
    public final void setLabel(Label label) {
        this.label = label;
    }

    @Override
    public abstract U getItem();

    @Override
    public abstract void setItem(U var1);

    @Override
    public final Control getControl() {
        return (Control)this.getItem();
    }

    @Override
    public final void setControl(Control control) {
        this.setItem(control);
    }

    @Override
    public final FormToolkit getToolkit() {
        return this.toolkit;
    }

    @Override
    public final ControlDecoration getDecoration() {
        return this.deco;
    }

    @Override
    public final void setDecoration(ControlDecoration deco) {
        this.deco = deco;
    }

    @Override
    public final GridData getGridData() {
        return this.grid;
    }

    @Override
    public final void setGridData(GridData grid) {
        this.grid = grid;
    }

    @Override
    public final GridData getGridDataLabel() {
        return this.gridl;
    }

    @Override
    public final void setGridDataLabel(GridData gridl) {
        this.gridl = gridl;
    }

    @Override
    public final TableWrapData getWrapData() {
        return this.wrap;
    }

    @Override
    public final void setWrapData(TableWrapData wrap) {
        this.wrap = wrap;
    }

    @Override
    public final TableWrapData getWrapDataLabel() {
        return this.wrapl;
    }

    @Override
    public final void setWrapDataLabel(TableWrapData wrapl) {
        this.wrapl = wrapl;
    }

    @Override
    public final ModifyListener getModifyListener() {
        return this.mlnr;
    }

    @Override
    public final boolean hasModifyListener() {
        return this.mlnr != null;
    }

    @Override
    public final void setModifyListener(ModifyListener mlnr) {
        this.mlnr = mlnr;
    }

    @Override
    public final SelectionListener getSelectionListener() {
        return this.slnr;
    }

    @Override
    public final boolean hasSelectionListener() {
        return this.slnr != null;
    }

    @Override
    public final void setSelectionListener(SelectionListener slnr) {
        this.slnr = slnr;
    }

    @Override
    public final VerifyListener getVerifyListener() {
        return this.vlnr;
    }

    @Override
    public boolean hasVerifyListener() {
        return this.vlnr != null;
    }

    @Override
    public final void setVerifyListener(VerifyListener vlnr) {
        this.vlnr = vlnr;
    }

    protected final boolean hasValueStyle() {
        return this.hasValueStyle;
    }

    protected final void setHasValueStyle(boolean hasValueStyle) {
        this.hasValueStyle = hasValueStyle;
    }

    protected final boolean isSkipLabel() {
        return this.skipLabel;
    }

    protected final void setSkipLabel(boolean skipLabel) {
        this.skipLabel = skipLabel;
    }

    @Override
    public final String getLabelText() {
        return this.labelText;
    }

    @Override
    public final void setLabelText(String labelText) {
        Assert.isNotNull((Object)labelText);
        this.labelText = labelText;
    }

    @Override
    public final String getLabelHelp() {
        return this.labelHelp;
    }

    @Override
    public final void setLabelHelp(String labelHelp) {
        this.labelHelp = labelHelp;
    }

    @Override
    public final boolean isLabelGrabH() {
        return this.labelGrabH;
    }

    @Override
    public final void setLabelGrabH(boolean labelGrabH) {
        this.labelGrabH = labelGrabH;
    }

    @Override
    public final boolean isLabelGrabV() {
        return this.labelGrabV;
    }

    @Override
    public final void setLabelGrabV(boolean labelGrabV) {
        this.labelGrabV = labelGrabV;
    }

    @Override
    public final int getLabelAlignH() {
        return this.labelAlignH;
    }

    @Override
    public final void setLabelAlignH(int labelAlignH) {
        this.labelAlignH = labelAlignH;
    }

    @Override
    public final int getLabelAlignV() {
        return this.labelAlignV;
    }

    @Override
    public final void setLabelAlignV(int labelAlignV) {
        this.labelAlignV = labelAlignV;
    }

    @Override
    public final int getLabelHintH() {
        return this.labelHintH;
    }

    @Override
    public final void setLabelHintH(int labelHintH) {
        this.labelHintH = labelHintH;
    }

    @Override
    public final int getLabelHintW() {
        return this.labelHintW;
    }

    @Override
    public final void setLabelHintW(int labelHintW) {
        this.labelHintW = labelHintW;
    }

    @Override
    public final int getLabelMaxH() {
        return this.labelMaxH;
    }

    @Override
    public final boolean hasLabelMaxH() {
        return this.labelMaxH != -1;
    }

    @Override
    public final void setLabelMaxH(int labelMaxH) {
        this.labelMaxH = labelMaxH;
    }

    @Override
    public final int getLabelMaxW() {
        return this.labelMaxW;
    }

    @Override
    public final boolean hasLabelMaxW() {
        return this.labelMaxW != -1;
    }

    @Override
    public final void setLabelMaxW(int labelMaxW) {
        this.labelMaxW = labelMaxW;
    }

    @Override
    public final int getLabelSpanC() {
        return this.labelSpanC;
    }

    @Override
    public final void setLabelSpanC(int labelSpanC) {
        this.labelSpanC = labelSpanC;
    }

    @Override
    public final int getLabelSpanR() {
        return this.labelSpanR;
    }

    @Override
    public final void setLabelSpanR(int labelSpanR) {
        this.labelSpanR = labelSpanR;
    }

    @Override
    public final int getLabelHeight() {
        return this.labelHeight;
    }

    @Override
    public final void setLabelHeight(int labelHeight) {
        this.labelHeight = labelHeight;
    }

    @Override
    public final int getLabelWidth() {
        return this.labelWidth;
    }

    @Override
    public final void setLabelWidth(int labelWidth) {
        this.labelWidth = labelWidth == 0 ? 100 : labelWidth;
    }

    @Override
    public final int getLabelStyle() {
        return this.labelStyle;
    }

    @Override
    public final void setLabelStyle(int labelStyle) {
        this.labelStyle = labelStyle;
    }

    @Override
    public final void setLabelStyleTop() {
        this.labelStyle = 1;
        this.labelAlignV = 16;
    }

    @Override
    public final void setLabelStyleCenter() {
        this.labelStyle = 0x1000000;
        this.labelAlignV = 32;
    }

    @Override
    public final void setLabelStyleBottom() {
        this.labelStyle = 0x1000008;
        this.labelAlignV = 64;
    }

    @Override
    public final T getValueItem() {
        return this.valueItem;
    }

    @Override
    public final void setValueItem(T valueItem) {
        Assert.isNotNull(valueItem);
        this.valueItem = valueItem;
    }

    @Override
    public final boolean isValueGrabH() {
        return this.valueGrabH;
    }

    @Override
    public final void setValueGrabH(boolean valueGrabH) {
        this.valueGrabH = valueGrabH;
    }

    @Override
    public final boolean isValueGrabV() {
        return this.valueGrabV;
    }

    @Override
    public final void setValueGrabV(boolean valueGrabV) {
        this.valueGrabV = valueGrabV;
    }

    @Override
    public final int getValueAlignH() {
        return this.valueAlignH;
    }

    @Override
    public final void setValueAlignH(int valueAlignH) {
        this.valueAlignH = valueAlignH;
    }

    @Override
    public final int getValueAlignV() {
        return this.valueAlignV;
    }

    @Override
    public final void setValueAlignV(int valueAlignV) {
        this.valueAlignV = valueAlignV;
    }

    @Override
    public final int getValueHintH() {
        return this.valueHintH;
    }

    @Override
    public final void setValueHintH(int valueHintH) {
        this.valueHintH = valueHintH;
    }

    @Override
    public final int getValueHintW() {
        return this.valueHintW;
    }

    @Override
    public final void setValueHintW(int valueHintW) {
        this.valueHintW = valueHintW == 0 ? -1 : valueHintW;
    }

    @Override
    public final int getValueMaxH() {
        return this.valueMaxH;
    }

    @Override
    public final boolean hasValueMaxH() {
        return this.valueMaxH != -1;
    }

    @Override
    public final void setValueMaxH(int valueMaxH) {
        this.valueMaxH = valueMaxH == 0 ? -1 : valueMaxH;
    }

    @Override
    public final int getValueMaxW() {
        return this.valueMaxW;
    }

    @Override
    public final boolean hasValueMaxW() {
        return this.valueMaxW != -1;
    }

    @Override
    public final void setValueMaxW(int valueMaxW) {
        this.valueMaxW = valueMaxW;
    }

    @Override
    public final int getValueSpanC() {
        return this.valueSpanC;
    }

    @Override
    public final void setValueSpanC(int valueSpanC) {
        this.valueSpanC = valueSpanC;
    }

    @Override
    public final int getValueSpanR() {
        return this.valueSpanR;
    }

    @Override
    public final void setValueSpanR(int valueSpanR) {
        this.valueSpanR = valueSpanR;
    }

    @Override
    public final int getValueLimit() {
        return this.valueLimit;
    }

    @Override
    public final void setValueLimit(int valueLimit) {
        this.valueLimit = valueLimit;
    }

    @Override
    public final int getValueHeight() {
        return this.valueHeight;
    }

    @Override
    public final void setValueHeight(int valueHeight) {
        this.valueHeight = valueHeight;
    }

    @Override
    public final int getValueWidth() {
        return this.valueWidth;
    }

    @Override
    public final void setValueWidth(int valueWidth) {
        this.valueWidth = valueWidth == 0 ? 400 : valueWidth;
    }

    @Override
    public final int getValueStyle() {
        return this.valueStyle;
    }

    @Override
    public final void setValueStyle(int valueStyle) {
        this.valueStyle = valueStyle;
    }

    @Override
    public final void setValueStyleDefault() {
        this.valueStyle = 18436;
    }

    @Override
    public final void setValueStyleSingleLn() {
        this.valueStyle = 18436;
    }

    @Override
    public final void setValueStyleMultiLns() {
        this.valueStyle = 19010;
    }

    @Override
    public final void setValueStylePassword() {
        this.valueStyle = 0x404804;
    }

    @Override
    public final void setValueStyleReadOnly() {
        this.valueStyle = 18444;
    }

    @Override
    public final void setValueStyleButtonDefault() {
        this.valueStyle = 32;
    }

    @Override
    public final void setValueStyleButtonPush() {
        this.valueStyle = 8;
    }

    @Override
    public final void setValueStyleComboDefault() {
        this.valueStyle = 8;
    }

    @Override
    public final void setValueStyleSpinnerDefault() {
        this.valueStyle = 2048;
    }

    @Override
    public final String getHelpLbl() {
        return this.helpLbl;
    }

    @Override
    public final void setHelpLbl(String helpLbl) {
        this.helpLbl = helpLbl;
    }

    @Override
    public final String getHelpTxt() {
        return this.helpTxt;
    }

    @Override
    public final void setHelpTxt(String helpTxt) {
        this.helpTxt = helpTxt;
    }

    @Override
    public final boolean isHelpDefined() {
        return this.helpLbl != null && this.helpTxt != null;
    }
}

