/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.common.ui.editors;

import com.ibm.team.enterprise.common.common.IEnterpriseConfiguration;
import com.ibm.team.enterprise.common.ui.editors.EnterpriseConfigurationEditor;
import com.ibm.team.enterprise.common.ui.elements.DialogComboItem;
import com.ibm.team.enterprise.common.ui.nls.Messages;
import com.ibm.team.enterprise.internal.common.client.EnterpriseConfigurationCache;
import com.ibm.team.enterprise.internal.common.common.model.CodePage;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.ui.editor.TeamFormEditor;
import com.ibm.team.ui.editor.TeamFormPage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class EnterpriseConfigurationPage
extends TeamFormPage {
    private static final int comboboxMaxWidth = 240;
    private final EnterpriseConfigurationEditor editor;
    private final TeamFormEditor teamEditor;
    private final DialogComboItem codepageItem = new DialogComboItem();
    protected FormToolkit toolkit;
    protected IManagedForm managedForm;
    protected IEnterpriseConfiguration workingcopy;
    private boolean dirty;

    public EnterpriseConfigurationPage(FormEditor editor, String title) {
        super(editor, title, title);
        this.editor = (EnterpriseConfigurationEditor)editor;
        this.teamEditor = (TeamFormEditor)editor;
        this.workingcopy = this.editor.getEditorInput().getWorkingCopy();
        if (this.workingcopy.isNewItem()) {
            this.setDirty(true);
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.managedForm = managedForm;
        this.toolkit = managedForm.getToolkit();
        managedForm.getToolkit().setBorderStyle(2048);
        Composite body = managedForm.getForm().getBody();
        body.setLayout((Layout)new TableWrapLayout());
        Composite container = managedForm.getToolkit().createComposite(managedForm.getForm().getBody());
        TableWrapData layoutData = new TableWrapData(256, 256);
        container.setLayoutData((Object)layoutData);
        container.setLayout((Layout)new FormLayout());
        this.createSection(container);
    }

    private Composite createSection(Composite parent) {
        Section section = this.toolkit.createSection(parent, 384);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 10);
        formData.left = new FormAttachment(0, 10);
        formData.right = new FormAttachment(100);
        section.setLayoutData((Object)formData);
        section.setLayout((Layout)new GridLayout(1, false));
        section.setText(Messages.EnterpriseConfigurationEditorPage_HEADER_LABEL);
        Composite container = this.toolkit.createComposite((Composite)section);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)new GridLayout(2, false));
        section.setClient((Control)container);
        this.codepageItem.label = this.toolkit.createLabel(container, Messages.EnterpriseConfigurationEditorPage_SECTION_CODEPAGE);
        this.codepageItem.label.setToolTipText(Messages.EnterpriseConfigurationEditorPage_TOOLTIP_CODEPAGE);
        this.codepageItem.item = new Combo(container, 12);
        this.codepageItem.item.setItems(CodePage.getLabels());
        this.codepageItem.item.select(CodePage.getIndex((CodePage)this.workingcopy.getCodePage()));
        this.codepageItem.grid = new GridData(4, 4, true, true);
        this.codepageItem.grid.widthHint = 240;
        this.codepageItem.item.setLayoutData((Object)this.codepageItem.wrap);
        this.codepageItem.item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnterpriseConfigurationPage.this.workingcopy.setCodePage(CodePage.getArray()[((EnterpriseConfigurationPage)EnterpriseConfigurationPage.this).codepageItem.item.getSelectionIndex()]);
                EnterpriseConfigurationPage.this.editor.removeErrorMessage(((EnterpriseConfigurationPage)EnterpriseConfigurationPage.this).codepageItem.item, (Control)((EnterpriseConfigurationPage)EnterpriseConfigurationPage.this).codepageItem.item);
                EnterpriseConfigurationPage.this.setDirty(true);
            }
        });
        this.codepageItem.item.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
                MessageBox helpDialog = new MessageBox(((EnterpriseConfigurationPage)EnterpriseConfigurationPage.this).codepageItem.item.getShell(), 36);
                helpDialog.setText(Messages.EnterpriseConfigurationEditorPage_HELPLBL_CODEPAGE);
                helpDialog.setMessage(Messages.EnterpriseConfigurationEditorPage_HELPTXT_CODEPAGE);
                helpDialog.open();
            }
        });
        return container;
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        if (this.isDirty()) {
            Job fetchConfiguration = new Job(Messages.EnterpriseConfigurationEditorInput_JOB){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        IEnterpriseConfiguration configuration = EnterpriseConfigurationCache.getInstance().save(EnterpriseConfigurationPage.this.editor.getTeamRepository(), EnterpriseConfigurationPage.this.workingcopy, monitor);
                        EnterpriseConfigurationPage.this.editor.getEditorInput().setConfiguration(configuration);
                        EnterpriseConfigurationPage.this.editor.getEditorInput().setWorkingCopy(configuration);
                        EnterpriseConfigurationPage.this.workingcopy = EnterpriseConfigurationPage.this.editor.getEditorInput().getWorkingCopy();
                    }
                    catch (TeamRepositoryException e) {
                        MessageDialog.openError((Shell)EnterpriseConfigurationPage.this.getSite().getShell(), (String)Messages.EnterpriseConfigurationEditorPage_ERROR_TITLE, (String)e.getLocalizedMessage());
                    }
                    return Status.OK_STATUS;
                }
            };
            fetchConfiguration.schedule();
        }
        this.setDirty(false);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean isDirty) {
        if (this.isDirty() != isDirty) {
            this.dirty = isDirty;
            this.teamEditor.editorDirtyStateChanged();
        }
    }

    public void setWorkingCopy() {
        this.workingcopy = this.editor.getEditorInput().getWorkingCopy();
    }
}

