/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.common.ui.editors;

import com.ibm.team.enterprise.common.ui.IDialogItem;
import com.ibm.team.enterprise.common.ui.actions.EnterpriseConfigurationActionSave;
import com.ibm.team.enterprise.common.ui.editors.AbstractMessageFormEditor;
import com.ibm.team.enterprise.common.ui.editors.EnterpriseConfigurationEditorInput;
import com.ibm.team.enterprise.common.ui.editors.EnterpriseConfigurationPage;
import com.ibm.team.enterprise.common.ui.nls.Messages;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.Form;

public class EnterpriseConfigurationEditor
extends AbstractMessageFormEditor {
    protected EnterpriseConfigurationActionSave saveAction;
    protected boolean isDisposed = false;
    protected int busyCount;
    private EnterpriseConfigurationPage configurationPage;

    protected void createHeaderContents(IManagedForm headerForm) {
        Form form = headerForm.getForm().getForm();
        form.setText(Messages.EnterpriseConfigurationEditor_HEADER_LABEL);
        form.setImage(null);
        IToolBarManager toolBarManager = form.getToolBarManager();
        this.saveAction = new EnterpriseConfigurationActionSave(this);
        toolBarManager.add((IContributionItem)this.saveAction);
        form.updateToolBar();
        this.addPropertyListener(new DirtyPropertyListener());
        this.fMessageManager = headerForm.getMessageManager();
        this.fMessageManager.setDecorationPosition(16512);
        Composite head = form.getHead();
        Composite headClient = new Composite(head, 0);
        headClient.setLayout((Layout)new GridLayout(2, false));
        headClient.setLayoutData((Object)new GridData());
        ITeamRepository repository = this.getEditorInput().getTeamRepository();
        Label label0 = headerForm.getToolkit().createLabel(headClient, Messages.EnterpriseConfigurationEditor_REPOSITORY_LABEL);
        label0.setBackground(null);
        Text text0 = headerForm.getToolkit().createText(headClient, repository.getRepositoryURI());
        text0.setEnabled(false);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)text0);
        IProjectAreaHandle projectAreaHandle = this.getEditorInput().getProjectAreaHandle();
        String projectAreaName = ConnectedProjectAreaRegistry.getDefault().getProjectAreaName(projectAreaHandle);
        Label label1 = headerForm.getToolkit().createLabel(headClient, Messages.EnterpriseConfigurationEditor_PROJECTAREA_LABEL);
        label1.setBackground(null);
        Text text1 = headerForm.getToolkit().createText(headClient, projectAreaName);
        text1.setEnabled(false);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)text1);
        headerForm.getForm().setHeadClient((Control)headClient);
    }

    protected void addPages() {
        try {
            this.configurationPage = new EnterpriseConfigurationPage((FormEditor)this, Messages.EnterpriseConfigurationEditor_CONFIGURATION_TAB);
            this.configurationPage.initialize((FormEditor)this);
            this.addPage((IFormPage)this.configurationPage);
        }
        catch (PartInitException partInitException) {
            // empty catch block
        }
    }

    public void doSaveAs() {
    }

    public EnterpriseConfigurationEditorInput getEditorInput() {
        return (EnterpriseConfigurationEditorInput)super.getEditorInput();
    }

    public boolean isBusy() {
        return this.busyCount > 0;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setBusy(boolean isBusy) {
        if (!this.isDisposed) {
            if (this.busyCount == 0 && isBusy) {
                this.getHeaderForm().getForm().setBusy(true);
            } else if (this.busyCount == 1 && !isBusy) {
                this.getHeaderForm().getForm().setBusy(false);
            }
            if (isBusy) {
                ++this.busyCount;
            } else if (this.busyCount > 0) {
                --this.busyCount;
            }
        }
        this.saveAction.updateEnabledState();
    }

    public IProjectAreaHandle getProjectAreaHandle() {
        return this.getEditorInput().getProjectAreaHandle();
    }

    public ITeamRepository getTeamRepository() {
        return this.getEditorInput().getTeamRepository();
    }

    public void setMessage(IDialogItem<?, ?> dialogItem, String message) {
        if (message != null) {
            dialogItem.getDecoration().setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
            dialogItem.getDecoration().setDescriptionText(message);
        } else {
            dialogItem.getDecoration().hide();
            dialogItem.getDecoration().setImage(null);
            dialogItem.getDecoration().show();
        }
    }

    protected class DirtyPropertyListener
    implements IPropertyListener {
        protected DirtyPropertyListener() {
        }

        public void propertyChanged(Object source, int propertyId) {
            if (source instanceof IEditorPart && propertyId == 257) {
                EnterpriseConfigurationEditor.this.saveAction.updateEnabledState();
            }
        }
    }
}

