/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.common.ui.dialogs;

import com.ibm.team.enterprise.common.ui.Activator;
import com.ibm.team.enterprise.common.ui.nls.Messages;
import java.io.IOException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class MessagePromptDialog
extends MessageDialog {
    protected boolean doNotDisplayDialog;
    protected IPreferenceStore preferenceStore;
    protected String displayDialogPreferenceId;
    protected Button doNotDisplayDialogCheckbox;

    protected MessagePromptDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, IPreferenceStore preferenceStore, String displayDialogPreferenceId) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        this.preferenceStore = preferenceStore;
        this.displayDialogPreferenceId = displayDialogPreferenceId;
    }

    protected Control createCustomArea(Composite parent) {
        if (this.preferenceStore != null && this.displayDialogPreferenceId != null) {
            Label label = new Label(parent, 0);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)label);
            this.doNotDisplayDialogCheckbox = new Button(parent, 32);
            this.doNotDisplayDialogCheckbox.setText(Messages.MessagePromptDialog_DO_NOT_DISPLAY_DIALOG_LABEL);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.doNotDisplayDialogCheckbox);
            this.doNotDisplayDialogCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MessagePromptDialog.this.preferenceStore.setValue(MessagePromptDialog.this.displayDialogPreferenceId, !MessagePromptDialog.this.doNotDisplayDialogCheckbox.getSelection());
                    if (MessagePromptDialog.this.preferenceStore instanceof IPersistentPreferenceStore) {
                        try {
                            ((IPersistentPreferenceStore)MessagePromptDialog.this.preferenceStore).save();
                        }
                        catch (IOException ex) {
                            Activator.log(ex);
                        }
                    }
                }
            });
            return this.doNotDisplayDialogCheckbox;
        }
        return null;
    }

    public static boolean open(int kind, Shell parent, String title, String message, IPreferenceStore preferenceStore, String displayDialogPreferenceId) {
        IPreferenceStore targetPreferenceStore = preferenceStore == null ? Activator.getDefault().getPreferenceStore() : preferenceStore;
        if (targetPreferenceStore != null && displayDialogPreferenceId != null && !targetPreferenceStore.getBoolean(displayDialogPreferenceId)) {
            return true;
        }
        String[] dialogButtons = kind == 3 ? new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL} : new String[]{IDialogConstants.OK_LABEL};
        MessagePromptDialog dlg = new MessagePromptDialog(parent, title, null, message, kind, dialogButtons, 0, targetPreferenceStore, displayDialogPreferenceId);
        dlg.setShellStyle(dlg.getShellStyle() | 0x10000000);
        return dlg.open() == 0;
    }

    public static void openInformation(Shell parent, String title, String message, String displayDialogPreferenceId) {
        MessagePromptDialog.open(2, parent, title, message, null, displayDialogPreferenceId);
    }

    public static void openInformation(Shell parent, String title, String message, IPreferenceStore preferenceStore, String displayDialogPreferenceId) {
        MessagePromptDialog.open(2, parent, title, message, preferenceStore, displayDialogPreferenceId);
    }

    public static void openWarning(Shell parent, String title, String message, String displayDialogPreferenceId) {
        MessagePromptDialog.open(4, parent, title, message, null, displayDialogPreferenceId);
    }

    public static void openWarning(Shell parent, String title, String message, IPreferenceStore preferenceStore, String displayDialogPreferenceId) {
        MessagePromptDialog.open(4, parent, title, message, preferenceStore, displayDialogPreferenceId);
    }

    public static boolean openQuestion(Shell parent, String title, String message, String displayDialogPreferenceId) {
        return MessagePromptDialog.open(3, parent, title, message, null, displayDialogPreferenceId);
    }

    public static boolean openQuestion(Shell parent, String title, String message, IPreferenceStore preferenceStore, String displayDialogPreferenceId) {
        return MessagePromptDialog.open(3, parent, title, message, preferenceStore, displayDialogPreferenceId);
    }
}

