/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.common.ui;

import com.ibm.team.enterprise.metadata.common.collection.transport.TransportFile;
import com.ibm.team.enterprise.metadata.common.collection.transport.TransportProperty;
import com.ibm.team.repository.client.ITeamRepository;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class TransportFileEditorInput
implements IEditorInput {
    TransportFile fTransportFile;
    ITeamRepository fRepo;
    private String streamId;
    private String componentName;

    public TransportFileEditorInput(TransportFile transportFile, ITeamRepository repo, String streamId) {
        this.fTransportFile = transportFile;
        this.fRepo = repo;
        this.streamId = streamId;
        this.componentName = "";
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        String name = null;
        if (this.fTransportFile != null) {
            for (TransportProperty prop : this.fTransportFile.getProperties()) {
                if (!prop.getNamespace().equals("http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/scm/") || !prop.getLocalName().equals("fileName")) continue;
                return prop.getValue().getStringValue();
            }
            name = this.fTransportFile.getMetadataURI();
        }
        return name;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return "";
    }

    public Object getAdapter(Class arg0) {
        return null;
    }

    public TransportFile getTransportFile() {
        return this.fTransportFile;
    }

    public ITeamRepository getTeamRepository() {
        return this.fRepo;
    }

    public String getComponentId() {
        String componentId = null;
        if (this.fTransportFile != null) {
            for (TransportProperty prop : this.fTransportFile.getProperties()) {
                if (!prop.getNamespace().equals("http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/scm/") || !prop.getLocalName().equals("componentId")) continue;
                return prop.getValue().getStringValue();
            }
        }
        return componentId;
    }

    public String getStreamId() {
        if (this.streamId == null && this.fTransportFile != null) {
            for (TransportProperty prop : this.fTransportFile.getProperties()) {
                if (!prop.getNamespace().equals("http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/scm/") || !prop.getLocalName().equals("streamId")) continue;
                this.streamId = prop.getValue().getStringValue();
                break;
            }
        }
        return this.streamId;
    }

    public String getFileItemId() {
        String fileItemId = null;
        if (this.fTransportFile != null) {
            for (TransportProperty prop : this.fTransportFile.getProperties()) {
                if (!prop.getNamespace().equals("http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/scm/") || !prop.getLocalName().equals("fileItemId")) continue;
                return prop.getValue().getStringValue();
            }
        }
        return fileItemId;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public String getComponentName() {
        return this.componentName;
    }
}

