/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.common.ui;

import com.ibm.team.enterprise.common.ui.Activator;
import com.ibm.team.enterprise.common.ui.IEnterpriseOpenHandler;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class HyperlinkOpenHandlerRegistery {
    private static final String ID = "com.ibm.team.enterprise.common.ui.enterpriseHyperlinkOpenHandler";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String NAME_ATTRIBUTE = "name";
    private static HyperlinkOpenHandlerRegistery instance;
    private final List<IEnterpriseOpenHandler> handlers = new ArrayList<IEnterpriseOpenHandler>();

    public static HyperlinkOpenHandlerRegistery getInstance() {
        if (instance == null) {
            instance = new HyperlinkOpenHandlerRegistery();
        }
        return instance;
    }

    private HyperlinkOpenHandlerRegistery() {
        IExtensionPoint extensionPoint;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry != null && (extensionPoint = registry.getExtensionPoint(ID)) != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension element = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = element.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement ce = iConfigurationElementArray[n4];
                    String name = ce.getAttribute(NAME_ATTRIBUTE);
                    try {
                        Object handler = ce.createExecutableExtension(CLASS_ATTRIBUTE);
                        if (handler instanceof IEnterpriseOpenHandler) {
                            this.add((IEnterpriseOpenHandler)handler);
                        }
                    }
                    catch (CoreException x) {
                        Activator.getDefault().log("Errors on instantiating open link handler " + name, x);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private void add(IEnterpriseOpenHandler handler) {
        this.handlers.add(handler);
    }

    public IEnterpriseOpenHandler getOpenHandler(URI uri) {
        for (IEnterpriseOpenHandler handler : this.handlers) {
            if (!handler.handles(uri)) continue;
            return handler;
        }
        return null;
    }
}

