/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.common.ui;

import com.ibm.team.build.extensions.common.util.StringUtil;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildMap;
import com.ibm.team.enterprise.buildablesubset.common.internal.model.impl.ModelFactoryImpl;
import com.ibm.team.enterprise.common.client.util.URIUtilities;
import com.ibm.team.enterprise.common.ui.Activator;
import com.ibm.team.enterprise.common.ui.HyperlinkOpenHandlerRegistery;
import com.ibm.team.enterprise.common.ui.IEnterpriseFavoritesItem;
import com.ibm.team.enterprise.common.ui.IEnterpriseOpenHandler;
import com.ibm.team.enterprise.common.ui.nls.Messages;
import com.ibm.team.enterprise.metadata.common.query.IScdQueryDescriptor;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiLanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiSearchPath;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiTranslator;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IVersionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosLanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosTranslator;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.HyperlinkHandler;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIUtils;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IVersionable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class EnterpriseHyperlinkHandler
extends HyperlinkHandler {
    private static final String UNK = "Unknown";
    private static List<IItemType> types = new ArrayList<IItemType>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(IBuildMap.ITEM_TYPE);
            this.add(IIBMiLanguageDefinition.ITEM_TYPE);
            this.add(IIBMiResourceDefinition.ITEM_TYPE);
            this.add(IIBMiSearchPath.ITEM_TYPE);
            this.add(IIBMiTranslator.ITEM_TYPE);
            this.add(IFunctionDefinition.ITEM_TYPE);
            this.add(IVersionDefinition.ITEM_TYPE);
            this.add(IDataSetDefinition.ITEM_TYPE);
            this.add(IZosLanguageDefinition.ITEM_TYPE);
            this.add(IZosTranslator.ITEM_TYPE);
            this.add(IScdQueryDescriptor.ITEM_TYPE);
            this.add(ModelFactoryImpl.eINSTANCE.createSubsetHandle().getItemType());
        }
    };

    public URIReference createHyperlink(Object object, IProgressMonitor monitor) {
        if (object instanceof IEnterpriseFavoritesItem) {
            IEnterpriseFavoritesItem efi = (IEnterpriseFavoritesItem)object;
            IItem item = efi.getItem();
            ITeamRepository repository = (ITeamRepository)item.getOrigin();
            if (item instanceof IScdQueryDescriptor) {
                repository = (ITeamRepository)((IScdQueryDescriptor)item).getProjectArea().getOrigin();
            }
            URI uri = Location.itemLocation((IItemHandle)item, (String)repository.getRepositoryURI()).toAbsoluteUri();
            return new URIReference(efi.getItemName(), efi.getItemDescription(), efi.getItemReferenceType(), uri);
        }
        if (object instanceof IItem && this.isOurItem(object)) {
            IBuildMap item;
            String itemName = UNK;
            String itemDescription = UNK;
            String itemReferenceType = UNK;
            if (object instanceof IBuildMap) {
                item = (IBuildMap)object;
                if (item.getBuildableFile().hasFullState()) {
                    itemName = ((IVersionable)item.getBuildableFile()).getName();
                } else {
                    try {
                        ITeamRepository r = (ITeamRepository)item.getOrigin();
                        IVersionable v = (IVersionable)r.itemManager().fetchCompleteItem((IItemHandle)item.getBuildableFile(), 0, monitor);
                        itemName = v.getName();
                    }
                    catch (TeamRepositoryException r) {
                        // empty catch block
                    }
                }
                itemDescription = StringUtil.valueOf((String)item.getBuildLabel());
                itemReferenceType = object.getClass().getName();
            } else if (object instanceof ISystemDefinition) {
                item = (ISystemDefinition)object;
                itemName = item.getName();
                itemDescription = StringUtil.valueOf((String)item.getDescription());
                itemReferenceType = object.getClass().getName();
            }
            item = (IItem)object;
            ITeamRepository repository = (ITeamRepository)item.getOrigin();
            URI uri = Location.itemLocation((IItemHandle)item, (String)repository.getRepositoryURI()).toAbsoluteUri();
            return new URIReference(itemName, itemDescription, itemReferenceType, uri);
        }
        return super.createHyperlink(object, monitor);
    }

    public IItemType guessItemType(URI uri) {
        String uriString = uri.toString();
        if (uriString.contains("com.ibm.team.enterprise.systemdefinition.DataSetDefinition")) {
            return IDataSetDefinition.ITEM_TYPE;
        }
        return super.guessItemType(uri);
    }

    public boolean handles(URI uri) {
        IItemType itemType = URIUtilities.findItemType((URI)uri);
        return types.contains(itemType);
    }

    public boolean links(Object object) {
        if (object instanceof IEnterpriseFavoritesItem) {
            return true;
        }
        if (object instanceof IItem && this.isOurItem(object)) {
            return true;
        }
        return super.links(object);
    }

    private boolean isOurItem(Object object) {
        return types.contains(((IItem)object).getItemType());
    }

    public IStatus open2(URI uri, ContextProvider context, IProgressMonitor progressmonitor) {
        try {
            IEnterpriseOpenHandler handler = HyperlinkOpenHandlerRegistery.getInstance().getOpenHandler(uri);
            if (handler == null) {
                return new Status(4, "com.ibm.team.enterprise.common.ui", NLS.bind((String)Messages.EnterpriseHyperlinkHandler_NOTFOUND_OPENHANDLER, (Object)uri));
            }
            ITeamRepository repository = URIUtilities.findTeamRepository((URI)uri);
            if (repository == null) {
                return Status.CANCEL_STATUS;
            }
            IStatus status = FoundationUIUtils.validateRepository((ITeamRepository)repository, (boolean)false, (IProgressMonitor)progressmonitor);
            if (!status.isOK()) {
                return status;
            }
            IItemHandle handle = URIUtilities.getItemHandle((URI)uri);
            if (handle == null) {
                return new Status(4, "com.ibm.team.enterprise.common.ui", NLS.bind((String)Messages.EnterpriseHyperlinkHandler_NOTFOUND_ITEMHANDLE, (Object)uri));
            }
            IWorkbenchWindow workbenchWindow = null;
            if (context != null) {
                Object uiContext = context.findUIContext();
                if (uiContext instanceof IWorkbenchWindow) {
                    workbenchWindow = (IWorkbenchWindow)uiContext;
                } else if (uiContext instanceof Shell) {
                    workbenchWindow = EnterpriseHyperlinkHandler.getWorkbenchWindow((Shell)uiContext);
                }
            }
            if (workbenchWindow == null) {
                workbenchWindow = EnterpriseHyperlinkHandler.getWorkbenchWindow();
            }
            if (workbenchWindow == null) {
                return new Status(4, "com.ibm.team.enterprise.common.ui", Messages.EnterpriseHyperlinkHandler_NOTFOUND_WORKBENCHWINDOW);
            }
            handler.open(repository, handle, workbenchWindow.getActivePage(), progressmonitor);
            return Status.OK_STATUS;
        }
        catch (PermissionDeniedException e) {
            Activator.openErrorDialog(NLS.bind((String)Messages.EnterpriseHyperlinkHandler_ERROR_PERMISSION, (Object)uri));
            return Status.OK_STATUS;
        }
        catch (TeamRepositoryException e) {
            return new Status(4, "com.ibm.team.enterprise.common.ui", NLS.bind((String)Messages.EnterpriseHyperlinkHandler_ERROR_HYPERLINK, (Object)uri), (Throwable)e);
        }
    }

    private static IWorkbenchWindow getWorkbenchWindow() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null) {
            if (workbench.getWorkbenchWindowCount() > 0) {
                window = workbench.getWorkbenchWindows()[0];
            } else {
                return null;
            }
        }
        return window;
    }

    private static IWorkbenchWindow getWorkbenchWindow(Shell shell) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            if (windows[i].getShell().equals(shell)) {
                return windows[i];
            }
            ++i;
        }
        return null;
    }

    public boolean resolves(URI uri) {
        return this.handles(uri);
    }

    public Object resolve(URI uri, ContextProvider provider) throws TeamRepositoryException {
        return URIUtilities.resolveObject((URI)uri, null);
    }

    public Object resolve(URI uri, ContextProvider provider, IProgressMonitor monitor) throws CoreException {
        try {
            return URIUtilities.resolveObject((URI)uri, (IProgressMonitor)monitor);
        }
        catch (TeamRepositoryException e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.team.enterprise.common.ui", "", (Throwable)e));
        }
    }
}

