/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.common.ui;

import com.ibm.team.enterprise.common.ui.nls.Messages;
import com.ibm.team.foundation.common.util.FoundationLog;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIJob;
import com.ibm.team.jface.JazzResources;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.ibm.team.enterprise.common.ui";
    private static Activator plugin;
    private ResourceManager fResourceManager;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        try {
            if (this.fResourceManager != null) {
                this.fResourceManager.dispose();
                this.fResourceManager = null;
            }
            Job.getJobManager().cancel((Object)plugin);
        }
        finally {
            plugin = null;
            super.stop(context);
        }
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static String getUniqueIdentifier() {
        return PLUGIN_ID;
    }

    public static void log(Throwable exception) {
        String message = exception.getMessage();
        if (message == null) {
            message = "";
        }
        Activator.log((IStatus)new Status(4, Activator.getUniqueIdentifier(), 4, message, exception));
    }

    public static void log(String message) {
        if (message == null) {
            message = "";
        }
        Activator.log((IStatus)new Status(4, Activator.getUniqueIdentifier(), 4, message, null));
    }

    public static void log(IStatus status) {
        FoundationLog.log((IStatus)status);
    }

    public void log(String message, Throwable exception) {
        Activator.log((IStatus)new Status(4, PLUGIN_ID, 0, message, exception));
    }

    public static Image getImage(String path) {
        ImageRegistry imageRegistry = Activator.getDefault().getImageRegistry();
        Image image = imageRegistry.get(path);
        if (image == null) {
            ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)Activator.getUniqueIdentifier(), (String)path);
            imageRegistry.put(path, descriptor);
            image = imageRegistry.get(path);
        }
        return image;
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        ImageDescriptor infoImageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"/icons/obj16/info.gif");
        reg.put("IMG_INFO", infoImageDescriptor);
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        ImageRegistry imageRegistry = Activator.getDefault().getImageRegistry();
        ImageDescriptor descriptor = imageRegistry.getDescriptor(path);
        if (descriptor == null) {
            descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)Activator.getUniqueIdentifier(), (String)path);
            imageRegistry.put(path, descriptor);
        }
        return descriptor;
    }

    private ResourceManager getResourceManager() {
        if (this.fResourceManager == null) {
            this.fResourceManager = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.fResourceManager;
    }

    public static Image getImage(ImageDescriptor imageDesc) {
        return JazzResources.getImageWithDefault((ResourceManager)Activator.getDefault().getResourceManager(), (ImageDescriptor)imageDesc);
    }

    public static void openErrorDialog(final String msg) {
        if (Display.getCurrent() == null) {
            FoundationUIJob job = new FoundationUIJob(msg){

                public IStatus runProtectedInUI(IProgressMonitor monitor) {
                    Activator.openErrorDialogInUI(msg);
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        } else {
            Activator.openErrorDialogInUI(msg);
        }
    }

    private static void openErrorDialogInUI(String msg) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null && workbench.getWorkbenchWindowCount() > 0) {
            window = workbench.getWorkbenchWindows()[0];
        }
        MessageDialog.openInformation((Shell)(window != null ? window.getShell() : null), (String)Messages.ErrorDialogTitle, (String)msg);
    }
}

