/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.supa.server.internal.common.v1.dto;

import com.ibm.teamz.supa.server.common.v1.dto.IStatusReport;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StatusReport
implements IStatusReport {
    private final Map<String, ComponentStatusReport> componentReports;
    boolean inRecoveryStage;
    boolean inInitializationStage;
    boolean encounteredSevereError;
    private static final long serialVersionUID = 1104911712241803827L;

    public StatusReport(boolean inInitializationStage, boolean inRecoveryStage, boolean encounteredSevereError) {
        this.inRecoveryStage = inRecoveryStage;
        this.inInitializationStage = inInitializationStage;
        this.encounteredSevereError = encounteredSevereError;
        this.componentReports = new HashMap<String, ComponentStatusReport>();
    }

    @Override
    public void addComponentStatusReport(String componentId, ComponentStatusReport componentStatusReport) {
        this.componentReports.put(componentId, componentStatusReport);
    }

    @Override
    public Map<String, ComponentStatusReport> getComponentReports() {
        return this.componentReports;
    }

    @Override
    public boolean isInInitializationStage() {
        return this.inInitializationStage;
    }

    @Override
    public boolean isInRecoveryStage() {
        return this.inRecoveryStage;
    }

    @Override
    public boolean isEncounteredSevereError() {
        return this.encounteredSevereError;
    }

    public static class ComponentStatusReport
    implements Serializable {
        private static final long serialVersionUID = 8768576449105406872L;
        private final long amountOfDocuments;
        private final boolean configurationProcessIsIdle;
        private final long indexSize;
        private final boolean indexProcessIsIdle;
        private final boolean indexIsInBalance;
        private final boolean collectionExists;
        private final boolean hasPermissions;
        private final List<String> fileNames;
        private final List<String> fileItemIds;
        private final List<String> fileStateIds;
        private final String lastIndexTime;

        public ComponentStatusReport(boolean collectionExists, boolean hasPermissions) {
            this.amountOfDocuments = 0L;
            this.indexSize = 0L;
            this.configurationProcessIsIdle = false;
            this.indexProcessIsIdle = false;
            this.indexIsInBalance = false;
            this.collectionExists = collectionExists;
            this.hasPermissions = hasPermissions;
            this.fileNames = null;
            this.fileItemIds = null;
            this.fileStateIds = null;
            this.lastIndexTime = null;
        }

        public ComponentStatusReport(String lastIndexTime, long amountOfDocuments, boolean configurationProcessIsIdle, long indexSize, boolean indexProcessIsIdle, boolean indexIsInBalance, boolean collectionExists, boolean hasPermissions, List<String> fileNames, List<String> fileItemIds, List<String> fileStateIds) {
            this.lastIndexTime = lastIndexTime;
            this.amountOfDocuments = amountOfDocuments;
            this.configurationProcessIsIdle = configurationProcessIsIdle;
            this.indexSize = indexSize;
            this.indexProcessIsIdle = indexProcessIsIdle;
            this.indexIsInBalance = indexIsInBalance;
            this.collectionExists = collectionExists;
            this.hasPermissions = hasPermissions;
            this.fileNames = fileNames;
            this.fileItemIds = fileItemIds;
            this.fileStateIds = fileStateIds;
        }

        public long getAmountOfDocuments() {
            return this.amountOfDocuments;
        }

        public long getIndexSize() {
            return this.indexSize;
        }

        public boolean isIndexProcessIsIdle() {
            return this.indexProcessIsIdle;
        }

        public boolean isIndexIsInBalance() {
            return this.indexIsInBalance;
        }

        public boolean isCollectionExists() {
            return this.collectionExists;
        }

        public List<String> getFileNames() {
            return this.fileNames;
        }

        public List<String> getFileItemIds() {
            return this.fileItemIds;
        }

        public List<String> getFileStateIds() {
            return this.fileStateIds;
        }

        public boolean isConfigurationProcessIsIdle() {
            return this.configurationProcessIsIdle;
        }

        public boolean hasPermissions() {
            return this.hasPermissions;
        }

        public String getLastIndexTime() {
            return this.lastIndexTime;
        }
    }
}

