/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.supa.admin.common.model.diff;

import com.ibm.teamz.supa.admin.common.model.IComponentConfiguration;
import com.ibm.teamz.supa.admin.common.model.ISearchAdminItem;
import com.ibm.teamz.supa.admin.common.model.ISearchConfiguration;
import com.ibm.teamz.supa.admin.common.model.ISynonymConfiguration;
import com.ibm.teamz.supa.admin.common.model.diff.ISearchAdminItemDiff;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class SearchConfigurationDiff
implements ISearchAdminItemDiff {
    private boolean dataIsCleared;
    private boolean diff;
    private List<String> removedComponentIds;
    private List<ExtendedComponentId> removedComponentExtendedIds;
    private List<String> newComponentIds;
    private List<ExtendedComponentId> newComponentExtendedIds;
    private List<String> updatedComponentIds;
    private Map<String, IComponentConfiguration> oldConfigurationMap;
    private ISearchConfiguration oldSearchConfiguration;
    private ISearchConfiguration newSearchConfiguration;

    public SearchConfigurationDiff() {
        this.clearData();
    }

    private void clearData() {
        this.diff = false;
        this.removedComponentIds = new ArrayList<String>();
        this.removedComponentExtendedIds = new ArrayList<ExtendedComponentId>();
        this.newComponentIds = new ArrayList<String>();
        this.newComponentExtendedIds = new ArrayList<ExtendedComponentId>();
        this.updatedComponentIds = new ArrayList<String>();
        this.oldConfigurationMap = new HashMap<String, IComponentConfiguration>();
        this.dataIsCleared = true;
    }

    public void calculateDiff(ISearchAdminItem oldItem, ISearchAdminItem newItem) throws IllegalArgumentException {
        if (!this.dataIsCleared) {
            this.clearData();
        }
        this.dataIsCleared = false;
        if (oldItem == null) {
            if (!(newItem instanceof ISearchConfiguration)) {
                throw new IllegalArgumentException();
            }
            ISearchConfiguration newConfiguration = (ISearchConfiguration)newItem;
            for (Object curConfiguration : newConfiguration.getComponentConfigurations()) {
                this.diff = true;
                this.newComponentIds.add(((IComponentConfiguration)curConfiguration).getId());
                this.newComponentExtendedIds.add(new ExtendedComponentId(((IComponentConfiguration)curConfiguration).getId(), ((IComponentConfiguration)curConfiguration).getContextId(), ((IComponentConfiguration)curConfiguration).getItemId()));
            }
            return;
        }
        if (!(oldItem instanceof ISearchConfiguration) || !(newItem instanceof ISearchConfiguration)) {
            throw new IllegalArgumentException();
        }
        this.oldSearchConfiguration = (ISearchConfiguration)oldItem;
        this.newSearchConfiguration = (ISearchConfiguration)newItem;
        TreeSet<IComponentConfiguration> tempremovedComponents = new TreeSet<IComponentConfiguration>(new Comparator<IComponentConfiguration>(){

            @Override
            public int compare(IComponentConfiguration o1, IComponentConfiguration o2) {
                return o1.getId().compareTo(o2.getId());
            }
        });
        tempremovedComponents.addAll(this.oldSearchConfiguration.getComponentConfigurations());
        for (Object curConf : this.oldSearchConfiguration.getComponentConfigurations()) {
            String id = ((IComponentConfiguration)curConf).getId();
            this.oldConfigurationMap.put(id, (IComponentConfiguration)curConf);
        }
        TreeSet<IComponentConfiguration> tempNewComponents = new TreeSet<IComponentConfiguration>(new Comparator<IComponentConfiguration>(){

            @Override
            public int compare(IComponentConfiguration o1, IComponentConfiguration o2) {
                return o1.getId().compareTo(o2.getId());
            }
        });
        tempNewComponents.addAll(this.newSearchConfiguration.getComponentConfigurations());
        for (IComponentConfiguration curremoved : tempremovedComponents) {
            if (tempNewComponents.contains(curremoved)) continue;
            this.diff = true;
            this.removedComponentIds.add(curremoved.getId());
            this.removedComponentExtendedIds.add(new ExtendedComponentId(curremoved.getId(), curremoved.getContextId(), curremoved.getItemId()));
        }
        for (IComponentConfiguration curNew : tempNewComponents) {
            if (!tempremovedComponents.contains(curNew)) {
                this.diff = true;
                this.newComponentIds.add(curNew.getId());
                this.newComponentExtendedIds.add(new ExtendedComponentId(curNew.getId(), curNew.getContextId(), curNew.getItemId()));
                continue;
            }
            IComponentConfiguration compatibleOldConf = this.oldConfigurationMap.get(curNew.getId());
            if (!this.needToUpdate(compatibleOldConf, curNew)) continue;
            this.diff = true;
            this.updatedComponentIds.add(curNew.getId());
        }
    }

    private boolean needToUpdate(IComponentConfiguration oldConf, IComponentConfiguration newConf) {
        if (newConf.isSearchEnabled() != oldConf.isSearchEnabled()) {
            return true;
        }
        if (!newConf.getSynonymConfiguration().getSynonymSource().equals(oldConf.getSynonymConfiguration().getSynonymSource())) {
            return true;
        }
        if (!(!newConf.getSynonymConfiguration().getSynonymSource().equals(ISynonymConfiguration.SynonymSource.User_Defined.toString()) || newConf.getContextId().equals(oldConf.getContextId()) && newConf.getItemId().equals(oldConf.getItemId()) && newConf.getSynonymConfiguration().getVersion() == oldConf.getSynonymConfiguration().getVersion())) {
            return true;
        }
        return newConf.getSynonymConfiguration().getSynonymSource().equals(ISynonymConfiguration.SynonymSource.Search_Configuration.toString()) && (!this.newSearchConfiguration.getItemId().equals((Object)this.oldSearchConfiguration.getItemId()) || this.newSearchConfiguration.getSynonymConfiguration().getVersion() != this.oldSearchConfiguration.getSynonymConfiguration().getVersion());
    }

    public List<String> getRemovedComponentIds() {
        return this.removedComponentIds;
    }

    public List<String> getNewComponentIds() {
        return this.newComponentIds;
    }

    public List<String> getUpdatedComponentIds() {
        return this.updatedComponentIds;
    }

    public List<ExtendedComponentId> getRemovedComponentExtendedIds() {
        return this.removedComponentExtendedIds;
    }

    public List<ExtendedComponentId> getNewComponentExtendedIds() {
        return this.newComponentExtendedIds;
    }

    public boolean thereIsADiff() {
        return this.diff;
    }

    public static class ExtendedComponentId {
        private final String componentId;
        private final String componentContextId;
        private final String componentItemId;

        public ExtendedComponentId(String componentId, String componentContextId, String componentItemId) {
            this.componentId = componentId;
            this.componentContextId = componentContextId;
            this.componentItemId = componentItemId;
        }

        public String getComponentId() {
            return this.componentId;
        }

        public String getComponentContextId() {
            return this.componentContextId;
        }

        public String getComponentItemId() {
            return this.componentItemId;
        }
    }
}

