/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.supa.admin.common;

import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IContext;
import com.ibm.team.repository.common.UUID;
import com.ibm.teamz.supa.admin.common.IndexFileFilterUtils;
import com.ibm.teamz.supa.admin.common.model.IChangeSetRecord;
import com.ibm.teamz.supa.admin.common.model.IComponentConfiguration;
import com.ibm.teamz.supa.admin.common.model.IComponentIndexingTable;
import com.ibm.teamz.supa.admin.common.model.ICounter;
import com.ibm.teamz.supa.admin.common.model.IDistributionConfiguration;
import com.ibm.teamz.supa.admin.common.model.IFolderUUID;
import com.ibm.teamz.supa.admin.common.model.IIndexingConfiguration;
import com.ibm.teamz.supa.admin.common.model.IIndexingSchedule;
import com.ibm.teamz.supa.admin.common.model.IPerformanceProfile;
import com.ibm.teamz.supa.admin.common.model.ISJXDistributionConfiguration;
import com.ibm.teamz.supa.admin.common.model.ISearchAdminProperty;
import com.ibm.teamz.supa.admin.common.model.ISearchConfiguration;
import com.ibm.teamz.supa.admin.common.model.ISearchEngine;
import com.ibm.teamz.supa.admin.common.model.ISearchStatistics;
import com.ibm.teamz.supa.admin.common.model.ISynchronizationRecord;
import com.ibm.teamz.supa.admin.common.model.ISynonymConfiguration;
import com.ibm.teamz.supa.admin.common.model.ISynonymEntry;
import com.ibm.teamz.supa.admin.common.model.ISynonymSubEntry;
import com.ibm.teamz.supa.admin.common.model.diff.SearchConfigurationDiff;
import com.ibm.teamz.supa.admin.internal.common.model.AdminFactory;
import com.ibm.teamz.supa.admin.internal.common.model.AdminPackage;
import com.ibm.teamz.supa.admin.internal.common.model.ChangeSetRecord;
import com.ibm.teamz.supa.admin.internal.common.model.ComponentConfiguration;
import com.ibm.teamz.supa.admin.internal.common.model.ComponentIndexingTable;
import com.ibm.teamz.supa.admin.internal.common.model.Counter;
import com.ibm.teamz.supa.admin.internal.common.model.DistributionConfiguration;
import com.ibm.teamz.supa.admin.internal.common.model.FolderUUID;
import com.ibm.teamz.supa.admin.internal.common.model.IndexingConfiguration;
import com.ibm.teamz.supa.admin.internal.common.model.IndexingSchedule;
import com.ibm.teamz.supa.admin.internal.common.model.PerformanceProfile;
import com.ibm.teamz.supa.admin.internal.common.model.SJXDistributionConfiguration;
import com.ibm.teamz.supa.admin.internal.common.model.SearchConfiguration;
import com.ibm.teamz.supa.admin.internal.common.model.SearchEngine;
import com.ibm.teamz.supa.admin.internal.common.model.SearchStatistics;
import com.ibm.teamz.supa.admin.internal.common.model.SynchronizationRecord;
import com.ibm.teamz.supa.admin.internal.common.model.SynonymConfiguration;
import com.ibm.teamz.supa.admin.internal.common.model.SynonymEntry;

public class SearchAdminItemFactory {
    public static void initializeAdminPackage() {
        AdminPackage.eINSTANCE.eContents();
        new SearchAdminItemFactory();
    }

    public static ISearchConfiguration createSearchConfiguration() {
        IndexingSchedule indexingSchedule = AdminFactory.eINSTANCE.createIndexingSchedule();
        indexingSchedule.setIndexingInterval(1);
        indexingSchedule.setInexingOnSourceChange(false);
        SearchConfiguration searchConfiguration = (SearchConfiguration)SearchConfiguration.ITEM_TYPE.createItem();
        searchConfiguration.setIndexingSchedule(indexingSchedule);
        searchConfiguration.clearComponentConfigurations();
        SearchAdminItemFactory.initilizeNewConfigurationSynonyms(searchConfiguration);
        searchConfiguration.setComponentRunningId(1L);
        return searchConfiguration;
    }

    public static ISearchConfiguration createSearchConfiguration(IProjectArea projectArea) {
        IndexingSchedule indexingSchedule = AdminFactory.eINSTANCE.createIndexingSchedule();
        indexingSchedule.setIndexingInterval(1);
        indexingSchedule.setInexingOnSourceChange(false);
        SearchConfiguration searchConfiguration = (SearchConfiguration)SearchConfiguration.ITEM_TYPE.createItem();
        searchConfiguration.setProjectArea((IProjectAreaHandle)projectArea);
        searchConfiguration.setContextId(projectArea.getContextId());
        searchConfiguration.setIndexingSchedule(indexingSchedule);
        searchConfiguration.clearComponentConfigurations();
        SearchAdminItemFactory.initilizeNewConfigurationSynonyms(searchConfiguration);
        searchConfiguration.setComponentRunningId(1L);
        return searchConfiguration;
    }

    public static ISearchEngine createSearchEngine() {
        return (ISearchEngine)SearchEngine.ITEM_TYPE.createItem();
    }

    public static ISearchAdminProperty createSearchAdminProperty() {
        return AdminFactory.eINSTANCE.createSearchAdminProperty();
    }

    public static IIndexingSchedule createIndexingSchedule() {
        return AdminFactory.eINSTANCE.createIndexingSchedule();
    }

    public static ISynonymSubEntry createSynonymSubEntry() {
        return AdminFactory.eINSTANCE.createSynonymSubEntry();
    }

    public static ISynonymEntry createSynonymEntry() {
        SynonymEntry synEntry = AdminFactory.eINSTANCE.createSynonymEntry();
        synEntry.clearEntry();
        return synEntry;
    }

    public static IIndexingConfiguration createIndexingConfiguration() {
        IndexingConfiguration indexingConfiguration = AdminFactory.eINSTANCE.createIndexingConfiguration();
        indexingConfiguration.clearExcludeFolders();
        indexingConfiguration.clearExcludeFolders();
        indexingConfiguration.setIncludeFilePattern("*");
        indexingConfiguration.setExcludeFilePattern(IndexFileFilterUtils.EXCLUDED_PATTERNS_FOR_INDEX_CONFIGURATION);
        indexingConfiguration.setVersion(1L);
        return indexingConfiguration;
    }

    public static IComponentConfiguration createComponentConfiguration(String contextId, String itemId) {
        ComponentConfiguration componentConfiguration = AdminFactory.eINSTANCE.createComponentConfiguration();
        IIndexingConfiguration indexingConfiguration = SearchAdminItemFactory.createIndexingConfiguration();
        componentConfiguration.setIndexingConfiguration(indexingConfiguration);
        componentConfiguration.setContextId(contextId);
        componentConfiguration.setItemId(itemId);
        ISynonymConfiguration synonymConfiguration = SearchAdminItemFactory.createSynonymConfiguration();
        componentConfiguration.setSynonymConfiguration(synonymConfiguration);
        componentConfiguration.setSearchEnabled(true);
        return componentConfiguration;
    }

    public static ISearchStatistics createSearchStatistics(String statisticsId) {
        ISearchStatistics searchStatistics = (ISearchStatistics)SearchStatistics.ITEM_TYPE.createItem();
        searchStatistics.setId(statisticsId);
        searchStatistics.setContextId(IContext.PUBLIC);
        searchStatistics.getPerformanceProfiles().clear();
        searchStatistics.getQueryStatisticsHourBased().clear();
        searchStatistics.getQueryStatisticsDayBased().clear();
        return searchStatistics;
    }

    public static ISearchStatistics createSearchStatistics(SearchConfigurationDiff.ExtendedComponentId componentExtendedId, ISearchConfiguration searchConfiguration) {
        ISearchStatistics searchStatistics = (ISearchStatistics)SearchStatistics.ITEM_TYPE.createItem();
        searchStatistics.setId(componentExtendedId.getComponentId());
        searchStatistics.setContextId(searchConfiguration.getContextId());
        searchStatistics.getPerformanceProfiles().clear();
        searchStatistics.getQueryStatisticsHourBased().clear();
        searchStatistics.getQueryStatisticsDayBased().clear();
        return searchStatistics;
    }

    public static IComponentIndexingTable createComponentIndexingTable(SearchConfigurationDiff.ExtendedComponentId componentExtendedId, ISearchConfiguration searchConfiguration) {
        IComponentIndexingTable indexingTable = (IComponentIndexingTable)ComponentIndexingTable.ITEM_TYPE.createItem();
        indexingTable.setId(componentExtendedId.getComponentId());
        indexingTable.setComponentConfigurationContextId(componentExtendedId.getComponentContextId());
        indexingTable.setComponentConfigurationItemId(componentExtendedId.getComponentItemId());
        indexingTable.setContextId(searchConfiguration.getContextId());
        indexingTable.getChangeSetRecords().clear();
        indexingTable.setAmountOfChangeSetRecords(0);
        indexingTable.setLastBaseExecutionTime(0L);
        indexingTable.setCurrentBaseLineId("NULL_BL");
        indexingTable.setInitialized(false);
        ISynchronizationRecord base = SearchAdminItemFactory.createSynchronizationRecord();
        base.setChangeSetId("NULL_CS");
        base.setVersion(1L);
        IIndexingConfiguration indexingConfiguration = SearchAdminItemFactory.createIndexingConfiguration();
        base.setIndexingConfiguration(indexingConfiguration);
        base.setDistributionConfiguration(SearchAdminItemFactory.createDistributionConfiguration());
        base.setSynchronizationCause(ISynchronizationRecord.SynchronizationCause.CONFIGURATION_CHANGES.toString());
        base.setInitialized(false);
        indexingTable.setBase(base);
        IChangeSetRecord changeSetRecord = SearchAdminItemFactory.createChangeSetRecord();
        changeSetRecord.setChangeSetId("NULL_CS");
        changeSetRecord.setPrevChangeSetId("NULL_CS");
        changeSetRecord.setDistributionConfiguration(SearchAdminItemFactory.createDistributionConfiguration());
        changeSetRecord.setInitialized(false);
        indexingTable.setRecentChangeSetRecord(changeSetRecord);
        indexingTable.setRecentCSId("NULL_CS");
        return indexingTable;
    }

    public static ISJXDistributionConfiguration createSJXDistributionConfiguration() {
        SJXDistributionConfiguration sJXDistributionConfiguration = AdminFactory.eINSTANCE.createSJXDistributionConfiguration();
        return sJXDistributionConfiguration;
    }

    public static ICounter createCounter(long value) {
        Counter counter = AdminFactory.eINSTANCE.createCounter();
        counter.setValue(value);
        return counter;
    }

    public static IPerformanceProfile createPerformanceProfile() {
        PerformanceProfile performanceProfile = AdminFactory.eINSTANCE.createPerformanceProfile();
        return performanceProfile;
    }

    public static IDistributionConfiguration createDistributionConfiguration() {
        DistributionConfiguration distributionConfiguration = AdminFactory.eINSTANCE.createDistributionConfiguration();
        distributionConfiguration.getSjxConfigurations().clear();
        return distributionConfiguration;
    }

    public static ISynchronizationRecord createSynchronizationRecord() {
        SynchronizationRecord synchronizationRecord = AdminFactory.eINSTANCE.createSynchronizationRecord();
        return synchronizationRecord;
    }

    public static IChangeSetRecord createChangeSetRecord() {
        ChangeSetRecord changeSetRecord = AdminFactory.eINSTANCE.createChangeSetRecord();
        return changeSetRecord;
    }

    public static IChangeSetRecord createRawChangeSetRecord() {
        ChangeSetRecord changeSetRecord = AdminFactory.eINSTANCE.createChangeSetRecord();
        changeSetRecord.setChangeSetId("NULL_CS");
        changeSetRecord.setPrevChangeSetId("NULL_CS");
        changeSetRecord.setDistributionConfiguration(SearchAdminItemFactory.createDistributionConfiguration());
        return changeSetRecord;
    }

    public static IFolderUUID createFolderUUID(UUID id) {
        FolderUUID folderUUID = AdminFactory.eINSTANCE.createFolderUUID();
        folderUUID.setFolderId(id.getUuidValue());
        return folderUUID;
    }

    public static IFolderUUID createFolderUUID(String id) {
        FolderUUID folderUUID = AdminFactory.eINSTANCE.createFolderUUID();
        folderUUID.setFolderId(id);
        return folderUUID;
    }

    public static ISynonymConfiguration createSynonymConfiguration() {
        SynonymConfiguration synonymConfiguration = AdminFactory.eINSTANCE.createSynonymConfiguration();
        synonymConfiguration.clearSynonymEntries();
        synonymConfiguration.setSynonymSource(ISynonymConfiguration.SynonymSource.Search_Configuration.toString());
        synonymConfiguration.setVersion(1L);
        return synonymConfiguration;
    }

    private static void initilizeNewConfigurationSynonyms(ISearchConfiguration configuration) {
    }
}

