/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.supa.admin.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class IndexFileFilterUtils {
    public static final String[] EXCLUDED_PATTERNS = new String[]{".*", "/*.gif", "/*.jpg", "/*.jpeg", "/*.bmp", "/*.mov", "/*.mpg", "/*.mpeg", "/*.avi", "/*.xls", "/*.doc", "/*.ppt", "/*.xslx", "/*.docx", "/*.pptx", "/*.rar", "/*.gz", "/*.zip", "/*.jar", "/*.tar", "/*.pdf", "/*.msi", "/*.exe", "/*.com", "/*.class", "/*.war", "/*.ear", "/*.psd", "/*.tiff", "/*.svg"};
    public static final String EXCLUDED_PATTERNS_FOR_INDEX_CONFIGURATION;
    public static final String AUTOMATICALLY_EXCLUDED_PATTERNS_SEPARATOR = "<automaticlly_excluded>";

    static {
        StringBuilder sb = new StringBuilder();
        sb.append(System.getProperty("line.separator")).append(AUTOMATICALLY_EXCLUDED_PATTERNS_SEPARATOR).append(System.getProperty("line.separator"));
        String[] stringArray = EXCLUDED_PATTERNS;
        int n = EXCLUDED_PATTERNS.length;
        int n2 = 0;
        while (n2 < n) {
            String curPattern = stringArray[n2];
            sb.append(curPattern).append(System.getProperty("line.separator"));
            ++n2;
        }
        EXCLUDED_PATTERNS_FOR_INDEX_CONFIGURATION = sb.toString();
    }

    public static List<Pattern> convertToJavaRegex(String patterns) throws IOException {
        patterns = IndexFileFilterUtils.minimizedPatterns(patterns);
        ArrayList<Pattern> patternsAsList = new ArrayList<Pattern>();
        patterns = patterns.trim();
        BufferedReader br = new BufferedReader(new StringReader(patterns));
        String curPattern = null;
        while ((curPattern = br.readLine()) != null) {
            String pattern = curPattern.trim();
            if (pattern == null || pattern.trim().length() == 0) continue;
            patternsAsList.add(Pattern.compile(IndexFileFilterUtils.convertSinglePatternToJavaRegex(pattern)));
        }
        try {
            br.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return patternsAsList;
    }

    private static String convertSinglePatternToJavaRegex(String pattern) {
        StringBuilder result = new StringBuilder();
        int startScanPos = 0;
        if (pattern.startsWith("/")) {
            startScanPos = 1;
            result.append("(?i)");
        }
        int i = startScanPos;
        while (i < pattern.length()) {
            char c = pattern.charAt(i);
            if (c == '*') {
                result.append(".*");
            } else if (c == '?') {
                result.append(".");
            } else {
                result.append("\\Q");
                result.append(c);
                result.append("\\E");
            }
            ++i;
        }
        return result.toString();
    }

    public static String minimizedPatterns(String patterns) {
        patterns = patterns.replaceAll("[*]{2,}", "*");
        patterns = patterns.replaceAll("[?]*[*][?]*", "*");
        return patterns;
    }

    public static String getUserExcludedPart(String patterns) {
        int separator = patterns.lastIndexOf(AUTOMATICALLY_EXCLUDED_PATTERNS_SEPARATOR);
        if (separator < 0) {
            return patterns;
        }
        return patterns.substring(0, separator);
    }

    public static String getAutomaticallyExcludedPart(String patterns) {
        int separator = patterns.lastIndexOf(AUTOMATICALLY_EXCLUDED_PATTERNS_SEPARATOR);
        if (separator < 0) {
            return patterns;
        }
        return patterns.substring(separator + AUTOMATICALLY_EXCLUDED_PATTERNS_SEPARATOR.length());
    }

    public static String joinUserAndAutomaticallyPart(String userPatterns, String autoExcludedPatterns) {
        StringBuilder sb = new StringBuilder();
        sb.append(userPatterns).append(System.getProperty("line.separator")).append(AUTOMATICALLY_EXCLUDED_PATTERNS_SEPARATOR).append(autoExcludedPatterns);
        return sb.toString();
    }

    public static String removeAutoExcludedPatternsSeparator(String patterns) {
        int separator = patterns.lastIndexOf(AUTOMATICALLY_EXCLUDED_PATTERNS_SEPARATOR);
        if (separator < 0) {
            return patterns;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(patterns.substring(0, separator)).append(patterns.substring(separator + AUTOMATICALLY_EXCLUDED_PATTERNS_SEPARATOR.length()));
        return sb.toString();
    }
}

