/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.common.common.process;

import com.ibm.team.enterprise.common.common.nls.Messages;
import com.ibm.team.enterprise.common.common.process.IStateContainerElement;
import com.ibm.team.enterprise.internal.common.common.process.AbstractModeledElement;
import com.ibm.team.enterprise.internal.common.common.process.CategoryElement;
import com.ibm.team.enterprise.internal.common.common.process.StateElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TypeElement
extends AbstractModeledElement
implements IStateContainerElement {
    private String id;
    private String name;
    private String icon;
    private String dimmedIcon;
    private List<String> aliases;
    private List<StateElement> states;
    private CategoryElement category;

    public TypeElement(CategoryElement category, String id, String name, String icon, String dimmedIcon, List<String> aliases) {
        this.category = category;
        this.id = id;
        this.name = name;
        this.icon = icon;
        this.dimmedIcon = dimmedIcon;
        this.aliases = new ArrayList<String>();
        this.aliases.addAll(aliases);
        this.states = new ArrayList<StateElement>();
    }

    @Override
    public void addState(StateElement state) {
        if (!this.category.getStates().contains(state) && !this.states.contains(state)) {
            this.states.add(state);
        }
    }

    @Override
    public List<StateElement> getStates() {
        return this.states;
    }

    @Override
    public List<StateElement> getInheritedStates() {
        return this.getCategory().getStates();
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setDimmedIcon(String dimmedIcon) {
        this.dimmedIcon = dimmedIcon;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getDimmedIcon() {
        return this.dimmedIcon;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public void setAliases(List<String> aliases) {
        this.aliases = aliases;
    }

    public void addAlias(String alias) {
        this.aliases.add(alias);
    }

    public void removeAlias(String alias) {
        this.aliases.remove(alias);
    }

    @Override
    public String getIdentifier() {
        return this.getId();
    }

    public CategoryElement getCategory() {
        return this.category;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getStatesAsString() {
        if (this.states.size() == 0 && this.category.getStates().size() == 0) {
            return Messages.AdvisorConfig_NONE;
        }
        StringBuffer buffer = new StringBuffer();
        Iterator<StateElement> iterator = this.states.iterator();
        while (iterator.hasNext()) {
            StateElement next = iterator.next();
            buffer.append(next.getName());
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    public TypeElement duplicate(CategoryElement parent) {
        return new TypeElement(parent, this.id, this.name, this.icon, this.dimmedIcon, this.aliases);
    }

    @Override
    public boolean hasStates() {
        return this.states.size() > 0;
    }

    @Override
    public void clearStates() {
        this.states.clear();
    }

    public int hashCode() {
        StringBuilder builder = new StringBuilder(this.category.getIdentifier());
        builder.append(':').append(this.getId());
        return builder.toString().hashCode();
    }
}

