/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.common.common.process;

import com.ibm.team.enterprise.common.common.nls.Messages;
import com.ibm.team.enterprise.common.common.process.IStateContainerElement;
import com.ibm.team.enterprise.internal.common.common.process.AbstractModeledElement;
import com.ibm.team.enterprise.internal.common.common.process.StateElement;
import com.ibm.team.enterprise.internal.common.common.process.TypeElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class CategoryElement
extends AbstractModeledElement
implements IStateContainerElement {
    private final String categoryId;
    private final List<TypeElement> types;
    private final List<StateElement> states;
    private final List<StateElement> availableStates;

    public CategoryElement(String categoryId) {
        this.categoryId = categoryId;
        this.types = new ArrayList<TypeElement>();
        this.states = new ArrayList<StateElement>();
        this.availableStates = new ArrayList<StateElement>();
    }

    public void addType(TypeElement type) {
        this.types.add(type);
    }

    @Override
    public void addState(StateElement state) {
        if (!this.states.contains(state)) {
            this.states.add(state);
        }
    }

    public void addAllAvailableStates(List<StateElement> states) {
        this.availableStates.addAll(states);
    }

    public void addAvailableState(StateElement state) {
        this.availableStates.add(state);
    }

    public List<StateElement> getAvailableStates() {
        return this.availableStates;
    }

    public StateElement getAvailableState(String stateId) {
        for (StateElement state : this.availableStates) {
            if (!state.getIdentifier().equals(stateId)) continue;
            return state;
        }
        return null;
    }

    public void removeType(TypeElement type) {
        this.types.remove(type);
    }

    public List<TypeElement> getTypes() {
        return this.types;
    }

    public TypeElement getType(String typeId) {
        for (TypeElement type : this.types) {
            if (!type.getIdentifier().equals(typeId)) continue;
            return type;
        }
        return null;
    }

    @Override
    public String getIdentifier() {
        return this.categoryId;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public List<StateElement> getStates() {
        return this.states;
    }

    @Override
    public String getStatesAsString() {
        if (this.states.size() == 0) {
            return Messages.AdvisorConfig_NONE;
        }
        StringBuffer buffer = new StringBuffer();
        Iterator<StateElement> iterator = this.states.iterator();
        while (iterator.hasNext()) {
            StateElement next = iterator.next();
            buffer.append(next.getName());
            if (!iterator.hasNext()) continue;
            buffer.append(',');
        }
        return buffer.toString();
    }

    public CategoryElement duplicate() {
        CategoryElement duplicatedCategory = new CategoryElement(this.categoryId);
        duplicatedCategory.addAllAvailableStates(this.availableStates);
        for (TypeElement type : this.types) {
            duplicatedCategory.addType(type.duplicate(duplicatedCategory));
        }
        return duplicatedCategory;
    }

    @Override
    public boolean hasStates() {
        if (this.states.size() > 0) {
            return true;
        }
        for (TypeElement type : this.types) {
            if (!type.hasStates()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<StateElement> getInheritedStates() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public void clearStates() {
        this.states.clear();
    }
}

