/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.common.common.process;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.enterprise.common.common.nls.Messages;
import com.ibm.team.enterprise.internal.common.common.process.AbstractModeledElement;
import com.ibm.team.enterprise.internal.common.common.process.CategoryElement;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.List;

public class BuildDefinitionElement
extends AbstractModeledElement {
    private UUID uuid;
    private String name;
    private boolean dirty;
    private final boolean isDefault;
    private List<CategoryElement> categories;
    private String workItemComment;
    private String workItemTags;
    private boolean runTargetBuild;
    private boolean checkBuildMapForSourceOnly = false;
    private boolean checkIgnoreBuildMapValidaiton = false;
    private boolean useSubset;
    private boolean includeImpacts = false;

    public boolean isCheckIgnoreBuildMapValidaiton() {
        return this.checkIgnoreBuildMapValidaiton;
    }

    public void setCheckIgnoreBuildMapValidaiton(boolean checkIgnoreBuildMapValidaiton) {
        this.checkIgnoreBuildMapValidaiton = checkIgnoreBuildMapValidaiton;
    }

    public boolean isCheckBuildMapForSourceOnly() {
        return this.checkBuildMapForSourceOnly;
    }

    public void setCheckBuildMapForSourceOnly(boolean checkBuildMapForSourceOnly) {
        this.checkBuildMapForSourceOnly = checkBuildMapForSourceOnly;
    }

    public BuildDefinitionElement(IBuildDefinition buildDefinition) {
        boolean bl = this.isDefault = buildDefinition == null;
        if (this.isDefault) {
            this.name = Messages.AdvisorConfig_DEFAULT;
        } else {
            this.uuid = buildDefinition.getItemId();
            this.name = buildDefinition.getId();
        }
        this.workItemComment = "";
        this.workItemTags = "";
        this.dirty = false;
    }

    public BuildDefinitionElement(IBuildDefinition buildDefinition, List<CategoryElement> categories) {
        boolean bl = this.isDefault = buildDefinition == null;
        if (this.isDefault) {
            this.name = Messages.AdvisorConfig_DEFAULT;
        } else {
            this.uuid = buildDefinition.getItemId();
            this.name = buildDefinition.getId();
        }
        this.categories = new ArrayList<CategoryElement>(categories.size());
        for (CategoryElement category : categories) {
            this.categories.add(category.duplicate());
        }
        this.dirty = false;
    }

    public BuildDefinitionElement(UUID uuid, String name, List<CategoryElement> categories) {
        boolean bl = this.isDefault = uuid == null;
        if (this.isDefault) {
            name = Messages.AdvisorConfig_DEFAULT;
        } else {
            this.uuid = uuid;
            this.name = name;
        }
        this.categories = new ArrayList<CategoryElement>(categories.size());
        for (CategoryElement category : categories) {
            this.categories.add(category.duplicate());
        }
        this.dirty = false;
    }

    public void addCategory(CategoryElement category) {
        this.categories.add(category);
    }

    public void addCategories(List<CategoryElement> categories) {
        this.categories.addAll(categories);
    }

    public List<CategoryElement> getCategories() {
        return this.categories;
    }

    public CategoryElement getCategory(String categoryId) {
        for (CategoryElement category : this.categories) {
            if (!category.getIdentifier().equals(categoryId)) continue;
            return category;
        }
        return null;
    }

    @Override
    public String getIdentifier() {
        if (this.uuid != null) {
            return this.uuid.getUuidValue();
        }
        return "";
    }

    @Override
    public String getName() {
        return this.name;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public String toString() {
        String indent = "  ";
        StringBuffer buffer = new StringBuffer("Build: ").append(this.name).append('\n');
        for (CategoryElement category : this.categories) {
            buffer.append(indent).append(category.getName()).append(": ").append(category.getStatesAsString()).append('\n');
        }
        return buffer.toString();
    }

    public void setDirty() {
        this.dirty = true;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public String getWorkItemComment() {
        return this.workItemComment;
    }

    public void setWorkItemComment(String workItemComment) {
        this.workItemComment = workItemComment;
    }

    public String getWorkItemTags() {
        return this.workItemTags;
    }

    public void setWorkItemTags(String tags) {
        this.workItemTags = tags;
    }

    public boolean isRunTargetBuild() {
        return this.runTargetBuild;
    }

    public void setRunTargetBuild(boolean runTargetBuild) {
        this.runTargetBuild = runTargetBuild;
    }

    public boolean isUseSubset() {
        return this.useSubset;
    }

    public void setUseSubset(boolean useSubset) {
        this.useSubset = useSubset;
    }

    public boolean isIncludeImpacts() {
        return this.includeImpacts;
    }

    public void setIncludeImpacts(boolean includeImpacts) {
        this.includeImpacts = includeImpacts && this.useSubset;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BuildDefinitionElement)) {
            return false;
        }
        return ((BuildDefinitionElement)o).getUUID().equals((Object)this.uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }
}

