/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.common.common;

import com.ibm.team.enterprise.common.common.nls.Messages;
import com.ibm.team.repository.common.util.Base64;
import com.ibm.team.repository.common.util.ObfuscationHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class PasswordHelper {
    private static final String DES3EncType = "DESede";
    private static final String PasswordTag = "password";
    private static final String VersionTag = "version";
    private static final String DefaultVersion = "0";
    private static final String CurrentVersion = "1";
    private static final byte[] tripleDESKey = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 8, 7, 6, 5, 4, 3, 2, 1, 1, 2, 3, 4, 4, 3, 2, 1};

    /*
     * Unable to fully structure code
     */
    public static String getPassword(File passwordFile) throws GeneralSecurityException, IOException {
        block18: {
            if (!passwordFile.exists()) {
                throw new FileNotFoundException(Messages.PasswordHelper_FILE_MISSING);
            }
            if (passwordFile.isDirectory()) {
                throw new FileNotFoundException(Messages.PasswordHelper_FILE_IS_DIRECTORY);
            }
            password = null;
            inputStream = new FileInputStream(passwordFile);
            try {
                try {
                    properties = new Properties();
                    properties.loadFromXML(inputStream);
                    password = properties.getProperty("password");
                    if (password == null) {
                        throw new IOException(Messages.PasswordHelper_INVALID_FORMAT);
                    }
                    version = properties.getProperty("version", "0");
                    password = version.equals("1") ? PasswordHelper.decryptString(password, PasswordHelper.tripleDESKey) : ObfuscationHelper.decryptString((String)password);
                    break block18;
                }
                catch (InvalidPropertiesFormatException ipfe) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException version) {
                        // empty catch block
                    }
                    inputStream = new FileInputStream(passwordFile);
                    fileContent = new StringBuffer();
                    buffer = new byte[256];
                    bytesRead = inputStream.read(buffer);
                    ** while (bytesRead != -1)
                }
lbl-1000:
                // 1 sources

                {
                    fileContent.append(new String(buffer, 0, bytesRead));
                    bytesRead = inputStream.read(buffer);
                    continue;
                }
lbl32:
                // 1 sources

                content = fileContent.toString();
                if (content.length() == 0) {
                    throw new IOException(Messages.PasswordHelper_FILE_EMPTY);
                }
                password = new String(ObfuscationHelper.decrypt((byte[])content.getBytes()));
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException var9_13) {}
            }
        }
        return password;
    }

    public static void createPasswordFile(File passwordFile, String password) throws IOException, GeneralSecurityException {
        try (FileOutputStream outputStream = null;){
            outputStream = new FileOutputStream(passwordFile);
            Properties properties = new Properties();
            properties.put(PasswordTag, PasswordHelper.encryptString(password, tripleDESKey));
            properties.put(VersionTag, CurrentVersion);
            properties.storeToXML((OutputStream)outputStream, "6.0", "UTF-8");
        }
    }

    private static String encryptString(String clearText, byte[] key) throws UnsupportedEncodingException, GeneralSecurityException {
        if (clearText == null) {
            throw new IllegalArgumentException("Parameter \"clearText\" must not be null.");
        }
        if (key == null) {
            throw new IllegalArgumentException("Parameter \"key\" must not be null.");
        }
        SecretKeySpec keySpec = new SecretKeySpec(key, DES3EncType);
        Cipher cp = Cipher.getInstance(DES3EncType);
        cp.init(1, keySpec);
        byte[] cipherText = cp.doFinal(clearText.getBytes("UTF-8"));
        return new String(Base64.encode((byte[])cipherText), "UTF-8");
    }

    private static String decryptString(String cipherText, byte[] key) throws UnsupportedEncodingException, GeneralSecurityException {
        if (cipherText == null) {
            throw new IllegalArgumentException("Parameter \"cipherText\" must not be null.");
        }
        if (key == null) {
            throw new IllegalArgumentException("Parameter \"key\" must not be null.");
        }
        SecretKeySpec keySpec = new SecretKeySpec(key, DES3EncType);
        Cipher cp = Cipher.getInstance(DES3EncType);
        cp.init(2, keySpec);
        byte[] clearText = cp.doFinal(Base64.decode((byte[])cipherText.getBytes("UTF-8")));
        return new String(clearText, "UTF-8");
    }
}

