/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.common.common.utils;

import com.ibm.team.enterprise.common.common.ISymbolsMap;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;

public class SymbolsMap<K, V>
extends HashMap<K, V>
implements ISymbolsMap<K, V> {
    private static final long serialVersionUID = 4592537231383335383L;
    private static final String SymbolRegex = "(?<!&)&([a-zA-Z0-9@$#]{1,16})(?:\\.)?";
    private static final Pattern SymbolPattern = Pattern.compile("(?<!&)&([a-zA-Z0-9@$#]{1,16})(?:\\.)?");

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        super.putAll(map);
        this.resolve();
    }

    @Override
    public void resolve() {
        for (Map.Entry key : this.entrySet()) {
            this.put(key.getKey(), this.resolveValue((String)key.getValue()));
        }
    }

    @Override
    public String resolveValue(String s) {
        Assert.isNotNull((Object)s);
        Matcher matcher = SymbolPattern.matcher(s);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String keyword = matcher.group(1);
            if (!this.containsKey(keyword)) continue;
            matcher.appendReplacement(result, (String)this.get(keyword));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    @Override
    public String substitute(String s) {
        Assert.isNotNull((Object)s);
        String result = s;
        if (!this.isEmpty()) {
            Matcher m = SymbolPattern.matcher(s);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                String key = m.group(1);
                if (!this.containsKey(key)) continue;
                m.appendReplacement(sb, this.getString(key));
            }
            result = m.appendTail(sb).toString();
        }
        return result;
    }

    private String getString(String key) {
        String s = (String)this.get(key);
        return s == null ? "" : s;
    }
}

