/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.common.common.utils;

import java.util.Set;
import java.util.stream.Collectors;

public class StringNormalizer {
    static final String VARIANT_NATIONAL_CHARSET = "\u00a7\u00d8\u00c6\u00c5\u00d6\u00c4\u00d1\u00e0\u00d0\u00a5\u00a3";
    static final String NORMALIZED_CHARSET = "@@#$@##@@$$";
    static final String NORMALIZED_CHARSET_FR_IT = "@@#$@##@@$#";
    static final String DQUOTE = "\"";
    static final String POUND_STERLING = "\u00a3";
    static final String QUOTABLE_CHARSET = "[]{}\\^~!#|`$@";
    static final int[] quotableCodepoints = new int[]{186, 187, 192, 208, 224, 176, 161, 123, 79, 121, 91, 124};

    public static String getNormalizedString(String input, String cp, boolean throwIfIndeterminate) {
        String result = input;
        if (input == null) {
            return null;
        }
        if (input.startsWith(DQUOTE)) {
            result = StringNormalizer.substituteNormalizedCharsForQuotedName(input, cp, throwIfIndeterminate);
        } else if (StringNormalizer.containsAnyMatchingChar(input, VARIANT_NATIONAL_CHARSET)) {
            String normalizedCharSet = StringNormalizer.selectCharSet(input, cp, throwIfIndeterminate);
            result = StringNormalizer.substituteNormalizedChars(input, normalizedCharSet);
        }
        return result;
    }

    public static String getBestGuessNormalizedString(String input) {
        return StringNormalizer.getNormalizedString(input, null, true);
    }

    private static String selectCharSet(String input, String cp, boolean throwIfIndeterminate) {
        if (throwIfIndeterminate && input.contains(POUND_STERLING)) {
            throw new IllegalArgumentException();
        }
        if (cp != null && !cp.isEmpty() && StringNormalizer.cpIsFrenchOrItalian(cp.trim().toUpperCase())) {
            return NORMALIZED_CHARSET_FR_IT;
        }
        return NORMALIZED_CHARSET;
    }

    private static boolean cpIsFrenchOrItalian(String cp) {
        return cp.equals("IBM-297") || cp.equals("IBM-1147") || cp.equals("IBM-280") || cp.equals("IBM-1144");
    }

    private static String substituteNormalizedChars(String input, String normalizedCharSet) {
        String result = input;
        int i = 0;
        while (i < VARIANT_NATIONAL_CHARSET.length()) {
            result = result.replace(VARIANT_NATIONAL_CHARSET.charAt(i), normalizedCharSet.charAt(i));
            ++i;
        }
        return result;
    }

    private static String substituteNormalizedCharsForQuotedName(String input, String cp, boolean throwIfIndeterminate) {
        String result = input;
        if (StringNormalizer.containsAnyMatchingChar(input, VARIANT_NATIONAL_CHARSET)) {
            String normalizedCharSet = StringNormalizer.selectCharSet(input, cp, throwIfIndeterminate);
            result = StringNormalizer.substituteNormalizedChars(input, normalizedCharSet);
        }
        return result;
    }

    private static boolean containsAnyMatchingChar(String input, String charsToMatch) {
        Set charsToTestFor = charsToMatch.chars().mapToObj(ch -> Character.valueOf((char)ch)).collect(Collectors.toSet());
        boolean found = input.chars().anyMatch(ch -> charsToTestFor.contains(Character.valueOf((char)ch)));
        return found;
    }
}

