/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.common.common.utils;

import com.ibm.team.build.extensions.common.debug.IDebugLogger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class LoadTracing {
    private PrintWriter writer = null;
    private boolean appendToLog = false;
    private String logFile = "";
    private IDebugLogger logger;
    private final List<IDebugger> debuggers = new ArrayList<IDebugger>();

    public void printToLog(String msg) {
        if (this.writer != null) {
            this.writer.println(this.formatMsg(msg));
            this.writer.flush();
        }
    }

    private String formatMsg(String msg) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timestamp = dateFormat.format(new Date(System.currentTimeMillis()));
        return String.valueOf(timestamp) + ": " + msg;
    }

    public void close() {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
            this.logger = null;
            for (IDebugger debugger : this.debuggers) {
                debugger.setLogger(null);
            }
            this.debuggers.clear();
        }
    }

    public PrintWriter getWriter() {
        return this.writer;
    }

    public void setWriter() {
        BufferedWriter bw = null;
        try {
            if (this.appendToLog) {
                bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.logFile, true), "UTF-8"));
            } else {
                bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.logFile), "UTF-8"));
                this.appendToLog = true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.writer = new PrintWriter(bw);
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public void addDebugger(IDebugger debugger) {
        debugger.setLogger(this.logger);
        this.debuggers.add(debugger);
    }

    public void setLogger(IDebugLogger logger) {
        this.logger = logger;
    }
}

