/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.common.common.utils;

import com.ibm.team.process.internal.common.ItemHandleAwareHashSet;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EPackage;

public class ItemUtilities {
    public static final String DEFAULT_ENCODING = "UTF-8";

    public static URI createItemURI(IItem item, String repositoryURI) {
        try {
            if (item.hasStateId()) {
                return Location.stateLocation((IItemHandle)item, (String)repositoryURI).toAbsoluteUri();
            }
            return Location.itemLocation((IItemHandle)item, (String)repositoryURI).toAbsoluteUri();
        }
        catch (IllegalStateException e) {
            throw new RuntimeException(e);
        }
    }

    public static URI createItemURI(IItemHandle itemHandle, String repositoryURI) {
        try {
            if (itemHandle.hasStateId()) {
                return Location.stateLocation((IItemHandle)itemHandle, (String)repositoryURI).toAbsoluteUri();
            }
            return Location.itemLocation((IItemHandle)itemHandle, (String)repositoryURI).toAbsoluteUri();
        }
        catch (IllegalStateException e) {
            throw new RuntimeException(e);
        }
    }

    public static IItemType findItemType(URI uri) {
        String namespace = ItemUtilities.findItemTypeNamespaceURI(uri);
        if (namespace == null) {
            return ItemUtilities.findItemType2(uri);
        }
        String name = ItemUtilities.findItemTypeName(uri);
        if (name == null) {
            return ItemUtilities.findItemType2(uri);
        }
        return IItemType.IRegistry.INSTANCE.getItemType(name, namespace);
    }

    private static IItemType findItemType2(URI uri) {
        Location location = ItemUtilities.createLocation(uri);
        return location != null ? location.getItemType() : null;
    }

    private static String findItemTypeName(URI uri) {
        String query = uri.getQuery();
        if (query == null) {
            return null;
        }
        String qualifiedType = ItemUtilities.getValue(query, "type");
        if (qualifiedType == null) {
            return null;
        }
        int i = qualifiedType.lastIndexOf(".");
        if (i == -1) {
            return null;
        }
        return qualifiedType.substring(i + 1);
    }

    private static String findItemTypeNamespaceURI(URI uri) {
        String query = uri.getQuery();
        if (query == null) {
            return null;
        }
        String qualifiedType = ItemUtilities.getValue(query, "type");
        if (qualifiedType == null) {
            return null;
        }
        int i = qualifiedType.lastIndexOf(".");
        if (i == -1) {
            return null;
        }
        String nsPrefix = qualifiedType.substring(0, i);
        String nsURI = null;
        EPackage.Registry registry = EPackage.Registry.INSTANCE;
        ArrayList ePackages = new ArrayList(registry.values());
        for (Object object : ePackages) {
            EPackage ePackage;
            if (object instanceof EPackage.Descriptor) {
                try {
                    ePackage = ((EPackage.Descriptor)object).getEPackage();
                }
                catch (WrappedException x) {
                    if (x.exception() instanceof ClassNotFoundException) continue;
                    throw x;
                }
            } else {
                ePackage = (EPackage)object;
            }
            if (ePackage == null || !ePackage.getNsPrefix().equals(nsPrefix)) continue;
            nsURI = ePackage.getNsURI();
            break;
        }
        return nsURI;
    }

    private static Location createLocation(URI uri) {
        try {
            return Location.location((URI)uri);
        }
        catch (TeamRepositoryException teamRepositoryException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return null;
    }

    public static IItemHandle getItemHandle(URI uri) {
        Location location = ItemUtilities.createLocation(uri);
        IItemHandle handle = location != null ? location.getItemHandle() : null;
        return handle;
    }

    public static String getValue(String query, String key) {
        int i;
        if (query.startsWith(String.valueOf(key) + "=")) {
            i = key.length() + 1;
        } else {
            i = query.indexOf("&" + key + "=");
            if (i == -1) {
                return null;
            }
            i += key.length() + 2;
        }
        int j = query.indexOf("&", i);
        if (j == -1) {
            j = query.length();
        }
        return query.substring(i, j);
    }

    public static boolean isStateUnique(IItemHandle target, IItemHandle[] handles) {
        ItemHandleAwareHashSet states = new ItemHandleAwareHashSet(Arrays.asList(handles));
        int count = 0;
        for (IItemHandle state : states) {
            if (!state.sameItemId(target)) continue;
            ++count;
        }
        return count <= 1;
    }

    public static boolean isStateUnique(IItemHandle target, List<IItemHandle> handles) {
        ItemHandleAwareHashSet states = new ItemHandleAwareHashSet(handles);
        int count = 0;
        for (IItemHandle state : states) {
            if (!state.sameItemId(target)) continue;
            ++count;
        }
        return count <= 1;
    }
}

