/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.common.common.parser.jcl;

import java.util.List;
import java.util.Map;

public class JclStringUtil {
    public static String addSingleQuotes(String s) {
        return "'" + s + "'";
    }

    public static String strip(String s) {
        return JclStringUtil.stripBoth(s, ' ');
    }

    public static String strip(String s, char c) {
        return JclStringUtil.stripBoth(s, c);
    }

    public static String strip(String s, char c, char d) {
        switch (String.valueOf(d).toUpperCase()) {
            case "B": {
                return JclStringUtil.stripBoth(s, c);
            }
            case "L": {
                return JclStringUtil.stripLeading(s, c);
            }
            case "T": {
                return JclStringUtil.stripTrailing(s, c);
            }
        }
        new IllegalArgumentException();
        return JclStringUtil.stripBoth(s, c);
    }

    public static String stripParenthesis(String s) {
        return s.startsWith("(") && s.endsWith(")") ? s.substring(1, s.length() - 1) : s;
    }

    public static String stripInnerQuotes(String s) {
        return s.contains("'") ? s.replace("''", "``").replaceAll("'(.*?)'", "$1").replace("``", "'") : s;
    }

    public static String stripSingleQuotes(String s) {
        return s.startsWith("'") && s.endsWith("'") ? s.substring(1, s.length() - 1).replace("''", "'") : s;
    }

    public static String stripSpecial(String s) {
        if (s.startsWith("('")) {
            return JclStringUtil.addSingleQuotes(JclStringUtil.stripInnerQuotes(JclStringUtil.stripParenthesis(s)));
        }
        if (s.startsWith("(")) {
            return JclStringUtil.stripParenthesis(s);
        }
        if (s.startsWith("'")) {
            return JclStringUtil.stripSingleQuotes(s);
        }
        return s;
    }

    public static List<String> stripList(List<String> l) {
        int i = 0;
        while (i < l.size()) {
            String stripped;
            String getValue = l.get(i);
            if (!getValue.equals(stripped = JclStringUtil.stripSpecial(getValue))) {
                l.set(i, stripped);
            }
            ++i;
        }
        return l;
    }

    public static Map<String, String> stripMap(Map<String, String> m) {
        for (Map.Entry<String, String> entry : m.entrySet()) {
            if (!JclStringUtil.isSpecial(entry.getValue())) continue;
            m.put(entry.getKey(), JclStringUtil.stripSpecial(entry.getValue()));
        }
        return m;
    }

    public static boolean isSpecial(String s) {
        return s != null && !s.isEmpty() && (JclStringUtil.isParenthesis(s) || JclStringUtil.isQuoted(s));
    }

    private static boolean isQuoted(String s) {
        return s.startsWith("'") && s.endsWith("'");
    }

    private static boolean isParenthesis(String s) {
        return s.matches("^\\((?![^\\(]+\\).*\\().*\\)$");
    }

    private static String stripBoth(String s, char c) {
        return JclStringUtil.stripTrailing(JclStringUtil.stripLeading(s, c), c);
    }

    private static String stripLeading(String s, char c) {
        char[] a = s.toCharArray();
        int i = -1;
        while (a[++i] == c) {
        }
        return new String(a, i, a.length - i);
    }

    private static String stripTrailing(String s, char c) {
        char[] a = s.toCharArray();
        int i = a.length;
        while (a[--i] == c) {
        }
        return new String(a, 0, i + 1);
    }
}

