/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.common.common.parser.jcl;

import com.ibm.team.enterprise.common.common.parser.jcl.IJclResultDDVolume;
import com.ibm.team.enterprise.common.common.parser.jcl.IJclResultSubParm;
import com.ibm.team.enterprise.common.common.parser.jcl.JclResultDataSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class JclResultDDVolume
implements IJclResultDDVolume {
    private String privat = "";
    private String retain = "";
    private String sequence = "";
    private String count = "";
    private String reference = "";
    private String volume = "";
    private final List<String> volumes = new ArrayList<String>();

    public JclResultDDVolume(JclResultDataSet ds) {
        if (ds.getSubParameters().containsKey("VOL") || ds.getSubParameters().containsKey("VOLUME")) {
            List<IJclResultSubParm> subParameters = ds.getSubParameters().containsKey("VOL") ? ds.getSubParameters().get("VOL") : ds.getSubParameters().get("VOLUME");
            if (subParameters != null & !subParameters.isEmpty()) {
                switch (subParameters.size()) {
                    case 5: {
                        this.setVolumes(subParameters.get(4));
                    }
                    case 4: {
                        if (subParameters.get(3).hasKeywords()) {
                            this.setVolumes(subParameters.get(3));
                        } else {
                            this.count = subParameters.get(3).getValue();
                        }
                    }
                    case 3: {
                        if (subParameters.get(2).hasKeywords()) {
                            this.setVolumes(subParameters.get(2));
                        } else {
                            this.sequence = subParameters.get(2).getValue();
                        }
                    }
                    case 2: {
                        if (subParameters.get(1).hasKeywords()) {
                            this.setVolumes(subParameters.get(1));
                        } else {
                            this.retain = subParameters.get(1).getValue();
                        }
                    }
                    case 1: {
                        if (subParameters.get(0).hasKeywords()) {
                            this.setVolumes(subParameters.get(0));
                            break;
                        }
                        this.privat = subParameters.get(0).getValue();
                    }
                }
            } else {
                this.volume = ds.getParameters().getOrDefault("VOLUME", "");
            }
        } else {
            this.volume = ds.getParameters().getOrDefault("VOLUME", "");
        }
    }

    private void setVolumes(IJclResultSubParm sp) {
        if (sp.getKeywords().containsKey("REF")) {
            this.reference = sp.getKeywords().getOrDefault("REF", "");
        } else {
            this.volume = sp.getKeywords().getOrDefault("SER", "");
            this.volumes.addAll((Collection<String>)sp.getKeywordValues().get("SER"));
        }
    }

    @Override
    public final String getPrivate() {
        return this.privat;
    }

    @Override
    public final String getRetain() {
        return this.retain;
    }

    @Override
    public final String getSequence() {
        return this.sequence;
    }

    @Override
    public final String getCount() {
        return this.count;
    }

    @Override
    public final String getReference() {
        return this.reference;
    }

    @Override
    public final String getVolume() {
        return this.volume;
    }

    @Override
    public final List<String> getVolumes() {
        return this.volumes;
    }
}

