/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.common.common.parser.jcl;

import com.ibm.team.enterprise.common.common.parser.jcl.JclPreParsed;
import com.ibm.team.enterprise.common.common.parser.jcl.JclStatement;
import com.ibm.team.enterprise.common.common.parser.nls.Messages;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JclPreParser {
    private static final String Card = "%1$-80s";
    private static final String Charset = "UTF8";
    private static final String Comma = ",";
    private static final String Empty = "";
    private static final String Space = " ";
    private static final String Trailing = "\\s++$";
    private static final Pattern DelimiterPattern = Pattern.compile(".*,DLM=(?:([A-Z0-9$#@]{2,8})|'(.{2,8})')(?: |\\,|$).*");
    private static final Pattern StatementPattern = Pattern.compile("\\/\\/([A-Z$#@][A-Z0-9$#@]+)?\\s+([A-Z]+)\\s+(.*)");
    private static final Pattern Jes2CmdPattern = Pattern.compile("\\/\\*\\$(A|ACTIVATE|ADD|B|C|D|DEL|E|F|G|H|I|JDDETAILS|JDHISTORY|JDJES|JDMONITOR|JDSTATUS|JSTOP|L|M[0-9]{1,2}|MSPL|N[0-9]{1,4}|N|O|P|R|S|T|VS|Z|ZAPJOB|)\\s?(.*)");
    private static final Pattern Jes2StmtPattern = Pattern.compile("\\/\\*($|JOBPARM|MESSAGE|NETACCT|NOTIFY|OUTPUT|PRIORITY|ROUTE|SETUP|SIGNOFF|SIGNON|XEQ|XMIT)\\s(.*)");
    private static final Pattern Jes3CmdPattern = Pattern.compile("\\/\\/\\*\\*(CALL|X|CANCEL|C|DELAY|D|DISABLE|H|DUMP|ENABLE|N|ERASE|E|FAIL|FREE|INQUIRY|I|LOGOFF|LOGON|MESSAGE|Z|MODIFY|F|RESTART|R|RETURN|SEND|T|START|S|SWITCH|TRACE|VARY|V)[\\s|,](.*)");
    private static final Pattern Jes3StmtPattern = Pattern.compile("\\/\\/\\*(DATASET|ENDDATASET|ENDPROCESS|FORMAT|MAIN|NET|NETACCT|OPERATOR|PAUSE|PROCESS|ROUTE)\\s(.*)");
    private File file;
    private InputStream inputStream;
    private String path;
    private String delimiter = "/* ";

    public JclPreParser(File file) {
        this.file = file;
    }

    public JclPreParser(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public JclPreParser(String path) {
        this.path = path;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final JclPreParsed parse() throws Exception {
        JclPreParsed result = new JclPreParsed();
        if (this.file != null) {
            this.inputStream = new FileInputStream(this.file);
        }
        if (this.path != null) {
            this.inputStream = new FileInputStream(new File(this.path));
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                InputStreamReader isr = new InputStreamReader(this.inputStream, Charset);
                try {
                    try (BufferedReader br = new BufferedReader(isr);){
                        JclStatement statement = null;
                        String line = null;
                        String read = null;
                        while ((read = br.readLine()) != null) {
                            Matcher m;
                            if (read.equals(Empty)) continue;
                            line = this.formatLine(read);
                            statement = new JclStatement();
                            statement.getLines().add(line);
                            statement.getReads().add(read);
                            result.getStatements().add(statement);
                            if (line.startsWith("//* ")) {
                                statement.setType(JclStatement.StatementType.COMMENT);
                                statement.setId("//* ".trim());
                                statement.setName(Empty);
                                statement.setOperation(Empty);
                                statement.setParameters(Empty);
                                statement.setComments(this.trimTrailing(line.substring(4)));
                                statement.setStatement(line);
                                continue;
                            }
                            if (line.startsWith("//*")) {
                                if (this.isJes3Command(line)) {
                                    statement.setType(JclStatement.StatementType.JES3);
                                    statement.setId("//*".trim());
                                    statement.setName(Empty);
                                    if (line.startsWith("//**")) {
                                        m = Jes3CmdPattern.matcher(line.substring(0, 71));
                                        if (!m.matches()) throw new Exception(MessageFormat.format(Messages.JclPreParser_J3ERROR, this.path, line));
                                        statement.setOperation(m.group(1));
                                        statement.setParameters(m.group(2));
                                        statement.setComments(Empty);
                                    } else {
                                        m = Jes3StmtPattern.matcher(line.substring(0, 71));
                                        if (!m.matches()) throw new Exception(MessageFormat.format(Messages.JclPreParser_J3ERROR, this.path, line));
                                        statement.setOperation(m.group(1));
                                        if (line.startsWith("//*ENDPROCESS") | line.startsWith("//*PAUSE")) {
                                            statement.setParameters(Empty);
                                            statement.setComments(m.group(2).trim());
                                        } else {
                                            statement.setParameters(m.group(2).trim());
                                            statement.setComments(Empty);
                                        }
                                    }
                                    statement.setStatement(line);
                                    continue;
                                }
                                statement.setType(JclStatement.StatementType.COMMENT);
                                statement.setId("//* ".trim());
                                statement.setName(Empty);
                                statement.setOperation(Empty);
                                statement.setParameters(Empty);
                                statement.setComments(line.substring(4).trim());
                                statement.setStatement(line);
                                continue;
                            }
                            if (line.startsWith(this.delimiter)) {
                                statement.setType(JclStatement.StatementType.DELIMITER);
                                statement.setId(this.delimiter.trim());
                                statement.setName(Empty);
                                statement.setOperation(Empty);
                                statement.setParameters(Empty);
                                statement.setComments(line.replace(this.delimiter, Empty).trim());
                                statement.setStatement(line);
                                continue;
                            }
                            if (line.startsWith("/*")) {
                                statement.setType(JclStatement.StatementType.JES2);
                                statement.setId("/*".trim());
                                statement.setName(Empty);
                                if (line.startsWith("/*$")) {
                                    m = Jes2CmdPattern.matcher(line.substring(0, 71));
                                    if (!m.matches()) throw new Exception(MessageFormat.format(Messages.JclPreParser_J2ERROR, this.path, line));
                                    statement.setOperation(m.group(1));
                                    statement.setParameters(m.group(2));
                                } else {
                                    m = Jes2StmtPattern.matcher(line.substring(0, 71));
                                    if (!m.matches()) throw new Exception(MessageFormat.format(Messages.JclPreParser_J2ERROR, this.path, line));
                                    statement.setOperation(m.group(1));
                                    statement.setParameters(m.group(2));
                                }
                                statement.setComments(Empty);
                                statement.setStatement(line);
                                continue;
                            }
                            if (line.trim().equals("//")) {
                                statement.setType(JclStatement.StatementType.NULL);
                                statement.setId("//".trim());
                                statement.setName(Empty);
                                statement.setOperation(Empty);
                                statement.setParameters(Empty);
                                statement.setComments(Empty);
                                statement.setStatement(line);
                                continue;
                            }
                            if (line.startsWith("//")) {
                                statement.setType(JclStatement.StatementType.STATEMENT);
                                statement.setId("//".trim());
                                StringBuffer sb = new StringBuffer();
                                StringBuffer cm = new StringBuffer();
                                Matcher m2 = StatementPattern.matcher(line.substring(0, 71));
                                if (!m2.matches()) throw new Exception(MessageFormat.format(Messages.JclPreParser_NOMATCH, line));
                                sb.append("//");
                                if (m2.group(1) != null) {
                                    sb.append(m2.group(1));
                                }
                                sb.append(Space);
                                sb.append(m2.group(2));
                                sb.append(Space);
                                String parms = m2.group(3);
                                if (parms != null && !parms.isEmpty()) {
                                    String cmnts;
                                    String[] pandc;
                                    boolean finiQuote = false;
                                    boolean openQuote = this.isOpenQuote(parms);
                                    boolean endsComma = this.isEndsComma(this.parseParms(parms));
                                    while (openQuote || endsComma) {
                                        if (openQuote) {
                                            sb.append(parms);
                                            read = this.readLine(br);
                                            line = this.formatLine(read);
                                            if (read.length() < 16) {
                                                throw new Exception(MessageFormat.format(Messages.JclPreParser_INVALID_QUOTE, read));
                                            }
                                            statement.getLines().add(line);
                                            statement.getReads().add(read);
                                            parms = line.substring(15, 71);
                                            endsComma = this.isEndsComma(this.parseParms(parms, openQuote));
                                            openQuote = this.isOpenQuote(parms, openQuote);
                                            boolean bl = finiQuote = !openQuote;
                                        }
                                        if (!endsComma) continue;
                                        pandc = this.removeComments(parms, finiQuote);
                                        parms = pandc[0];
                                        cmnts = pandc[1];
                                        sb.append(parms);
                                        cm.append(cmnts);
                                        read = this.readLine(br);
                                        line = this.formatLine(read);
                                        if (read.length() < 4) {
                                            throw new Exception(MessageFormat.format(Messages.JclPreParser_INVALID_COMMA, read));
                                        }
                                        statement.getLines().add(line);
                                        statement.getReads().add(read);
                                        parms = line.substring(3, 71).trim();
                                        openQuote = this.isOpenQuote(parms);
                                        endsComma = this.isEndsComma(this.parseParms(parms));
                                        finiQuote = false;
                                    }
                                    pandc = this.removeComments(parms, finiQuote);
                                    parms = pandc[0];
                                    cmnts = pandc[1];
                                    sb.append(parms);
                                    cm.append(cmnts);
                                    if (!line.endsWith(Space)) {
                                        while (line.length() >= 72 && !line.substring(71, 72).equals(Space)) {
                                            read = this.readLine(br);
                                            line = this.formatLine(read);
                                            if (line.length() < 4) {
                                                throw new Exception(MessageFormat.format(Messages.JclPreParser_INVALID_SPACE, line));
                                            }
                                            statement.getLines().add(line);
                                            statement.getReads().add(read);
                                            cmnts = line.substring(3, 71).trim();
                                            cm.append(Space).append(cmnts);
                                        }
                                    }
                                }
                                line = sb.toString();
                                String[] tokens = this.tokenize(line);
                                statement.setName(tokens[0]);
                                statement.setOperation(tokens[1]);
                                statement.setParameters(tokens[2]);
                                statement.setComments(cm.toString().trim());
                                statement.setStatement(String.valueOf(line) + cm.toString());
                                if (!"DD".equals(statement.getOperation())) continue;
                                this.setDelimiter(statement.getParameters());
                                continue;
                            }
                            statement.setType(JclStatement.StatementType.INLINE);
                            statement.setId(Empty);
                            statement.setName(Empty);
                            statement.setOperation(Empty);
                            statement.setParameters(Empty);
                            statement.setComments(Empty);
                            statement.setStatement(line);
                        }
                    }
                    if (isr == null) return result;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (isr == null) throw throwable;
                    isr.close();
                    throw throwable;
                }
                isr.close();
                return result;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new Exception(MessageFormat.format(Messages.JclPreParser_IOERROR, this.path), e);
        }
    }

    private final String formatLine(String line) {
        return String.format(Card, line).substring(0, 72);
    }

    private final boolean isEndsComma(String parms) {
        return parms.endsWith(Comma);
    }

    private final boolean isJes3Command(String line) {
        if (line.startsWith("//**")) {
            Matcher m = Jes3CmdPattern.matcher(line);
            return m.matches();
        }
        if (line.startsWith("//*DATASET")) {
            return true;
        }
        if (line.startsWith("//*ENDDATASET")) {
            return true;
        }
        if (line.startsWith("//*ENDPROCESS")) {
            return true;
        }
        if (line.startsWith("//*FORMAT")) {
            return true;
        }
        if (line.startsWith("//*MAIN")) {
            return true;
        }
        if (line.startsWith("//*NET")) {
            return true;
        }
        if (line.startsWith("//*NETACCT")) {
            return true;
        }
        if (line.startsWith("//*OPERATOR")) {
            return true;
        }
        if (line.startsWith("//*PAUSE")) {
            return true;
        }
        if (line.startsWith("//*PROCESS")) {
            return true;
        }
        return line.startsWith("//*ROUTE");
    }

    private final boolean isOpenQuote(String parms) {
        return this.isOpenQuote(parms, false);
    }

    private final boolean isOpenQuote(String parms, boolean started) {
        char[] cArray = parms.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '\'') {
                started = !started;
            }
            ++n2;
        }
        return started;
    }

    private final String readLine(BufferedReader br) {
        String line = null;
        try {
            line = br.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return line;
    }

    private final String parseParms(String parms) {
        String[] result = this.removeComments(parms, false);
        return result[0];
    }

    private final String parseParms(String parms, boolean started) {
        String[] result = this.removeComments(parms, started);
        return result[0];
    }

    private final String[] removeComments(String parms, boolean started) {
        String[] result = new String[2];
        boolean stopped = false;
        StringBuffer sb = new StringBuffer();
        StringBuffer cm = new StringBuffer();
        char[] cArray = parms.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!stopped) {
                if (c == '\'') {
                    started = !started;
                }
                if (c == ' ' & !started) {
                    stopped = true;
                    cm.append(c);
                } else {
                    sb.append(c);
                }
            } else {
                cm.append(c);
            }
            ++n2;
        }
        result[0] = sb.toString();
        result[1] = this.trimTrailing(cm.toString());
        return result;
    }

    private final void setDelimiter(String parms) throws Exception {
        Matcher m = DelimiterPattern.matcher(parms);
        this.delimiter = m.matches() ? (m.group(1) != null ? String.valueOf(m.group(1)) + Space : String.valueOf(m.group(2)) + Space) : "/* ";
    }

    private final String[] tokenize(String line) throws Exception {
        Matcher m = StatementPattern.matcher(line);
        String[] result = new String[3];
        if (!m.matches()) {
            throw new Exception(MessageFormat.format(Messages.JclPreParser_NOMATCH, line));
        }
        result[0] = m.group(1) == null ? Empty : m.group(1);
        result[1] = m.group(2);
        result[2] = m.group(3) == null ? Empty : m.group(3);
        return result;
    }

    private final String trimTrailing(String s) {
        return s.replaceFirst(Trailing, Empty);
    }
}

