/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.common.common.parser.jcl;

import com.ibm.team.enterprise.common.common.parser.ParseResult;
import com.ibm.team.enterprise.common.common.parser.Parser;
import com.ibm.team.enterprise.common.common.parser.ParserInput;
import com.ibm.team.enterprise.common.common.parser.ParserRejected;
import com.ibm.team.enterprise.common.common.parser.jcl.JclResultSubParm;
import com.ibm.team.enterprise.common.common.parser.jcl.JclStringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JclParserParameters {
    private static final String ParmListRegex = "([^,\\(']+|[A-Z@#$][A-Z0-9@#$]+=([^,\\('](?:[^,]+)?|'.*?(?:(?<!')'|''')|\\([^\\(]+\\)|\\((?:[^\\(]+)?\\([^\\()]+\\)(?:[^\\()]+)?(?:\\([^\\()]+\\)(?:[^\\()]+)?)?\\))|'.*?(?:(?<!')'|''')|\\([^\\(]+\\)|\\((?:[^\\(]+)?\\([^\\()]+\\)(?:[^\\()]+)?(?:\\([^\\()]+\\)(?:[^\\()]+)?)?\\)|(?=[\\s\\S]))(?:,| |$)";
    private static final Pattern ParmListPattern = Pattern.compile("([^,\\(']+|[A-Z@#$][A-Z0-9@#$]+=([^,\\('](?:[^,]+)?|'.*?(?:(?<!')'|''')|\\([^\\(]+\\)|\\((?:[^\\(]+)?\\([^\\()]+\\)(?:[^\\()]+)?(?:\\([^\\()]+\\)(?:[^\\()]+)?)?\\))|'.*?(?:(?<!')'|''')|\\([^\\(]+\\)|\\((?:[^\\(]+)?\\([^\\()]+\\)(?:[^\\()]+)?(?:\\([^\\()]+\\)(?:[^\\()]+)?)?\\)|(?=[\\s\\S]))(?:,| |$)");
    private static final String SKClassifier = "subparmKeywords";
    private static Parser<ParseResult> SubparmKeywords = Parser.sequence(Parser.keywords(), Parser.optional(Parser.parameters())).classifier("subparmKeywords");

    public static class JclParameters
    extends Parser.AbstractParser<ParseResult> {
        private String errorMsg;
        private final String key;

        public JclParameters(String key) {
            this.key = key;
        }

        @Override
        public ParseResult parseImpl(ParserInput in) throws ParserRejected {
            String value;
            Map keywords;
            ParseResult result = null;
            if (in.pr != null && in.pr.map.containsKey("keywords") && (keywords = (Map)in.pr.map.get("keywords")).containsKey(this.key) && JclStringUtil.isSpecial(value = (String)keywords.get(this.key))) {
                result = new ParseResult(this);
                ArrayList<JclResultSubParm> valueList = new ArrayList<JclResultSubParm>();
                value = JclStringUtil.stripSpecial(value);
                keywords.put(this.key, value);
                Matcher m = ParmListPattern.matcher(value);
                while (m.find()) {
                    String sp = JclStringUtil.stripSpecial(m.group(1));
                    JclResultSubParm subParameter = new JclResultSubParm();
                    subParameter.setValue(sp);
                    if (m.group(1).startsWith("(")) {
                        ParseResult prm = Parser.parameters().parse(sp);
                        subParameter.setValues((List)prm.get("parameters"));
                        int i = 0;
                        while (i < subParameter.getValues().size()) {
                            String stripped;
                            String getValue = subParameter.getValues().get(i);
                            if (!getValue.equals(stripped = JclStringUtil.stripSpecial(getValue))) {
                                subParameter.getValues().set(i, stripped);
                                sp = sp.replace(getValue, stripped);
                            }
                            ++i;
                        }
                    }
                    if (sp.matches("[A-Z@#$][A-Z0-9@#$]+=.*$")) {
                        List values;
                        ParseResult pr = (ParseResult)SubparmKeywords.parse(sp);
                        ParseResult prKey = (ParseResult)pr.get("keywords");
                        ParseResult prPrm = (ParseResult)pr.get("parameters");
                        subParameter.setKeywords((Map)prKey.get("keywords"));
                        if (prPrm != null && (values = (List)prPrm.get("parameters")) != null && !values.isEmpty()) {
                            if (subParameter.getValues() == null) {
                                subParameter.setValues(values);
                            } else {
                                subParameter.getValues().addAll(values);
                            }
                        }
                        for (Map.Entry<String, String> entry : subParameter.getKeywords().entrySet()) {
                            HashMap<String, List<String>> keywordValues = new HashMap<String, List<String>>();
                            HashMap<String, Map<String, String>> keywordKeywords = new HashMap<String, Map<String, String>>();
                            if (entry.getValue().startsWith("(")) {
                                ParseResult epr;
                                String entryValue = JclStringUtil.stripParenthesis(entry.getValue());
                                subParameter.getKeywords().put(entry.getKey(), entryValue);
                                if (entryValue.matches("[A-Z@#$][A-Z0-9@#$]+=.*$")) {
                                    epr = Parser.keywords().parse(entryValue);
                                    keywordKeywords.put(entry.getKey(), (Map)epr.get("keywords"));
                                } else {
                                    epr = Parser.parameters().parse(entryValue);
                                    keywordValues.put(entry.getKey(), (List)epr.get("parameters"));
                                }
                            }
                            if (!keywordValues.isEmpty()) {
                                subParameter.setKeywordValues(keywordValues);
                            }
                            if (keywordKeywords.isEmpty()) continue;
                            subParameter.setKeywordKeywords(keywordKeywords);
                        }
                    }
                    valueList.add(subParameter);
                }
                if (value.endsWith(",")) {
                    JclResultSubParm subParameter = new JclResultSubParm();
                    subParameter.setValue("");
                    valueList.add(subParameter);
                }
                result.map.put(this.key, valueList);
            }
            return result;
        }

        @Override
        public String errorMessage() {
            return this.errorMsg;
        }
    }
}

