/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.common.common.parser.jcl;

import com.ibm.team.enterprise.common.common.parser.ParseResult;
import com.ibm.team.enterprise.common.common.parser.Parser;
import com.ibm.team.enterprise.common.common.parser.ParserInput;
import com.ibm.team.enterprise.common.common.parser.ParserRejected;
import com.ibm.team.enterprise.common.common.parser.jcl.JclResultExecParm;
import com.ibm.team.enterprise.common.common.parser.jcl.JclStringUtil;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JclParserExecParm {
    private static final String ParmListRegex = "(.*?)(?:,|$)";
    private static final Pattern ParmListPattern = Pattern.compile("(.*?)(?:,|$)");

    public static class JclExecParm
    extends Parser.AbstractParser<ParseResult> {
        private String errorMsg;
        private final String key;

        public JclExecParm(String key) {
            this.key = key;
        }

        @Override
        public ParseResult parseImpl(ParserInput in) throws ParserRejected {
            String value;
            Map keywords;
            ParseResult result = null;
            if (in.pr != null && in.pr.map.containsKey("keywords") && (keywords = (Map)in.pr.map.get("keywords")).containsKey(this.key) && (value = (String)keywords.get(this.key)) != null && !value.isEmpty()) {
                result = new ParseResult(this);
                if (value.startsWith("(") && value.endsWith(")")) {
                    value = JclStringUtil.stripParenthesis(value);
                    keywords.put(this.key, value);
                }
                if (value.startsWith("'") && value.endsWith("'")) {
                    value = JclStringUtil.stripSingleQuotes(value);
                    keywords.put(this.key, value);
                }
                JclResultExecParm execParm = new JclResultExecParm();
                Matcher m = ParmListPattern.matcher(value);
                while (m.find() && m.start() != value.length()) {
                    execParm.getParameters().add(m.group(1));
                }
                result.map.put(this.key, execParm);
            }
            return result;
        }

        @Override
        public String errorMessage() {
            return this.errorMsg;
        }
    }
}

