/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.common.common.parser.jcl;

import com.ibm.team.enterprise.common.common.parser.ParseResult;
import com.ibm.team.enterprise.common.common.parser.ParserException;
import com.ibm.team.enterprise.common.common.parser.ParserRejected;
import com.ibm.team.enterprise.common.common.parser.jcl.IJclResult;
import com.ibm.team.enterprise.common.common.parser.jcl.IJclResultCondition;
import com.ibm.team.enterprise.common.common.parser.jcl.IJclResultExecParm;
import com.ibm.team.enterprise.common.common.parser.jcl.JclParser;
import com.ibm.team.enterprise.common.common.parser.jcl.JclPreParsed;
import com.ibm.team.enterprise.common.common.parser.jcl.JclPreParser;
import com.ibm.team.enterprise.common.common.parser.jcl.JclResult;
import com.ibm.team.enterprise.common.common.parser.jcl.JclResultComment;
import com.ibm.team.enterprise.common.common.parser.jcl.JclResultDataDef;
import com.ibm.team.enterprise.common.common.parser.jcl.JclResultDataSet;
import com.ibm.team.enterprise.common.common.parser.jcl.JclResultJob;
import com.ibm.team.enterprise.common.common.parser.jcl.JclResultStep;
import com.ibm.team.enterprise.common.common.parser.jcl.JclStatement;
import com.ibm.team.enterprise.common.common.parser.jcl.JclStringUtil;
import com.ibm.team.enterprise.common.common.parser.nls.Messages;
import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JclParse {
    private static final String Empty = "";
    private static final Map<String, String> DDParameters;
    private static final Map<String, String> JobParameters;
    private String path;
    private File file;
    private InputStream inputStream;
    private Map<String, String> symbols;

    static {
        HashMap<String, String> loadMap = new HashMap<String, String>();
        loadMap.put("ddAmp", "AMP");
        loadMap.put("ddChars", "CHARS");
        loadMap.put("ddCopies", "COPIES");
        loadMap.put("ddDcb", "DCB");
        loadMap.put("ddDest", "DEST");
        loadMap.put("ddDisp", "DISP");
        loadMap.put("ddDsid", "DSID");
        loadMap.put("ddDsn", "DSN");
        loadMap.put("ddDsname", "DSNAME");
        loadMap.put("ddDsntype", "DSNTYPE");
        loadMap.put("ddFcb", "FCB");
        loadMap.put("ddFlash", "FLASH");
        loadMap.put("ddLabel", "LABEL");
        loadMap.put("ddModify", "MODIFY");
        loadMap.put("ddOutput", "OUTPUT");
        loadMap.put("ddPathDisp", "PATHDISP");
        loadMap.put("ddPathMode", "PATHMODE");
        loadMap.put("ddPathOpts", "PATHOPTS");
        loadMap.put("ddRoAccess", "ROACCESS");
        loadMap.put("ddSecModel", "SECMODEL");
        loadMap.put("ddSpace", "SPACE");
        loadMap.put("ddSubsys", "SUBSYS");
        loadMap.put("ddSymbols", "SYMBOLS");
        loadMap.put("ddSymList", "SYMLIST");
        loadMap.put("ddSysout", "SYSOUT");
        loadMap.put("ddUcs", "UCS");
        loadMap.put("ddUnit", "UNIT");
        loadMap.put("ddVol", "VOL");
        loadMap.put("ddVolume", "VOLUME");
        DDParameters = Collections.unmodifiableMap(loadMap);
        loadMap = new HashMap();
        loadMap.put("jobBytes", "BYTES");
        loadMap.put("jobCards", "CARDS");
        loadMap.put("jobCond", "COND");
        loadMap.put("jobJeslog", "JESLOG");
        loadMap.put("jobJobRc", "JOBRC");
        loadMap.put("jobLines", "LINES");
        loadMap.put("jobMsgLevel", "MSGLEVEL");
        loadMap.put("jobPages", "PAGES");
        loadMap.put("jobPassword", "PASSWORD");
        loadMap.put("jobRegionx", "REGIONX");
        loadMap.put("jobRestart", "RESTART");
        loadMap.put("jobSecLabel", "SECLABEL");
        loadMap.put("jobSysAff", "SYSAFF");
        loadMap.put("jobSystem", "SYSTEM");
        loadMap.put("jobTime", "TIME");
        JobParameters = Collections.unmodifiableMap(loadMap);
    }

    public JclParse(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public JclParse(String path) {
        this.path = path;
    }

    public final IJclResult parse() throws ParserException {
        JclPreParsed jclPreParsed;
        JclPreParser jclPreParser;
        if (this.path != null) {
            this.file = new File(this.path);
            jclPreParser = new JclPreParser(this.file);
        } else {
            jclPreParser = new JclPreParser(this.inputStream);
        }
        try {
            jclPreParsed = jclPreParser.parse();
        }
        catch (Exception e) {
            throw new ParserException(e);
        }
        JclResult jclResult = new JclResult();
        jclResult.setJclFile(this.file);
        jclResult.setJclInput(this.inputStream);
        jclResult.setFilePath(this.path);
        jclResult.setFileName(this.file != null ? this.file.getName() : null);
        if (this.symbols != null) {
            jclResult.getSymbols().putAll(JclStringUtil.stripMap(this.symbols));
        }
        JclStatement.StatementType lastType = null;
        for (JclStatement statement : jclPreParsed.getStatements()) {
            if (statement.getType().isStatement()) {
                statement.setParameters(jclResult.getSymbols().substitute(statement.getParameters()));
            }
            try {
                block2 : switch (statement.getType()) {
                    case COMMENT: {
                        if (statement.getType().equals((Object)lastType)) {
                            jclResult.getCurrentComment().getComments().add(statement.getComments());
                            break;
                        }
                        JclResultComment jclResultComment = new JclResultComment();
                        jclResultComment.getComments().add(statement.getComments());
                        jclResult.getComments().add(jclResultComment);
                        jclResult.setCurrentComment(jclResultComment);
                        break;
                    }
                    case INLINE: {
                        if (jclResult.getCurrentDD() != null) {
                            Object ds = jclResult.getCurrentDD().getLastDataset();
                            if (ds != null) {
                                if (ds.getParameter().equals("*") || ds.getParameter().equals("DATA")) {
                                    ds.getInline().add(statement.getStatement());
                                    break;
                                }
                                throw new ParserException(String.format(Messages.JclParse_INLINE_INVALID, jclResult.getCurrentDD().getName()));
                            }
                            throw new ParserException(String.format(Messages.JclParse_INLINE_NO_DS, jclResult.getCurrentDD().getName()));
                        }
                        throw new ParserException(Messages.JclParse_INLINE_NO_DD);
                    }
                    case STATEMENT: {
                        switch (statement.getOperation()) {
                            case "EXEC": {
                                ParseResult subParmsResult;
                                ParseResult parseResult = JclParser.JCL_EXEC.parse(statement.getParameters());
                                ParseResult positionResult = (ParseResult)parseResult.get("keyword");
                                ParseResult reparserResult = (ParseResult)parseResult.get("reparse");
                                ParseResult keywordsResult = (ParseResult)reparserResult.get("keywords");
                                JclResultStep jclResultStep = new JclResultStep(statement);
                                jclResultStep.setPgmName(((Map)positionResult.map.get("keyword")).getOrDefault("PGM", Empty));
                                jclResultStep.setProcName(((Map)positionResult.map.get("keyword")).getOrDefault("PROC", Empty));
                                jclResultStep.setCommentBlock(jclResult.getCurrentComment());
                                jclResultStep.getParameters().putAll(JclStringUtil.stripMap((Map)keywordsResult.get("keywords")));
                                if (reparserResult.map.containsKey("execCond")) {
                                    subParmsResult = (ParseResult)reparserResult.get("execCond");
                                    jclResultStep.setCondition((IJclResultCondition)subParmsResult.map.get("execCond"));
                                }
                                if (reparserResult.map.containsKey("execParm")) {
                                    subParmsResult = (ParseResult)reparserResult.get("execParm");
                                    jclResultStep.setExecParm((IJclResultExecParm)subParmsResult.map.get("PARM"));
                                }
                                jclResult.getSteps().add(jclResultStep);
                                jclResult.setCurrentStep(jclResultStep);
                                jclResult.setCurrentComment(null);
                                break block2;
                            }
                            case "DD": {
                                ParseResult subParmsResult;
                                ParseResult parseResult = JclParser.JCL_DD.parse(statement.getParameters());
                                ParseResult positionResult = (ParseResult)parseResult.get("parameter");
                                ParseResult reparserResult = (ParseResult)parseResult.get("reparse");
                                ParseResult keywordsResult = (ParseResult)reparserResult.get("keywords");
                                JclResultDataSet jclResultDataSet = new JclResultDataSet();
                                jclResultDataSet.setParameter(positionResult.map.getOrDefault("parameter", null));
                                jclResultDataSet.getParameters().putAll((Map)keywordsResult.get("keywords"));
                                for (Map.Entry<String, String> entry : DDParameters.entrySet()) {
                                    String clsfier = entry.getKey();
                                    String keyword = entry.getValue();
                                    if (!reparserResult.map.containsKey(clsfier)) continue;
                                    subParmsResult = (ParseResult)reparserResult.get(clsfier);
                                    jclResultDataSet.getSubParameters().put(keyword, (List)subParmsResult.map.get(keyword));
                                }
                                if (statement.getName().equals(Empty)) {
                                    jclResult.getCurrentDD().getDatasets().add(jclResultDataSet);
                                    break block2;
                                }
                                JclResultDataDef jclResultDataDef = new JclResultDataDef(statement);
                                jclResultDataDef.setDataset(jclResultDataSet);
                                jclResult.getCurrentStep().getDataDefs().add(jclResultDataDef);
                                jclResult.setCurrentDD(jclResultDataDef);
                                break block2;
                            }
                            case "JOB": {
                                ParseResult subParmsResult;
                                ParseResult parseResult = JclParser.JCL_JOB.parse(statement.getParameters());
                                ParseResult reparserResult = (ParseResult)parseResult.get("reparse");
                                ParseResult keywordsResult = (ParseResult)reparserResult.get("keywords");
                                JclResultJob JclResultJob2 = new JclResultJob(statement);
                                JclResultJob2.getParameters().putAll(JclStringUtil.stripMap((Map)keywordsResult.get("keywords")));
                                ParseResult positionResult = (ParseResult)parseResult.get("accounting");
                                JclResultJob2.setAccounting(JclStringUtil.stripSpecial((String)positionResult.map.getOrDefault("accounting", Empty)));
                                positionResult = (ParseResult)parseResult.get("programmer");
                                JclResultJob2.setProgrammer(JclStringUtil.stripSpecial((String)positionResult.map.getOrDefault("programmer", Empty)));
                                for (Map.Entry<String, String> entry : JobParameters.entrySet()) {
                                    String clsfier = entry.getKey();
                                    String keyword = entry.getValue();
                                    if (!reparserResult.map.containsKey(clsfier)) continue;
                                    subParmsResult = (ParseResult)reparserResult.get(clsfier);
                                    JclResultJob2.getSubParameters().put(keyword, (List)subParmsResult.map.get(keyword));
                                }
                                jclResult.setJob(JclResultJob2);
                                break block2;
                            }
                            case "PROC": {
                                ParseResult parseResult = JclParser.JCL_PROC.parse(statement.getParameters());
                                jclResult.getSymbols().putAll(JclStringUtil.stripMap((Map)parseResult.get("keywords")));
                                break block2;
                            }
                            case "SET": {
                                ParseResult parseResult = JclParser.JCL_PROC.parse(statement.getParameters());
                                jclResult.getSymbols().putAll(JclStringUtil.stripMap((Map)parseResult.get("keywords")));
                            }
                        }
                    }
                }
            }
            catch (ParserRejected e) {
                throw new ParserException(e);
            }
            lastType = statement.getType();
        }
        return jclResult;
    }

    public void setSymbols(Map<String, String> symbols) {
        this.symbols = symbols;
    }
}

