/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.common.common.parser;

import com.ibm.team.enterprise.common.common.parser.ParseResult;
import com.ibm.team.enterprise.common.common.parser.Parser;
import com.ibm.team.enterprise.common.common.parser.ParserInput;
import com.ibm.team.enterprise.common.common.parser.ParserRejected;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParserParameters {
    private static final String groupKeyword = "keywd";
    private static final String stringComma = ",";
    private static final String stringEmpty = "";
    private static final String ParameterRegex = "^([^,\\('=]+|'.*?(?:(?<!')'|''')|\\([^\\(]+\\)|\\((?:[^\\(]+)?\\([^\\()]+\\)(?:[^\\()]+)?(?:\\([^\\()]+\\)(?:[^\\()]+)?)?\\)|(?=[\\s\\S]))(?:,| |$)";
    private static final String ParametersRegex = "([^,\\('=]+|(?<keywd>[A-Z@#$][A-Z0-9@#$]+)=([^,\\('](?:[^,]+)?|'.*?(?:(?<!')'|''')|\\([^\\(]+\\)|\\((?:[^\\(]+)?\\([^\\()]+\\)(?:[^\\()]+)?(?:\\([^\\()]+\\)(?:[^\\()]+)?)?\\))|'.*?(?:(?<!')'|''')|\\([^\\(]+\\)|\\((?:[^\\(]+)?\\([^\\()]+\\)(?:[^\\()]+)?(?:\\([^\\()]+\\)(?:[^\\()]+)?)?\\)|(?=[\\s\\S]))(?:,| |$)";
    private static final Pattern ParameterPattern = Pattern.compile("^([^,\\('=]+|'.*?(?:(?<!')'|''')|\\([^\\(]+\\)|\\((?:[^\\(]+)?\\([^\\()]+\\)(?:[^\\()]+)?(?:\\([^\\()]+\\)(?:[^\\()]+)?)?\\)|(?=[\\s\\S]))(?:,| |$)");
    private static final Pattern ParametersPattern = Pattern.compile("([^,\\('=]+|(?<keywd>[A-Z@#$][A-Z0-9@#$]+)=([^,\\('](?:[^,]+)?|'.*?(?:(?<!')'|''')|\\([^\\(]+\\)|\\((?:[^\\(]+)?\\([^\\()]+\\)(?:[^\\()]+)?(?:\\([^\\()]+\\)(?:[^\\()]+)?)?\\))|'.*?(?:(?<!')'|''')|\\([^\\(]+\\)|\\((?:[^\\(]+)?\\([^\\()]+\\)(?:[^\\()]+)?(?:\\([^\\()]+\\)(?:[^\\()]+)?)?\\)|(?=[\\s\\S]))(?:,| |$)");

    public static class ParameterParser
    extends Parser.AbstractParser<ParseResult> {
        private String errorMsg;

        public ParameterParser() {
            this.classifier("parameter");
        }

        @Override
        public ParseResult parseImpl(ParserInput in) throws ParserRejected {
            String stringToMatch;
            ParseResult result = new ParseResult(this);
            this.errorMsg = stringToMatch = in.string.toString().substring(in.cursor);
            Matcher m = ParameterPattern.matcher(stringToMatch);
            if (m.find()) {
                result.map.put(this.classifier(), m.group(1));
                in.cursor += m.end() - m.start();
            } else if (stringToMatch.endsWith(ParserParameters.stringComma)) {
                result.map.put(this.classifier(), ParserParameters.stringEmpty);
            }
            return result;
        }

        @Override
        public String errorMessage() {
            return this.errorMsg;
        }
    }

    public static class ParametersParser
    extends Parser.AbstractParser<ParseResult> {
        private String errorMsg;

        public ParametersParser() {
            this.classifier("parameters");
        }

        @Override
        public ParseResult parseImpl(ParserInput in) throws ParserRejected {
            String stringToMatch;
            ParseResult result = new ParseResult(this);
            ArrayList<String> values = new ArrayList<String>();
            this.errorMsg = stringToMatch = in.string.toString().substring(in.cursor);
            Matcher m = ParametersPattern.matcher(stringToMatch);
            while (m.find()) {
                if (m.group(ParserParameters.groupKeyword) == null) {
                    values.add(m.group(1));
                }
                in.cursor += m.end() - m.start();
            }
            if (stringToMatch.endsWith(ParserParameters.stringComma)) {
                values.add(ParserParameters.stringEmpty);
            }
            result.map.put(this.classifier(), values);
            return result;
        }

        @Override
        public String errorMessage() {
            return this.errorMsg;
        }
    }
}

