/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.common.common.parser;

import com.ibm.team.enterprise.common.common.parser.ParseResult;
import com.ibm.team.enterprise.common.common.parser.Parser;
import com.ibm.team.enterprise.common.common.parser.ParserInput;
import com.ibm.team.enterprise.common.common.parser.ParserRejected;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParserKeywords {
    private static final String KeywordRegex = "^([A-Z@#$][A-Z0-9@#$]+)=([^,\\('](?:[^,]+)?|'.*?(?:(?<!')'|''')|\\([^\\(]+\\)|\\((?:[^\\(]+)?\\([^\\()]+\\)(?:[^\\()]+)?(?:\\([^\\()]+\\)(?:[^\\()]+)?)?\\)|\\((?:(?:[A-Z0-9@#$]+)?(?:\\(.+?\\))?[,]?)+\\))(?:,|\\w|$)";
    private static final String KeywordsRegex = "([A-Z@#$][A-Z0-9@#$]+)=([^,\\('](?:[^,]+)?|'.*?(?:(?<!')'|''')|\\([^\\(]+\\)|\\((?:[^\\(]+)?\\([^\\()]+\\)(?:[^\\()]+)?(?:\\([^\\()]+\\)(?:[^\\()]+)?)?\\)|\\((?:(?:[A-Z0-9@#$]+)?(?:\\(.+?\\))?[,]?)+\\))(?:,|\\w|$)";
    private static final Pattern KeywordPattern = Pattern.compile("^([A-Z@#$][A-Z0-9@#$]+)=([^,\\('](?:[^,]+)?|'.*?(?:(?<!')'|''')|\\([^\\(]+\\)|\\((?:[^\\(]+)?\\([^\\()]+\\)(?:[^\\()]+)?(?:\\([^\\()]+\\)(?:[^\\()]+)?)?\\)|\\((?:(?:[A-Z0-9@#$]+)?(?:\\(.+?\\))?[,]?)+\\))(?:,|\\w|$)");
    private static final Pattern KeywordsPattern = Pattern.compile("([A-Z@#$][A-Z0-9@#$]+)=([^,\\('](?:[^,]+)?|'.*?(?:(?<!')'|''')|\\([^\\(]+\\)|\\((?:[^\\(]+)?\\([^\\()]+\\)(?:[^\\()]+)?(?:\\([^\\()]+\\)(?:[^\\()]+)?)?\\)|\\((?:(?:[A-Z0-9@#$]+)?(?:\\(.+?\\))?[,]?)+\\))(?:,|\\w|$)");

    public static class KeywordParser
    extends Parser.AbstractParser<ParseResult> {
        private String errorMsg;

        public KeywordParser() {
            this.classifier("keyword");
        }

        @Override
        public ParseResult parseImpl(ParserInput in) throws ParserRejected {
            String stringToMatch;
            ParseResult result = new ParseResult(this);
            HashMap<String, String> keywords = new HashMap<String, String>();
            this.errorMsg = stringToMatch = in.string.toString().substring(in.cursor);
            Matcher m = KeywordPattern.matcher(stringToMatch);
            if (m.find()) {
                keywords.put(m.group(1), m.group(2));
                in.cursor += m.end() - m.start();
            }
            result.map.put(this.classifier(), keywords);
            return result;
        }

        @Override
        public String errorMessage() {
            return this.errorMsg;
        }
    }

    public static class KeywordsParser
    extends Parser.AbstractParser<ParseResult> {
        private String errorMsg;

        public KeywordsParser() {
            this.classifier("keywords");
        }

        @Override
        public ParseResult parseImpl(ParserInput in) throws ParserRejected {
            String stringToMatch;
            ParseResult result = new ParseResult(this);
            HashMap<String, String> keywords = new HashMap<String, String>();
            StringBuffer sb = new StringBuffer();
            this.errorMsg = stringToMatch = in.string.toString().substring(in.cursor);
            int findStart = 0;
            Matcher m = KeywordsPattern.matcher(stringToMatch);
            while (m.find()) {
                keywords.put(m.group(1), m.group(2));
                if (findStart != m.start(1)) {
                    sb.append(stringToMatch.substring(findStart, m.start(1)));
                }
                in.cursor += m.end() - findStart;
                findStart = m.end();
            }
            if (sb.length() > 0) {
                if (in.cursor < in.size) {
                    sb.append(in.string.toString().substring(in.cursor));
                }
                if (sb.toString().endsWith(",")) {
                    sb.setLength(sb.length() - 1);
                }
                in.string = sb.toString();
                in.size = in.string.length();
                in.cursor = 0;
            }
            result.map.put(this.classifier(), keywords);
            return result;
        }

        @Override
        public String errorMessage() {
            return this.errorMsg;
        }
    }
}

