/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.common.common.parser;

import com.ibm.team.enterprise.common.common.parser.ParseResult;
import com.ibm.team.enterprise.common.common.parser.ParserInput;
import com.ibm.team.enterprise.common.common.parser.ParserKeywords;
import com.ibm.team.enterprise.common.common.parser.ParserParameters;
import com.ibm.team.enterprise.common.common.parser.ParserRejected;
import com.ibm.team.enterprise.common.common.parser.ParserReparse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface Parser<T> {
    public static final String WHITESPACE = "\\s*";
    public static final String KeywordClassifier = "keyword";
    public static final String KeywordsClassifier = "keywords";
    public static final String ParameterClassifier = "parameter";
    public static final String ParametersClassifier = "parameters";
    public static final String ReparserClassifier = "reparse";
    public static final HashMap<String, Object> EMPTY_MAP = new HashMap();

    public T parseImpl(ParserInput var1) throws ParserRejected;

    default public T parse(String in) throws ParserRejected {
        return this.parse(new ParserInput(in));
    }

    default public T parse(ParserInput in) throws ParserRejected {
        T result = null;
        int cursor = in.cursor;
        try {
            result = this.parseImpl(in);
        }
        catch (Exception e) {
            if (e instanceof ParserRejected) {
                in.cursor = cursor;
                throw e;
            }
            throw new ParserRejected(this, in.cursor, e);
        }
        return result;
    }

    default public String errorMessage() {
        return null;
    }

    default public Parser<T> getParser() {
        return this;
    }

    default public String classifier() {
        return null;
    }

    default public Parser<T> classifier(String classifier) {
        return this;
    }

    default public Parser<ParseResult> then(Parser<?> next) {
        return new SequenceParser(this, next);
    }

    public static Parser<String> token() {
        return new TokenParser("\\w+", false);
    }

    public static Parser<String> token(String literal) {
        return new TokenParser(literal, false);
    }

    public static Parser<String> tokenAnyCase(String literal) {
        return new TokenParser(literal, false);
    }

    public static Parser<String> literal(String literal) {
        return new LiteralParser(literal, false);
    }

    public static Parser<String> literalAnyCase(String literal) {
        return new LiteralParser(literal, false);
    }

    public static <T> Parser<T> optional(Parser<T> parser) {
        return new OptionalParser<T>(parser);
    }

    public static Parser<String> optional(String literal) {
        return in -> {
            try {
                Parser.literal(literal).parse(in);
                return null;
            }
            catch (ParserRejected pr) {
                return null;
            }
        };
    }

    public static <T> Parser<T> skip(Parser<T> parser) {
        return in -> {
            parser.parse(in);
            return null;
        };
    }

    public static Parser<String> skip(String literal) {
        return Parser.skip(Parser.literal(literal));
    }

    public static Parser<ArrayList<String>> regex(String pattern) {
        return new RegexParser(pattern, true);
    }

    public static Parser<ArrayList<String>> regexAnyCase(String pattern) {
        return new RegexParser(pattern, false);
    }

    public static Parser<ParseResult> sequence(Parser<?> ... parsers) {
        return new SequenceParser(parsers);
    }

    public static Parser<ParseResult> oneOf(Parser<?> ... parsers) {
        return new OneOfParser(parsers);
    }

    public static Parser<ParseResult> zeroOrMore(Parser<?> parser) {
        return new ZeroOrMoreParser(parser);
    }

    public static Parser<ParseResult> zeroOrMore(Parser<?> parser, Parser<?> separator) {
        return new ZeroOrMoreParser(parser, separator);
    }

    public static Parser<ParseResult> keyword() {
        return new ParserKeywords.KeywordParser();
    }

    public static Parser<ParseResult> keywords() {
        return new ParserKeywords.KeywordsParser();
    }

    public static Parser<ParseResult> parameter() {
        return new ParserParameters.ParameterParser();
    }

    public static Parser<ParseResult> parameters() {
        return new ParserParameters.ParametersParser();
    }

    public static Parser<ParseResult> reparse(Parser<?> parser, Parser<?> ... reparser) {
        return new ParserReparse.ReparseParser(parser, reparser);
    }

    default public <U> Parser<U> map(Function<T, U> f) {
        return in -> f.apply(this.parse(in));
    }

    default public <U> Parser<Map> map() {
        return this.map(r -> r instanceof ParseResult ? ((ParseResult)r).map : EMPTY_MAP);
    }

    public static abstract class AbstractParser<T>
    implements Parser<T> {
        private String classifier;

        @Override
        public String classifier() {
            return this.classifier;
        }

        @Override
        public Parser<T> classifier(String classifier) {
            this.classifier = classifier;
            return this;
        }
    }

    public static class LiteralParser
    extends AbstractParser<String> {
        private final Pattern pattern;
        private String literal;

        public LiteralParser(String literal, boolean caseSensitive) {
            this(literal, Pattern.quote(literal), caseSensitive);
            this.literal = literal;
        }

        LiteralParser(String literal, String pattern, boolean caseSensitive) {
            this.literal = literal;
            this.pattern = Pattern.compile(pattern);
        }

        @Override
        public String parseImpl(ParserInput in) throws ParserRejected {
            String result = null;
            Matcher matcher = this.pattern.matcher(in.string);
            matcher.region(in.cursor, in.size);
            boolean matches = matcher.find();
            if (!matches) {
                throw new ParserRejected(this, in.cursor);
            }
            int i = matcher.groupCount() == 0 ? 0 : 1;
            result = in.string.subSequence(matcher.start(i), matcher.end(i)).toString();
            in.cursor = matcher.end();
            return result;
        }

        @Override
        public String errorMessage() {
            return this.literal;
        }
    }

    public static class OneOfParser
    extends AbstractParser<ParseResult> {
        private final Parser<?>[] parsers;

        OneOfParser(Parser<?> ... parsers) {
            this.parsers = parsers;
        }

        @Override
        public ParseResult parseImpl(ParserInput in) throws ParserRejected {
            ParseResult result = new ParseResult(this);
            Parser<?>[] parserArray = this.parsers;
            if (this.parsers.length != 0) {
                Parser<?> parser = parserArray[0];
                Object r = parser.parse(in);
                if (r != null) {
                    result.add(parser, r);
                }
            }
            if (result.results.isEmpty()) {
                throw new ParserRejected(this, in);
            }
            return result;
        }
    }

    public static class OptionalParser<T>
    extends AbstractParser<T> {
        private final Parser<T> parser;

        public OptionalParser(Parser<T> parser) {
            this.parser = parser;
        }

        @Override
        public T parseImpl(ParserInput in) throws ParserRejected {
            try {
                return this.parser.parse(in);
            }
            catch (ParserRejected pr) {
                return null;
            }
        }

        @Override
        public Parser<T> getParser() {
            return this.parser;
        }

        @Override
        public String classifier() {
            return super.classifier() != null ? super.classifier() : this.parser.classifier();
        }
    }

    public static class RegexParser
    extends AbstractParser<ArrayList<String>> {
        private final Pattern pattern;

        public RegexParser(String pattern, boolean caseSensitive) {
            this.pattern = caseSensitive ? Pattern.compile(pattern) : Pattern.compile(pattern, 2);
        }

        @Override
        public ArrayList<String> parseImpl(ParserInput in) throws ParserRejected {
            ArrayList<String> result = new ArrayList<String>();
            CharSequence string = in.string;
            Matcher matcher = this.pattern.matcher(string);
            matcher.region(in.cursor, in.size);
            boolean matches = matcher.find();
            if (matches) {
                int i = 0;
                while (i <= matcher.groupCount()) {
                    result.add(string.subSequence(matcher.start(i), matcher.end(i)).toString());
                    ++i;
                }
            } else {
                throw new ParserRejected(this, in);
            }
            in.cursor = matcher.end();
            return result;
        }
    }

    public static class SequenceParser
    extends AbstractParser<ParseResult> {
        private final Parser<?>[] parsers;

        SequenceParser(Parser<?> ... parsers) {
            this.parsers = parsers;
        }

        @Override
        public ParseResult parseImpl(ParserInput in) throws ParserRejected {
            ParseResult result = new ParseResult(this);
            Parser<?>[] parserArray = this.parsers;
            int n = this.parsers.length;
            int n2 = 0;
            while (n2 < n) {
                Parser<?> parser = parserArray[n2];
                Object r = parser.parse(in);
                if (r != null) {
                    result.add(parser, r);
                }
                ++n2;
            }
            return result;
        }
    }

    public static class TokenParser
    extends LiteralParser {
        public TokenParser(String literal, boolean caseSensitive) {
            super(literal, "\\s*(" + literal + ")" + Parser.WHITESPACE, caseSensitive);
        }
    }

    public static class ZeroOrMoreParser
    extends AbstractParser<ParseResult> {
        private final Parser<?> parser;
        private Parser<?> separator = null;

        ZeroOrMoreParser(Parser<?> parser) {
            this(parser, null);
        }

        ZeroOrMoreParser(Parser<?> parser, Parser<?> separator) {
            this.parser = parser;
            this.separator = separator;
        }

        @Override
        public ParseResult parseImpl(ParserInput in) throws ParserRejected {
            ParseResult result = new ParseResult(this);
            try {
                while (true) {
                    Object r;
                    if ((r = this.parser.parse(in)) != null) {
                        result.add(this.parser, r);
                    }
                    if (this.separator == null) continue;
                    this.separator.parse(in);
                }
            }
            catch (ParserRejected parserRejected) {
                return result;
            }
        }
    }
}

