/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.common.common.feed;

import com.ibm.team.repository.common.IChangeEvent;
import com.ibm.team.repository.common.IContext;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.service.IChangeEventService;
import java.sql.Timestamp;
import java.util.Properties;

public class ChangeEventHelper {
    public static IChangeEvent createChangeEvent(String eventType, String title, String description, IItemHandle itemHandle, IChangeEventService changeEventService) throws TeamRepositoryException {
        return ChangeEventHelper.createChangeEvent(eventType, title, description, itemHandle, null, changeEventService);
    }

    public static IChangeEvent createChangeEvent(String eventType, String title, String description, IItemHandle itemHandle, Properties properties, IChangeEventService changeEventService) throws TeamRepositoryException {
        IChangeEvent event = (IChangeEvent)IChangeEvent.ITEM_TYPE.createItem();
        event.setCategory("com.ibm.team.enterprise.event.category");
        event.setContextId(IContext.PUBLIC);
        event.setTitle(title);
        event.setDescription(description);
        if (itemHandle != null) {
            event.setItem(itemHandle);
        }
        if (properties != null) {
            for (String name : properties.stringPropertyNames()) {
                event.setStringExtension(name, properties.getProperty(name));
            }
        }
        event.setStringExtension("com.ibm.team.enterprise.event.type", eventType);
        event.setTime(ChangeEventHelper.now());
        return changeEventService.save(event);
    }

    public static boolean isEEProvider(String url) {
        String enterpriseProvider = "provider=ee";
        return url.contains(enterpriseProvider);
    }

    private static Timestamp now() {
        return new Timestamp(System.currentTimeMillis());
    }
}

