/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.common.common;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class PerfCounter {
    public static Log classLogger = LogFactory.getLog(PerfCounter.class);
    public static final String CREATE = "create";
    public static final String READ = "read";
    public static final String UPDATE = "update";
    public static final String DELETE = "delete";
    public static final String QUERY = "query";
    private Log logger;
    private boolean isLogging = false;
    private PrintWriter tracer;
    private boolean isTracing = false;
    private boolean isEnabled = false;
    private String context;
    private final HashMap<String, Metrics> metrics = new HashMap(3);

    public static PerfCounter makeCounter(PrintWriter tracer, Log logger, String context) {
        return tracer != null ? new PerfCounter(tracer, context) : new PerfCounter(logger, context);
    }

    public PerfCounter(Log logger, String context) {
        if (logger != null) {
            this.logger = logger;
            this.context = context;
            this.isLogging = true;
            this.isEnabled = true;
        }
    }

    public PerfCounter(Log logger) {
        this(logger, logger == null ? "" : logger.getClass().getSimpleName());
    }

    public PerfCounter(PrintWriter tracer, String context) {
        if (tracer != null) {
            this.tracer = tracer;
            this.context = context;
            this.isTracing = true;
            this.isEnabled = true;
        }
    }

    public void start(String subcontext) {
        if (this.isEnabled) {
            try {
                Metrics metrix = this.metrics.get(subcontext);
                if (metrix == null) {
                    metrix = new Metrics();
                    this.metrics.put(subcontext, metrix);
                }
                metrix.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void mark(String subcontext) {
        if (this.isEnabled) {
            try {
                long mark = System.currentTimeMillis();
                Metrics metrix = this.metrics.get(subcontext);
                if (metrix == null) {
                    this.start(subcontext);
                } else {
                    metrix.mark(mark);
                    String msg = String.valueOf(this.context) + "." + subcontext + ": " + " elapsed=" + metrix.currentElapsed;
                    this.log(msg);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void stop(String subcontext) {
        if (this.isEnabled) {
            try {
                Metrics metrix = this.metrics.get(subcontext);
                if (metrix != null) {
                    metrix.stop();
                    long currentElapsed = metrix.currentElapsed;
                    String msg = String.valueOf(this.context) + "." + subcontext + ": " + (metrix.cumulative != currentElapsed ? " elapsed=" + currentElapsed : "") + " total=" + metrix.cumulative;
                    this.log(msg);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void stop(boolean logStats) {
        if (this.isEnabled) {
            try {
                Iterator<Map.Entry<String, Metrics>> iterator = this.metrics.entrySet().iterator();
                long aggregate = 0L;
                while (iterator.hasNext()) {
                    Map.Entry<String, Metrics> next = iterator.next();
                    Metrics metrix = next.getValue();
                    metrix.stop();
                    if (logStats) {
                        String subcontext = next.getKey();
                        String msg = String.valueOf(this.context) + "." + subcontext + ": " + " count=" + metrix.count + " total=" + metrix.cumulative + " min=" + metrix.min + " max=" + metrix.max + " avg=" + (metrix.count <= 0 ? "--" : Long.valueOf(metrix.cumulative / (long)metrix.count));
                        aggregate += metrix.cumulative;
                        this.log(msg);
                    }
                    iterator.remove();
                }
                if (logStats) {
                    this.log(String.valueOf(this.context) + " aggregate time = " + aggregate);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void log(String msg) {
        if (this.isTracing) {
            this.tracer.println(msg);
        }
        if (this.isLogging) {
            this.logger.debug((Object)msg);
        }
    }

    public static void main(String[] argv) {
        PrintWriter pw = new PrintWriter(System.out);
        try {
            System.out.println("-------");
            PerfCounter pc = new PerfCounter(pw, "Resource1");
            pc.start(CREATE);
            Thread.sleep(2112L);
            pc.stop(CREATE);
            pw.flush();
            System.out.println("-------");
            PerfCounter p1 = new PerfCounter(pw, "Resource1");
            p1.start(CREATE);
            Thread.sleep(10L);
            p1.mark(CREATE);
            Thread.sleep(113L);
            p1.stop(CREATE);
            p1.start(READ);
            Thread.sleep(3L);
            p1.mark(READ);
            Thread.sleep(63L);
            p1.mark(READ);
            Thread.sleep(37L);
            p1.stop(READ);
            p1.start(UPDATE);
            Thread.sleep(7L);
            p1.mark(UPDATE);
            Thread.sleep(234L);
            p1.stop(UPDATE);
            p1.stop(true);
            pw.flush();
            System.out.println("-------");
            PerfCounter p2 = new PerfCounter(pw, "Resource2");
            p2.start(CREATE);
            Thread.sleep(278L);
            p2.stop(CREATE);
            p2.stop(CREATE);
            Thread.sleep(1000L);
            p2.start(CREATE);
            Thread.sleep(222L);
            p2.stop(CREATE);
            p2.stop(true);
            pw.flush();
            System.out.println("-------");
            PerfCounter p3 = new PerfCounter(pw, "Resource3");
            p3.start(CREATE);
            Thread.sleep(1938L);
            p3.stop(true);
            pw.flush();
            System.out.println("-------");
            PerfCounter p4 = new PerfCounter(pw, "Resource4");
            p4.start(CREATE);
            Thread.sleep(1938L);
            p4.mark(CREATE);
            Thread.sleep(119L);
            p4.mark(CREATE);
            Thread.sleep(241L);
            p4.mark(CREATE);
            Thread.sleep(350L);
            p4.stop(CREATE);
            p4.mark(CREATE);
            Thread.sleep(100L);
            p4.mark(CREATE);
            Thread.sleep(19L);
            p4.mark(CREATE);
            Thread.sleep(3L);
            p4.mark(CREATE);
            Thread.sleep(7L);
            p4.mark(CREATE);
            Thread.sleep(12L);
            p4.mark(CREATE);
            Thread.sleep(32L);
            p4.mark(CREATE);
            Thread.sleep(2L);
            p4.mark(CREATE);
            Thread.sleep(21L);
            p4.stop(true);
            pw.flush();
            System.out.println("-------");
            long t = System.currentTimeMillis();
            PerfCounter p5 = new PerfCounter(null, "Resource5");
            p5.start(CREATE);
            Thread.sleep(10L);
            p5.mark(CREATE);
            Thread.sleep(113L);
            p5.stop(CREATE);
            p5.stop(true);
            System.out.println("null printwriter elapsed time is " + (System.currentTimeMillis() - t));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static final class Metrics {
        long timer = 0L;
        long currentElapsed = 0L;
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        long cumulative = 0L;
        int count = 0;

        private Metrics() {
        }

        public void start() {
            this.currentElapsed = 0L;
            this.timer = System.currentTimeMillis();
        }

        public void mark(long mark) {
            if (this.timer == 0L) {
                this.currentElapsed = 0L;
                this.timer = mark;
            } else {
                long delta = mark - this.timer;
                this.currentElapsed += delta;
                this.cumulative += delta;
                this.timer = mark;
            }
        }

        public void stop() {
            if (this.timer > 0L) {
                this.mark(System.currentTimeMillis());
                if (this.currentElapsed < this.min) {
                    this.min = this.currentElapsed;
                }
                if (this.currentElapsed > this.max) {
                    this.max = this.currentElapsed;
                }
                ++this.count;
                this.timer = 0L;
            }
        }
    }
}

