/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.common.common;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EnterpriseThreadCache {
    public static Log logger = LogFactory.getLog(EnterpriseThreadCache.class);
    private static ThreadLocal<Map> threadLocalCache = new ThreadLocal<Map>(){

        @Override
        protected Map initialValue() {
            return new HashMap();
        }
    };

    private static Map getCache() {
        return threadLocalCache.get();
    }

    public static void init() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(String.valueOf(Thread.currentThread().getId()) + ":init()"));
        }
        EnterpriseThreadCache.getCache().clear();
    }

    public static void clear() {
        Map cache = EnterpriseThreadCache.getCache();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(String.valueOf(Thread.currentThread().getId()) + ":clear() size=" + cache.size()));
        }
        cache.clear();
        threadLocalCache.remove();
    }

    public static Object get(Class cl, String key) {
        return EnterpriseThreadCache.get(cl.getName(), key);
    }

    public static Object get(String subcachekey, String key) {
        Object result = null;
        try {
            Map subcache = (Map)EnterpriseThreadCache.getCache().get(subcachekey);
            if (subcache != null) {
                SoftReference ref = (SoftReference)subcache.get(key);
                if (ref != null) {
                    result = ref.get();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(String.valueOf(Thread.currentThread().getId()) + ":EnterpriseThreadCache.get(" + subcachekey + "," + key + ")"));
                }
            }
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public static boolean isSubcacheEnabled(String subcachekey) {
        try {
            Map subcache = (Map)EnterpriseThreadCache.getCache().get(subcachekey);
            return subcache != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void put(Class cl, String key, Object value) {
        EnterpriseThreadCache.put(cl.getName(), key, value);
    }

    public static void put(String subcachekey, String key, Object value) {
        try {
            Map subcache = (Map)EnterpriseThreadCache.getCache().get(subcachekey);
            if (subcache != null) {
                subcache.put(key, new SoftReference<Object>(value));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(String.valueOf(Thread.currentThread().getId()) + ":EnterpriseThreadCache.put(" + subcachekey + "," + key + ")"));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void enableSubcache(Class cl) {
        EnterpriseThreadCache.enableSubcache(cl.getName());
    }

    public static void enableSubcache(String subcachekey) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(String.valueOf(Thread.currentThread().getId()) + ":EnterpriseThreadCache.enableSubcache(" + subcachekey + ")"));
        }
        Map cache = EnterpriseThreadCache.getCache();
        cache.put(subcachekey, new HashMap());
    }
}

