/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.common.common;

import com.ibm.team.enterprise.common.common.IEnterpriseConfiguration;
import com.ibm.team.repository.common.IItemType;
import org.eclipse.emf.ecore.EClass;

public class EnterpriseProcessConstants {
    private static EnterpriseProcessConstants instance;
    public static final String SAVE_CONFIGURATION_OPERATION_ID = "com.ibm.teamz.langdef.configuration.save";
    public static final String[] SAVE_CONFIGURATION_OPERATION_CREATE_ACTION;
    public static final String[] SAVE_CONFIGURATION_OPERATION_MODIFY_ACTION;
    public static final String DELETE_CONFIGURATION_OPERATION_ID = "com.ibm.teamz.langdef.configuration.delete";
    public static final String[] DELETE_CONFIGURATION_OPERATION_DELETE_ACTION;

    static {
        SAVE_CONFIGURATION_OPERATION_CREATE_ACTION = new String[]{"create"};
        SAVE_CONFIGURATION_OPERATION_MODIFY_ACTION = new String[]{"modify"};
        DELETE_CONFIGURATION_OPERATION_DELETE_ACTION = new String[]{"delete"};
    }

    public static final synchronized EnterpriseProcessConstants instance() {
        if (instance == null) {
            instance = new EnterpriseProcessConstants();
        }
        return instance;
    }

    public String getOperationId(IItemType itemType, ProcessAction action) {
        EClass eclass = (EClass)itemType.getAdapter(EClass.class);
        if (eclass.equals(IEnterpriseConfiguration.ITEM_TYPE.getAdapter(EClass.class))) {
            switch (action) {
                case CREATE: 
                case MODIFY: {
                    return SAVE_CONFIGURATION_OPERATION_ID;
                }
                case DELETE: {
                    return DELETE_CONFIGURATION_OPERATION_ID;
                }
            }
        }
        return "";
    }

    public String[] getOperationActions(String operationId, ProcessAction action) {
        switch (operationId) {
            case "com.ibm.teamz.langdef.configuration.save": {
                switch (action) {
                    case CREATE: {
                        return new String[]{"create"};
                    }
                    case MODIFY: {
                        return new String[]{"modify"};
                    }
                }
                break;
            }
            case "com.ibm.teamz.langdef.configuration.delete": {
                return new String[]{"delete"};
            }
        }
        return new String[0];
    }

    public static enum ProcessAction {
        CREATE,
        MODIFY,
        DELETE;

    }
}

