/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.common.common;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugLog;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import java.io.PrintWriter;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EnterpriseLog
implements IDebugLog {
    private static final String stackElement = "    %s";
    private static final String FATAL = "FATAL: ";
    private static final String ERROR = "ERROR: ";
    private static final String WARN = "WARN:  ";
    private static final String INFO = "INFO:  ";
    private static final String FLOW = "FLOW:  ";
    private static final String DEBUG = "DEBUG: ";
    private static final String TRACE = "TRACE: ";
    private static final String ITEMS = "ITEMS: ";
    private Log log;
    private Logger logger;
    private static final ThreadLocal<PrintWriter> buildLog = new ThreadLocal();
    private static ThreadLocal<Boolean> dualLog = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    public EnterpriseLog(Class targetClass) {
        this.log = LogFactory.getLog((Class)targetClass);
        this.logger = LogManager.getLogger((Class)targetClass);
    }

    public static void init(PrintWriter existingBuildLog) {
        EnterpriseLog.set(existingBuildLog);
    }

    private static void set(PrintWriter newLog) {
        buildLog.set(newLog);
    }

    public static PrintWriter get() {
        return buildLog.get();
    }

    public static void clear() {
        buildLog.remove();
        dualLog.remove();
    }

    public boolean isFatalEnabled() {
        return this.log.isFatalEnabled();
    }

    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }

    public boolean isWarnEnabled() {
        return this.log.isWarnEnabled();
    }

    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    public boolean isFlowEnabled() {
        return this.logger != null ? this.logger.getLevel().isLessSpecificThan(IDebugger.LevelFlow) : this.log.isInfoEnabled();
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    public boolean isItemsEnabled() {
        return this.logger != null ? this.logger.getLevel().isLessSpecificThan(IDebugger.LevelItems) : this.log.isTraceEnabled();
    }

    public void fatal(Object message) {
        if (this.isFatalEnabled()) {
            this.log.fatal(message);
            if (dualLog.get().booleanValue()) {
                this.doLogToBuildLog(EnterpriseLog.formatMessage(FATAL, message));
            }
        }
    }

    public void fatal(Object message, Throwable t) {
        if (this.isFatalEnabled()) {
            this.log.fatal(message, t);
            if (dualLog.get().booleanValue()) {
                this.doLogToBuildLog(EnterpriseLog.formatMessage(FATAL, message), t);
            }
        }
    }

    public void error(Object message) {
        if (this.isErrorEnabled()) {
            this.log.error(message);
            if (dualLog.get().booleanValue()) {
                this.doLogToBuildLog(EnterpriseLog.formatMessage(ERROR, message));
            }
        }
    }

    public void error(Object message, Throwable t) {
        if (this.isErrorEnabled()) {
            this.log.error(message, t);
            if (dualLog.get().booleanValue()) {
                this.doLogToBuildLog(EnterpriseLog.formatMessage(ERROR, message), t);
            }
        }
    }

    public void warn(Object message) {
        if (this.isWarnEnabled()) {
            this.log.warn(message);
            if (dualLog.get().booleanValue()) {
                this.doLogToBuildLog(EnterpriseLog.formatMessage(WARN, message));
            }
        }
    }

    public void warn(Object message, Throwable t) {
        if (this.isWarnEnabled()) {
            this.log.warn(message, t);
            if (dualLog.get().booleanValue()) {
                this.doLogToBuildLog(EnterpriseLog.formatMessage(WARN, message), t);
            }
        }
    }

    public void info(Object message) {
        if (this.isInfoEnabled()) {
            this.log.info(message);
            if (dualLog.get().booleanValue()) {
                this.doLogToBuildLog(EnterpriseLog.formatMessage(INFO, message));
            }
        }
    }

    public void info(Object message, Throwable t) {
        if (this.isInfoEnabled()) {
            this.log.info(message, t);
            if (dualLog.get().booleanValue()) {
                this.doLogToBuildLog(EnterpriseLog.formatMessage(INFO, message), t);
            }
        }
    }

    public void flow(Object message) {
        if (this.isFlowEnabled()) {
            if (this.logger != null) {
                this.logger.log(IDebugger.LevelFlow, message);
            } else {
                this.log.info(message);
            }
            if (dualLog.get().booleanValue()) {
                this.doLogToBuildLog(EnterpriseLog.formatMessage(FLOW, message));
            }
        }
    }

    public void flow(Object message, Throwable t) {
        if (this.isFlowEnabled()) {
            if (this.logger != null) {
                this.logger.log(IDebugger.LevelFlow, message, t);
            } else {
                this.log.info(message, t);
            }
            if (dualLog.get().booleanValue()) {
                this.doLogToBuildLog(EnterpriseLog.formatMessage(FLOW, message), t);
            }
        }
    }

    public void debug(Object message) {
        if (this.isDebugEnabled()) {
            this.log.debug(message);
            if (dualLog.get().booleanValue()) {
                this.doLogToBuildLog(EnterpriseLog.formatMessage(DEBUG, message));
            }
        }
    }

    public void debug(Object message, Throwable t) {
        if (this.isDebugEnabled()) {
            this.log.debug(message, t);
            if (dualLog.get().booleanValue()) {
                this.doLogToBuildLog(EnterpriseLog.formatMessage(DEBUG, message), t);
            }
        }
    }

    public void trace(Object message) {
        if (this.isTraceEnabled()) {
            this.log.trace(message);
            if (dualLog.get().booleanValue()) {
                this.doLogToBuildLog(EnterpriseLog.formatMessage(TRACE, message));
            }
        }
    }

    public void trace(Object message, Throwable t) {
        if (this.isTraceEnabled()) {
            this.log.trace(message, t);
            if (dualLog.get().booleanValue()) {
                this.doLogToBuildLog(EnterpriseLog.formatMessage(TRACE, message), t);
            }
        }
    }

    public void items(Object message) {
        if (this.isItemsEnabled()) {
            if (this.logger != null) {
                this.logger.log(IDebugger.LevelItems, message);
            } else {
                this.log.trace(message);
            }
            if (dualLog.get().booleanValue()) {
                this.doLogToBuildLog(EnterpriseLog.formatMessage(ITEMS, message));
            }
        }
    }

    public void items(Object message, Throwable t) {
        if (this.isItemsEnabled()) {
            if (this.logger != null) {
                this.logger.log(IDebugger.LevelItems, message, t);
            } else {
                this.log.trace(message, t);
            }
            if (dualLog.get().booleanValue()) {
                this.doLogToBuildLog(EnterpriseLog.formatMessage(ITEMS, message), t);
            }
        }
    }

    private void doLogToBuildLog(Object message) {
        PrintWriter buildLog = EnterpriseLog.get();
        if (buildLog != null) {
            buildLog.println(message);
        }
    }

    private void doLogToBuildLog(Object message, Throwable t) {
        PrintWriter buildLog = EnterpriseLog.get();
        if (buildLog != null) {
            buildLog.println(message);
            StackTraceElement[] elements = t.getStackTrace();
            int i = 3;
            while (i < elements.length) {
                buildLog.println(String.format(stackElement, elements[i].toString()));
                ++i;
            }
        }
    }

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log ccmLog) {
        this.log = ccmLog;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void log(Object message) {
        this.doLogToBuildLog(message);
    }

    public boolean isDualLoggingEnabled() {
        return dualLog.get();
    }

    public void setDualLogging(boolean value) {
        dualLog.set(value);
    }

    private static String formatMessage(String type, Object message) {
        return String.valueOf(type) + " [" + Debug.SDF.format(new Date()) + "] " + message;
    }
}

