/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.common.common;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogField;
import com.ibm.team.build.extensions.common.debug.Mnm;
import com.ibm.team.enterprise.common.common.LocalPropertyTable;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class BuildPropertyTable {
    private static final String cls = BuildPropertyTable.class.getSimpleName();
    private static volatile BuildPropertyTable instance;
    private final IDebugger dbg = new Debugger(this.getClass());
    private final Properties propertyTable = new Properties();

    private BuildPropertyTable() {
    }

    public Properties get() {
        return LocalPropertyTable.get().get().isEmpty() ? this.propertyTable : LocalPropertyTable.get().get();
    }

    public IDebugger getDbg() {
        return this.dbg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BuildPropertyTable getInstance() {
        if (instance != null) return instance;
        Class<BuildPropertyTable> clazz = BuildPropertyTable.class;
        synchronized (BuildPropertyTable.class) {
            if (instance != null) return instance;
            instance = new BuildPropertyTable();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void set(Hashtable properties) {
        this.propertyTable.putAll((Map<?, ?>)properties);
    }

    public void set(Properties properties) {
        this.propertyTable.putAll((Map<?, ?>)properties);
    }

    public String replaceProperties(String propertyString) {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.dbg.isDebug()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        if (this.get().isEmpty()) {
            return propertyString;
        }
        Vector<String> fragments = new Vector<String>();
        Vector<String> properties = new Vector<String>();
        this.parsePropertyString(propertyString, fragments, properties);
        String result = this.replacePropertyStrings(fragments, properties);
        if (this.dbg.isDebug()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, result});
        }
        return result;
    }

    private void parsePropertyString(String propertyString, Vector<String> fragments, Vector<String> properties) {
        int sta;
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.dbg.isDebug()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        int ndx = 0;
        int len = propertyString.length();
        int fragmentSta = ndx;
        int fragmentEnd = len;
        while (ndx < len && (sta = propertyString.indexOf(36, ndx)) >= 0) {
            if (len > sta + 1 && propertyString.charAt(sta + 1) == '{') {
                int end = propertyString.indexOf(125, sta + 1);
                if (end > sta + 2) {
                    int propertySta = sta + 2;
                    int propertyEnd = end;
                    properties.addElement(propertyString.substring(propertySta, propertyEnd));
                    fragmentEnd = sta;
                    fragments.addElement(propertyString.substring(fragmentSta, fragmentEnd));
                    fragmentSta = ndx = end + 1;
                    fragmentEnd = fragmentSta + (len - ndx);
                    continue;
                }
                ndx = sta + 1;
                continue;
            }
            ndx = Math.min(sta + 1, len);
        }
        fragments.addElement(propertyString.substring(fragmentSta, fragmentEnd));
        if (this.dbg.isDebug()) {
            int n = 0;
            while (n < fragments.size()) {
                Debug.debug((IDebugger)this.dbg, (String[])new String[]{cls, mnm, "frag", fragments.get(n)});
                ++n;
            }
            n = 0;
            while (n < properties.size()) {
                Debug.debug((IDebugger)this.dbg, (String[])new String[]{cls, mnm, "prop", properties.get(n)});
                ++n;
            }
            String data = Debug.data((String[])new String[]{LogField.valueOf((int)fragments.size()), LogField.valueOf((int)properties.size())});
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, data});
        }
    }

    private String replacePropertyStrings(Vector<String> fragments, Vector<String> properties) {
        StringBuilder sb = new StringBuilder();
        Properties propertyTable = this.get();
        int n = 0;
        while (n < fragments.size()) {
            sb.append(fragments.get(n));
            if (n < properties.size()) {
                String property = properties.get(n);
                if (propertyTable.containsKey(property)) {
                    sb.append(propertyTable.get(property));
                } else {
                    sb.append("${");
                    sb.append(property);
                    sb.append("}");
                }
            }
            ++n;
        }
        return sb.toString();
    }
}

