/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.common.client;

import com.ibm.team.enterprise.common.client.IEnterpriseConfigurationClient;
import com.ibm.team.enterprise.common.common.EnterpriseProcessConstants;
import com.ibm.team.enterprise.common.common.IEnterpriseConfiguration;
import com.ibm.team.enterprise.common.common.IEnterpriseConfigurationHandle;
import com.ibm.team.enterprise.common.common.IEnterpriseConfigurationService;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.ProcessRunnable;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class EnterpriseConfigurationClient
extends EventSource
implements IEnterpriseConfigurationClient {
    private final IClientLibraryContext context;

    public EnterpriseConfigurationClient(IClientLibraryContext context) {
        this.context = context;
    }

    private Object callCancelableService(IProgressMonitor progressMonitor, IClientLibraryContext.IServiceRunnable serviceRunnable) throws TeamRepositoryException {
        return this.getContext().callCancelableService(serviceRunnable, progressMonitor);
    }

    private IClientLibraryContext getContext() {
        return this.context;
    }

    private ITeamRepository getRepository() {
        return this.context.teamRepository();
    }

    private <T> T getService(Class<T> clazz) {
        return (T)this.getContext().getServiceInterface(clazz);
    }

    @Override
    public IEnterpriseConfiguration fetch(final IEnterpriseConfigurationHandle handle, final List<String> properties, IProgressMonitor monitor) throws TeamRepositoryException {
        IEnterpriseConfiguration result = (IEnterpriseConfiguration)this.callCancelableService(monitor, (IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<IEnterpriseConfiguration>(){

            public IEnterpriseConfiguration run(IProgressMonitor monitor) throws TeamRepositoryException {
                if (properties == null) {
                    return ((IEnterpriseConfigurationService)EnterpriseConfigurationClient.this.getService(IEnterpriseConfigurationService.class)).fetch(handle, null);
                }
                return ((IEnterpriseConfigurationService)EnterpriseConfigurationClient.this.getService(IEnterpriseConfigurationService.class)).fetch(handle, properties.toArray(new String[properties.size()]));
            }
        });
        return result;
    }

    @Override
    public IEnterpriseConfiguration fetchComplete(final IEnterpriseConfigurationHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        IEnterpriseConfiguration result = (IEnterpriseConfiguration)this.callCancelableService(monitor, (IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<IEnterpriseConfiguration>(){

            public IEnterpriseConfiguration run(IProgressMonitor monitor) throws TeamRepositoryException {
                return ((IEnterpriseConfigurationService)EnterpriseConfigurationClient.this.getService(IEnterpriseConfigurationService.class)).fetch(handle, null);
            }
        });
        return result;
    }

    @Override
    public IEnterpriseConfiguration fetchProjectArea(final IProjectAreaHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        IEnterpriseConfiguration result = (IEnterpriseConfiguration)this.callCancelableService(monitor, (IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<IEnterpriseConfiguration>(){

            public IEnterpriseConfiguration run(IProgressMonitor monitor) throws TeamRepositoryException {
                return ((IEnterpriseConfigurationService)EnterpriseConfigurationClient.this.getService(IEnterpriseConfigurationService.class)).fetchProjectArea(handle);
            }
        });
        return result;
    }

    @Override
    public IEnterpriseConfigurationHandle save(final IEnterpriseConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
        EnterpriseProcessConstants.ProcessAction action = configuration.isNewItem() ? EnterpriseProcessConstants.ProcessAction.CREATE : EnterpriseProcessConstants.ProcessAction.MODIFY;
        final String operationId = EnterpriseProcessConstants.instance().getOperationId(IEnterpriseConfiguration.ITEM_TYPE, action);
        IEnterpriseConfigurationHandle result = null;
        try {
            result = (IEnterpriseConfigurationHandle)this.callCancelableService(monitor, (IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<IEnterpriseConfigurationHandle>(){

                public IEnterpriseConfigurationHandle run(IProgressMonitor monitor) throws TeamRepositoryException {
                    class SaveItemRunnable
                    extends ProcessRunnable {
                        public IEnterpriseConfigurationHandle handle;
                        private final /* synthetic */ IEnterpriseConfiguration val$configuration;

                        SaveItemRunnable(IEnterpriseConfiguration iEnterpriseConfiguration) {
                            this.val$configuration = iEnterpriseConfiguration;
                        }

                        public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                            this.handle = ((IEnterpriseConfigurationService)EnterpriseConfigurationClient.this.getService(IEnterpriseConfigurationService.class)).save(this.val$configuration);
                            return null;
                        }
                    }
                    SaveItemRunnable runnable = new SaveItemRunnable(configuration);
                    IProcessClientService processService = (IProcessClientService)EnterpriseConfigurationClient.this.getRepository().getClientLibrary(IProcessClientService.class);
                    processService.execute((ProcessRunnable)runnable, operationId, monitor);
                    return runnable.handle;
                }
            });
        }
        catch (TeamRepositoryException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        return result;
    }
}

