/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.common.client;

import com.ibm.team.enterprise.common.client.Activator;
import com.ibm.team.enterprise.common.client.IEnterpriseConfigurationClient;
import com.ibm.team.enterprise.common.common.IEnterpriseConfiguration;
import com.ibm.team.enterprise.common.common.IEnterpriseConfigurationHandle;
import com.ibm.team.enterprise.internal.common.client.nls.Messages;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class EnterpriseConfigurationCache {
    private static EnterpriseConfigurationCache instance;
    private final Map<String, IEnterpriseConfiguration> configurationMap = new HashMap<String, IEnterpriseConfiguration>();

    private EnterpriseConfigurationCache() {
    }

    public static synchronized EnterpriseConfigurationCache getInstance() {
        if (instance == null) {
            instance = new EnterpriseConfigurationCache();
        }
        return instance;
    }

    public final IEnterpriseConfiguration create(IProjectArea projectArea) {
        String projectAreaName = projectArea.getName();
        IEnterpriseConfiguration configuration = (IEnterpriseConfiguration)IEnterpriseConfiguration.ITEM_TYPE.createItem();
        configuration.setName(String.format("%s - Enterprise Extensions Configuration", projectAreaName));
        configuration.setDescription(String.format("Enterprise Extensions configuration information for the %s project area.", projectAreaName));
        configuration.setProjectArea((IProjectAreaHandle)projectArea);
        return configuration;
    }

    public final synchronized IEnterpriseConfiguration createDefault(IProjectAreaHandle projectAreaHandle) {
        String projectAreaKey = projectAreaHandle == null ? "Default" : projectAreaHandle.getItemId().getUuidValue();
        String projectAreaName = "Default";
        IEnterpriseConfiguration configuration = null;
        if (instance.has(projectAreaKey)) {
            configuration = instance.get(projectAreaKey);
        } else {
            configuration = (IEnterpriseConfiguration)IEnterpriseConfiguration.ITEM_TYPE.createItem();
            configuration.setName(String.format("%s - Enterprise Extensions Configuration", projectAreaName));
            configuration.setDescription(String.format("Enterprise Extensions configuration information for the %s project area.", projectAreaName));
            configuration.setCodePage(IEnterpriseConfiguration.EC_DEFAULT_CODEPAGE);
            configuration.setDefaultItem(true);
            configuration.setProjectArea(projectAreaHandle);
            this.configurationMap.put(projectAreaKey, configuration);
        }
        return configuration;
    }

    public final IEnterpriseConfiguration get(IProjectAreaHandle projectArea) {
        return this.configurationMap.get(projectArea.getItemId().getUuidValue());
    }

    public final IEnterpriseConfiguration get(String projectAreaKey) {
        return this.configurationMap.get(projectAreaKey);
    }

    public final boolean has(IProjectAreaHandle projectArea) {
        return this.configurationMap.containsKey(projectArea.getItemId().getUuidValue());
    }

    public final boolean has(String projectAreaKey) {
        return this.configurationMap.containsKey(projectAreaKey);
    }

    public final synchronized IEnterpriseConfiguration fetch(ITeamRepository repository, IProjectAreaHandle projectArea) throws TeamRepositoryException {
        IEnterpriseConfiguration configuration = null;
        if (instance.has(projectArea)) {
            configuration = instance.get(projectArea);
        } else {
            Job job = EnterpriseConfigurationCache.fetchJob(repository, projectArea);
            try {
                job.schedule();
                job.join();
                configuration = instance.get(projectArea);
            }
            catch (InterruptedException e) {
                Activator.log(e);
            }
        }
        return configuration;
    }

    private static Job fetchJob(final ITeamRepository repository, final IProjectAreaHandle projectArea) {
        Job fetchJob = new Job(Messages.EnterpriseConfigurationCache_FETCHING_ITEM){

            protected IStatus run(IProgressMonitor monitor) {
                IEnterpriseConfigurationClient client = (IEnterpriseConfigurationClient)repository.getClientLibrary(IEnterpriseConfigurationClient.class);
                IEnterpriseConfiguration configuration = null;
                try {
                    configuration = client.fetchProjectArea(projectArea, monitor);
                    if (configuration != null) {
                        instance.configurationMap.put(projectArea.getItemId().getUuidValue(), configuration);
                    }
                }
                catch (TeamRepositoryException e) {
                    Activator.log(e);
                }
                return Status.OK_STATUS;
            }
        };
        return fetchJob;
    }

    public final IEnterpriseConfiguration fetch(ITeamRepository teamRepository, IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        IEnterpriseConfigurationClient client = (IEnterpriseConfigurationClient)teamRepository.getClientLibrary(IEnterpriseConfigurationClient.class);
        IEnterpriseConfiguration configuration = null;
        try {
            configuration = client.fetchProjectArea(projectArea, monitor);
            if (configuration != null) {
                this.configurationMap.put(projectArea.getItemId().getUuidValue(), configuration);
            }
        }
        catch (TeamRepositoryException e) {
            Activator.log(e);
            throw new TeamRepositoryException((Throwable)e);
        }
        return configuration;
    }

    public final void remove(IProjectAreaHandle projectArea) {
        this.configurationMap.remove(projectArea.getItemId().getUuidValue());
    }

    public final IEnterpriseConfiguration save(ITeamRepository teamRepository, IEnterpriseConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
        IEnterpriseConfigurationClient client = (IEnterpriseConfigurationClient)teamRepository.getClientLibrary(IEnterpriseConfigurationClient.class);
        try {
            IEnterpriseConfigurationHandle handle = client.save(configuration, monitor);
            configuration = client.fetchComplete(handle, monitor);
            this.configurationMap.put(configuration.getProjectArea().getItemId().getUuidValue(), configuration);
        }
        catch (TeamRepositoryException e) {
            Activator.log(e);
            throw new TeamRepositoryException((Throwable)e);
        }
        return configuration;
    }
}

